/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.io.hbase.SerializableScan;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.hadoop.hbase.client.Scan;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SerializableScanTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private static final SerializableScan DEFAULT_SERIALIZABLE_SCAN = new SerializableScan(new Scan());

    @Test
    public void testSerializationDeserialization() throws Exception {
        Scan scan = new Scan().setStartRow("1".getBytes(StandardCharsets.UTF_8));
        byte[] object = SerializationUtils.serialize((Serializable)new SerializableScan(scan));
        SerializableScan serScan = (SerializableScan)SerializationUtils.deserialize((byte[])object);
        Assert.assertNotNull((Object)serScan);
        Assert.assertEquals((Object)new String(serScan.get().getStartRow(), StandardCharsets.UTF_8), (Object)"1");
    }

    @Test
    public void testConstruction() {
        Assert.assertNotNull((Object)DEFAULT_SERIALIZABLE_SCAN.get());
        this.thrown.expect(NullPointerException.class);
        new SerializableScan(null);
    }
}

