/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;

class HBaseMutationCoder
extends AtomicCoder<Mutation>
implements Serializable {
    private static final HBaseMutationCoder INSTANCE = new HBaseMutationCoder();
    private static final CoderProvider HBASE_MUTATION_CODER_PROVIDER = new HBaseMutationCoderProvider();
    private static final TypeDescriptor<Mutation> HBASE_MUTATION_TYPE_DESCRIPTOR = new TypeDescriptor<Mutation>(){};

    private HBaseMutationCoder() {
    }

    public static HBaseMutationCoder of() {
        return INSTANCE;
    }

    public void encode(Mutation mutation, OutputStream outStream) throws IOException {
        ClientProtos.MutationProto.MutationType type = HBaseMutationCoder.getType(mutation);
        ClientProtos.MutationProto proto = ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)type, (Mutation)mutation);
        proto.writeDelimitedTo(outStream);
    }

    public Mutation decode(InputStream inStream) throws IOException {
        return ProtobufUtil.toMutation((ClientProtos.MutationProto)ClientProtos.MutationProto.parseDelimitedFrom((InputStream)inStream));
    }

    private static ClientProtos.MutationProto.MutationType getType(Mutation mutation) {
        if (mutation instanceof Put) {
            return ClientProtos.MutationProto.MutationType.PUT;
        }
        if (mutation instanceof Delete) {
            return ClientProtos.MutationProto.MutationType.DELETE;
        }
        throw new IllegalArgumentException("Only Put and Delete are supported");
    }

    static CoderProvider getCoderProvider() {
        return HBASE_MUTATION_CODER_PROVIDER;
    }

    private static class HBaseMutationCoderProvider
    extends CoderProvider {
        private HBaseMutationCoderProvider() {
        }

        public <T> Coder<T> coderFor(TypeDescriptor<T> typeDescriptor, List<? extends Coder<?>> componentCoders) throws CannotProvideCoderException {
            if (!typeDescriptor.isSubtypeOf(HBASE_MUTATION_TYPE_DESCRIPTOR)) {
                throw new CannotProvideCoderException(String.format("Cannot provide %s because %s is not a subclass of %s", HBaseMutationCoder.class.getSimpleName(), typeDescriptor, Mutation.class.getName()));
            }
            try {
                HBaseMutationCoder coder = HBaseMutationCoder.of();
                return coder;
            }
            catch (IllegalArgumentException e) {
                throw new CannotProvideCoderException((Throwable)e);
            }
        }
    }
}

