/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.StringUtils;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.hbase.HBaseIO;
import org.apache.beam.sdk.io.hbase.HBaseMutationCoder;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.SourceTestUtils;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.ExternalResource;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HBaseIOTest {
    @Rule
    public final transient @UnknownKeyFor @NonNull @Initialized TestPipeline p = TestPipeline.create();
    @Rule
    public @UnknownKeyFor @NonNull @Initialized ExpectedException thrown = ExpectedException.none();
    @Rule
    public @UnknownKeyFor @NonNull @Initialized TemporaryHBaseTable tmpTable = new TemporaryHBaseTable();
    private static @UnknownKeyFor @NonNull @Initialized HBaseTestingUtility htu;
    private static @UnknownKeyFor @NonNull @Initialized HBaseAdmin admin;
    private static final @UnknownKeyFor @NonNull @Initialized Configuration conf;
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] COLUMN_FAMILY;
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] COLUMN_NAME;
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] COLUMN_EMAIL;

    @BeforeClass
    public static void beforeClass() throws @UnknownKeyFor @NonNull @Initialized Exception {
        conf.setInt("hbase.client.retries.number", 1);
        conf.setStrings("hbase.master.hostname", new String[]{"localhost"});
        conf.setStrings("hbase.regionserver.hostname", new String[]{"localhost"});
        htu = new HBaseTestingUtility(conf);
        htu.startMiniZKCluster();
        MiniHBaseCluster hbm = htu.startMiniHBaseCluster(1, 4);
        hbm.waitForActiveAndReadyMaster();
        admin = htu.getHBaseAdmin();
    }

    @AfterClass
    public static void afterClass() throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (admin != null) {
            admin.close();
            admin = null;
        }
        if (htu != null) {
            htu.shutdownMiniHBaseCluster();
            htu.shutdownMiniZKCluster();
            htu.cleanupTestDir();
            htu = null;
        }
    }

    @Test
    public void testReadBuildsCorrectly() {
        HBaseIO.Read read = HBaseIO.read().withConfiguration(conf).withTableId("table");
        Assert.assertEquals((Object)"table", (Object)read.getTableId());
        Assert.assertNotNull((String)"configuration", (Object)read.getConfiguration());
    }

    @Test
    public void testReadBuildsCorrectlyInDifferentOrder() {
        HBaseIO.Read read = HBaseIO.read().withTableId("table").withConfiguration(conf);
        Assert.assertEquals((Object)"table", (Object)read.getTableId());
        Assert.assertNotNull((String)"configuration", (Object)read.getConfiguration());
    }

    @Test
    public void testWriteBuildsCorrectly() {
        HBaseIO.Write write = HBaseIO.write().withConfiguration(conf).withTableId("table");
        Assert.assertEquals((Object)"table", (Object)write.getTableId());
        Assert.assertNotNull((String)"configuration", (Object)write.getConfiguration());
    }

    @Test
    public void testWriteBuildsCorrectlyInDifferentOrder() {
        HBaseIO.Write write = HBaseIO.write().withTableId("table").withConfiguration(conf);
        Assert.assertEquals((Object)"table", (Object)write.getTableId());
        Assert.assertNotNull((String)"configuration", (Object)write.getConfiguration());
    }

    @Test
    public void testWriteValidationFailsMissingTable() {
        HBaseIO.Write write = HBaseIO.write().withConfiguration(conf);
        this.thrown.expect(IllegalArgumentException.class);
        write.expand(null);
    }

    @Test
    public void testWriteValidationFailsMissingConfiguration() {
        HBaseIO.Write write = HBaseIO.write().withTableId("table");
        this.thrown.expect(IllegalArgumentException.class);
        write.expand(null);
    }

    @Test
    public void testReadingFailsTableDoesNotExist() {
        String table = this.tmpTable.getName();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(String.format("Table %s does not exist", table));
        this.runReadTest(HBaseIO.read().withConfiguration(conf).withTableId(table), false, new ArrayList<Result>());
        this.runReadTest(HBaseIO.read().withConfiguration(conf).withTableId(table), true, new ArrayList<Result>());
    }

    @Test
    public void testReadingEmptyTable() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String table = this.tmpTable.getName();
        HBaseIOTest.createTable(table);
        this.runReadTest(HBaseIO.read().withConfiguration(conf).withTableId(table), false, new ArrayList<Result>());
        this.runReadTest(HBaseIO.read().withConfiguration(conf).withTableId(table), true, new ArrayList<Result>());
    }

    @Test
    public void testReading() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String table = this.tmpTable.getName();
        int numRows = 1001;
        HBaseIOTest.createAndWriteData(table, 1001);
        this.runReadTestLength(HBaseIO.read().withConfiguration(conf).withTableId(table), false, 1001L);
    }

    @Test
    public void testReadingSDF() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String table = this.tmpTable.getName();
        int numRows = 1001;
        HBaseIOTest.createAndWriteData(table, 1001);
        this.runReadTestLength(HBaseIO.read().withConfiguration(conf).withTableId(table), true, 1001L);
    }

    @Test
    public void testReadingWithSplits() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String table = this.tmpTable.getName();
        int numRows = 1500;
        int numRegions = 4;
        long bytesPerRow = 100L;
        HBaseIOTest.createAndWriteData(table, 1500);
        HBaseIO.Read read = HBaseIO.read().withConfiguration(conf).withTableId(table);
        HBaseIO.HBaseSource source = new HBaseIO.HBaseSource(read, null);
        List splits = source.split(37500L, null);
        MatcherAssert.assertThat((Object)splits, (Matcher)Matchers.hasSize((int)4));
        SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)splits, null);
    }

    @Test
    public void testReadingSourceTwice() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String table = this.tmpTable.getName();
        int numRows = 10;
        HBaseIOTest.createAndWriteData(table, 10);
        HBaseIO.Read read = HBaseIO.read().withConfiguration(conf).withTableId(table);
        HBaseIO.HBaseSource source = new HBaseIO.HBaseSource(read, null);
        MatcherAssert.assertThat((Object)SourceTestUtils.readFromSource((BoundedSource)source, null), (Matcher)Matchers.hasSize((int)10));
        MatcherAssert.assertThat((Object)SourceTestUtils.readFromSource((BoundedSource)source, null), (Matcher)Matchers.hasSize((int)10));
    }

    @Test
    public void testReadingWithFilter() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String table = this.tmpTable.getName();
        int numRows = 1001;
        HBaseIOTest.createAndWriteData(table, 1001);
        String regex = ".*17.*";
        RowFilter filter = new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator(regex));
        this.runReadTestLength(HBaseIO.read().withConfiguration(conf).withTableId(table).withFilter((Filter)filter), false, 20L);
    }

    @Test
    public void testReadingWithFilterSDF() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String table = this.tmpTable.getName();
        int numRows = 1001;
        HBaseIOTest.createAndWriteData(table, 1001);
        String regex = ".*17.*";
        RowFilter filter = new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator(regex));
        this.runReadTestLength(HBaseIO.read().withConfiguration(conf).withTableId(table).withFilter((Filter)filter), true, 20L);
    }

    @Test
    public void testReadingKeyRangePrefix() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String table = this.tmpTable.getName();
        int numRows = 1001;
        ByteKey startKey = ByteKey.copyFrom((byte[])"2".getBytes(StandardCharsets.UTF_8));
        HBaseIOTest.createAndWriteData(table, 1001);
        ByteKeyRange prefixRange = ByteKeyRange.ALL_KEYS.withEndKey(startKey);
        this.runReadTestLength(HBaseIO.read().withConfiguration(conf).withTableId(table).withKeyRange(prefixRange), false, 126L);
    }

    @Test
    public void testReadingKeyRangeSuffix() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String table = this.tmpTable.getName();
        int numRows = 1001;
        ByteKey startKey = ByteKey.copyFrom((byte[])"2".getBytes(StandardCharsets.UTF_8));
        HBaseIOTest.createAndWriteData(table, 1001);
        ByteKeyRange suffixRange = ByteKeyRange.ALL_KEYS.withStartKey(startKey);
        this.runReadTestLength(HBaseIO.read().withConfiguration(conf).withTableId(table).withKeyRange(suffixRange), false, 875L);
    }

    @Test
    public void testReadingKeyRangeMiddle() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String table = this.tmpTable.getName();
        int numRows = 1001;
        byte[] startRow = "2".getBytes(StandardCharsets.UTF_8);
        byte[] stopRow = "9".getBytes(StandardCharsets.UTF_8);
        HBaseIOTest.createAndWriteData(table, 1001);
        this.runReadTestLength(HBaseIO.read().withConfiguration(conf).withTableId(table).withKeyRange(startRow, stopRow), false, 441L);
    }

    @Test
    public void testReadingKeyRangeMiddleSDF() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String table = this.tmpTable.getName();
        int numRows = 1001;
        byte[] startRow = "2".getBytes(StandardCharsets.UTF_8);
        byte[] stopRow = "9".getBytes(StandardCharsets.UTF_8);
        HBaseIOTest.createAndWriteData(table, 1001);
        this.runReadTestLength(HBaseIO.read().withConfiguration(conf).withTableId(table).withKeyRange(startRow, stopRow), true, 441L);
    }

    @Test
    public void testReadingSplitAtFractionExhaustive() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String table = this.tmpTable.getName();
        int numRows = 7;
        HBaseIOTest.createAndWriteData(table, 7);
        HBaseIO.Read read = HBaseIO.read().withConfiguration(conf).withTableId(table);
        HBaseIO.HBaseSource source = new HBaseIO.HBaseSource(read, null).withStartKey(ByteKey.of((int[])new int[]{48})).withEndKey(ByteKey.of((int[])new int[]{58}));
        SourceTestUtils.assertSplitAtFractionExhaustive((BoundedSource)source, null);
    }

    @Test
    public void testReadingSplitAtFraction() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String table = this.tmpTable.getName();
        int numRows = 10;
        HBaseIOTest.createAndWriteData(table, 10);
        HBaseIO.Read read = HBaseIO.read().withConfiguration(conf).withTableId(table);
        HBaseIO.HBaseSource source = new HBaseIO.HBaseSource(read, null);
        double k = 0.003922;
        SourceTestUtils.assertSplitAtFractionFails((BoundedSource)source, (int)0, (double)k, null);
        SourceTestUtils.assertSplitAtFractionFails((BoundedSource)source, (int)0, (double)1.0, null);
        SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)source, (int)1, (double)k, null);
        SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)source, (int)1, (double)0.666, null);
        SourceTestUtils.assertSplitAtFractionFails((BoundedSource)source, (int)3, (double)(2.0 * k), null);
        SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)source, (int)3, (double)(3.0 * k), null);
        SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)source, (int)3, (double)(4.0 * k), null);
        SourceTestUtils.assertSplitAtFractionFails((BoundedSource)source, (int)6, (double)(5.0 * k), null);
        SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)source, (int)6, (double)0.7, null);
    }

    @Test
    public void testReadingDisplayData() {
        HBaseIO.Read read = HBaseIO.read().withConfiguration(conf).withTableId("fooTable");
        DisplayData displayData = DisplayData.from((HasDisplayData)read);
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"tableId", (String)"fooTable"));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"configuration"));
    }

    @Test
    public void testWriting() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String table = this.tmpTable.getName();
        String key = "key";
        String value = "value";
        int numMutations = 100;
        HBaseIOTest.createTable(table);
        ((PCollection)this.p.apply("multiple rows", (PTransform)Create.of(HBaseIOTest.makeMutations("key", "value", 100)))).apply("write", (PTransform)HBaseIO.write().withConfiguration(conf).withTableId(table));
        this.p.run().waitUntilFinish();
        List<Result> results = HBaseIOTest.readTable(table, new Scan());
        Assert.assertEquals((long)100L, (long)results.size());
    }

    @Test
    public void testWritingFailsTableDoesNotExist() {
        String table = this.tmpTable.getName();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(String.format("Table %s does not exist", table));
        ((PCollection)this.p.apply((PTransform)Create.empty((Coder)HBaseMutationCoder.of()))).apply("write", (PTransform)HBaseIO.write().withConfiguration(conf).withTableId(table));
    }

    @Test
    public void testWritingFailsBadElement() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String table = this.tmpTable.getName();
        String key = "KEY";
        HBaseIOTest.createTable(table);
        ((PCollection)this.p.apply((PTransform)Create.of((Object)HBaseIOTest.makeBadMutation("KEY"), (Object[])new Mutation[0]))).apply((PTransform)HBaseIO.write().withConfiguration(conf).withTableId(table));
        this.thrown.expect(Pipeline.PipelineExecutionException.class);
        this.thrown.expectCause(Matchers.instanceOf(IllegalArgumentException.class));
        this.thrown.expectMessage("No columns to insert");
        this.p.run().waitUntilFinish();
    }

    @Test
    public void testWritingDisplayData() {
        String table = this.tmpTable.getName();
        HBaseIO.Write write = HBaseIO.write().withTableId(table).withConfiguration(conf);
        DisplayData displayData = DisplayData.from((HasDisplayData)write);
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"tableId", (String)table));
    }

    private static void createTable(@UnknownKeyFor @NonNull @Initialized String tableId) throws @UnknownKeyFor @NonNull @Initialized Exception {
        byte[][] splitKeys = new byte[][]{"4".getBytes(StandardCharsets.UTF_8), "8".getBytes(StandardCharsets.UTF_8), "C".getBytes(StandardCharsets.UTF_8)};
        HBaseIOTest.createTable(tableId, COLUMN_FAMILY, splitKeys);
    }

    private static void createTable(@UnknownKeyFor @NonNull @Initialized String tableId, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] columnFamily, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] @UnknownKeyFor @NonNull @Initialized [] splitKeys) throws @UnknownKeyFor @NonNull @Initialized Exception {
        TableName tableName = TableName.valueOf((String)tableId);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor colDef = new HColumnDescriptor(columnFamily);
        desc.addFamily(colDef);
        admin.createTable(desc, splitKeys);
    }

    private static void writeData(@UnknownKeyFor @NonNull @Initialized String tableId, @UnknownKeyFor @NonNull @Initialized int numRows) throws @UnknownKeyFor @NonNull @Initialized Exception {
        HConnection connection = admin.getConnection();
        TableName tableName = TableName.valueOf((String)tableId);
        BufferedMutator mutator = connection.getBufferedMutator(tableName);
        List<Mutation> mutations = HBaseIOTest.makeTableData(numRows);
        mutator.mutate(mutations);
        mutator.flush();
        mutator.close();
    }

    private static void createAndWriteData(@UnknownKeyFor @NonNull @Initialized String tableId, @UnknownKeyFor @NonNull @Initialized int numRows) throws @UnknownKeyFor @NonNull @Initialized Exception {
        HBaseIOTest.createTable(tableId);
        HBaseIOTest.writeData(tableId, numRows);
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Mutation> makeTableData(@UnknownKeyFor @NonNull @Initialized int numRows) {
        ArrayList<Mutation> mutations = new ArrayList<Mutation>(numRows);
        for (int i = 0; i < numRows; ++i) {
            String prefix = String.format("%X", i % 16);
            byte[] rowKey = Bytes.toBytes((String)StringUtils.leftPad((String)("_" + String.valueOf(i)), (int)21, (String)prefix));
            byte[] value = Bytes.toBytes((String)String.valueOf(i));
            byte[] valueEmail = Bytes.toBytes((String)(String.valueOf(i) + "@email.com"));
            mutations.add((Mutation)new Put(rowKey).addColumn(COLUMN_FAMILY, COLUMN_NAME, value));
            mutations.add((Mutation)new Put(rowKey).addColumn(COLUMN_FAMILY, COLUMN_EMAIL, valueEmail));
        }
        return mutations;
    }

    private static @UnknownKeyFor @NonNull @Initialized ResultScanner scanTable(@UnknownKeyFor @NonNull @Initialized String tableId, @UnknownKeyFor @NonNull @Initialized Scan scan) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Connection connection = ConnectionFactory.createConnection((Configuration)conf);
        TableName tableName = TableName.valueOf((String)tableId);
        Table table = connection.getTable(tableName);
        return table.getScanner(scan);
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Result> readTable(@UnknownKeyFor @NonNull @Initialized String tableId, @UnknownKeyFor @NonNull @Initialized Scan scan) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ResultScanner scanner = HBaseIOTest.scanTable(tableId, scan);
        ArrayList<Result> results = new ArrayList<Result>();
        for (Result result : scanner) {
            results.add(result);
        }
        scanner.close();
        return results;
    }

    private static @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Mutation> makeMutations(@UnknownKeyFor @NonNull @Initialized String key, @UnknownKeyFor @NonNull @Initialized String value, @UnknownKeyFor @NonNull @Initialized int numMutations) {
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        for (int i = 0; i < numMutations; ++i) {
            mutations.add(HBaseIOTest.makeMutation(key + i, value));
        }
        return mutations;
    }

    private static @UnknownKeyFor @NonNull @Initialized Mutation makeMutation(@UnknownKeyFor @NonNull @Initialized String key, @UnknownKeyFor @NonNull @Initialized String value) {
        return new Put(key.getBytes(StandardCharsets.UTF_8)).addColumn(COLUMN_FAMILY, COLUMN_NAME, Bytes.toBytes((String)value)).addColumn(COLUMN_FAMILY, COLUMN_EMAIL, Bytes.toBytes((String)(value + "@email.com")));
    }

    private static @UnknownKeyFor @NonNull @Initialized Mutation makeBadMutation(@UnknownKeyFor @NonNull @Initialized String key) {
        return new Put(key.getBytes(StandardCharsets.UTF_8));
    }

    private void runReadTest(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized HBaseIO.Read read, @UnknownKeyFor @NonNull @Initialized boolean useSdf, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Result> expected) {
        PCollection<Result> rows = this.applyRead(read, useSdf);
        PAssert.that(rows).containsInAnyOrder(expected);
        this.p.run().waitUntilFinish();
    }

    private void runReadTestLength(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized HBaseIO.Read read, @UnknownKeyFor @NonNull @Initialized boolean useSdf, @UnknownKeyFor @NonNull @Initialized long numElements) {
        PCollection<Result> rows = this.applyRead(read, useSdf);
        String transformId = read.getTableId() + "_" + read.getKeyRange();
        PAssert.thatSingleton((PCollection)((PCollection)rows.apply("Count" + transformId, Count.globally()))).isEqualTo((Object)numElements);
        this.p.run().waitUntilFinish();
    }

    private @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Result> applyRead(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized HBaseIO.Read read, @UnknownKeyFor @NonNull @Initialized boolean useSdf) {
        String transformId = read.getTableId() + "_" + read.getKeyRange();
        return useSdf ? (PCollection)((PCollection)this.p.apply("Create" + transformId, (PTransform)Create.of((Object)read, (Object[])new HBaseIO.Read[0]))).apply("ReadAll" + transformId, (PTransform)HBaseIO.readAll()) : (PCollection)this.p.apply("Read" + transformId, (PTransform)read);
    }

    static {
        conf = HBaseConfiguration.create();
        COLUMN_FAMILY = Bytes.toBytes((String)"info");
        COLUMN_NAME = Bytes.toBytes((String)"name");
        COLUMN_EMAIL = Bytes.toBytes((String)"email");
    }

    private static class TemporaryHBaseTable
    extends ExternalResource {
        private @UnknownKeyFor @NonNull @Initialized String name;

        private TemporaryHBaseTable() {
        }

        protected void before() {
            this.name = "table_" + UUID.randomUUID();
        }

        @UnknownKeyFor @NonNull @Initialized String getName() {
            return this.name;
        }
    }
}

