/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;

class HBaseUtils {
    HBaseUtils() {
    }

    static long estimateSizeBytes(Connection connection, String tableId, Scan scan) throws Exception {
        long estimatedSizeBytes = 0L;
        List<HRegionLocation> regionLocations = HBaseUtils.getRegionLocations(connection, tableId, scan);
        TreeSet<byte[]> tableRegions = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (HRegionLocation regionLocation : regionLocations) {
            tableRegions.add(regionLocation.getRegionInfo().getRegionName());
        }
        Admin admin = connection.getAdmin();
        ClusterStatus clusterStatus = admin.getClusterStatus();
        Collection servers = clusterStatus.getServers();
        for (ServerName serverName : servers) {
            ServerLoad serverLoad = clusterStatus.getLoad(serverName);
            for (RegionLoad regionLoad : serverLoad.getRegionsLoad().values()) {
                byte[] regionId = regionLoad.getName();
                if (!tableRegions.contains(regionId)) continue;
                long regionSizeBytes = (long)regionLoad.getStorefileSizeMB() * 0x100000L;
                estimatedSizeBytes += regionSizeBytes;
            }
        }
        return estimatedSizeBytes;
    }

    static List<HRegionLocation> getRegionLocations(Connection connection, String tableId, Scan scan) throws Exception {
        byte[] startRow = scan.getStartRow();
        byte[] stopRow = scan.getStopRow();
        ArrayList<HRegionLocation> regionLocations = new ArrayList<HRegionLocation>();
        boolean scanWithNoLowerBound = startRow.length == 0;
        boolean scanWithNoUpperBound = stopRow.length == 0;
        TableName tableName = TableName.valueOf((String)tableId);
        RegionLocator regionLocator = connection.getRegionLocator(tableName);
        List tableRegionInfos = regionLocator.getAllRegionLocations();
        for (HRegionLocation regionLocation : tableRegionInfos) {
            boolean isLastRegion;
            byte[] startKey = regionLocation.getRegionInfo().getStartKey();
            byte[] endKey = regionLocation.getRegionInfo().getEndKey();
            boolean bl = isLastRegion = endKey.length == 0;
            if (!scanWithNoLowerBound && !isLastRegion && Bytes.compareTo((byte[])startRow, (byte[])endKey) >= 0 || !scanWithNoUpperBound && Bytes.compareTo((byte[])stopRow, (byte[])startKey) <= 0) continue;
            regionLocations.add(regionLocation);
        }
        return regionLocations;
    }

    static List<ByteKeyRange> getRanges(List<HRegionLocation> regionLocations, String tableId, Scan scan) {
        byte[] startRow = scan.getStartRow();
        byte[] stopRow = scan.getStopRow();
        ArrayList<ByteKeyRange> splits = new ArrayList<ByteKeyRange>();
        boolean scanWithNoLowerBound = startRow.length == 0;
        boolean scanWithNoUpperBound = stopRow.length == 0;
        for (HRegionLocation regionLocation : regionLocations) {
            byte[] startKey = regionLocation.getRegionInfo().getStartKey();
            byte[] endKey = regionLocation.getRegionInfo().getEndKey();
            boolean isLastRegion = endKey.length == 0;
            byte[] splitStart = scanWithNoLowerBound || Bytes.compareTo((byte[])startKey, (byte[])startRow) >= 0 ? startKey : startRow;
            byte[] splitStop = (scanWithNoUpperBound || Bytes.compareTo((byte[])endKey, (byte[])stopRow) <= 0) && !isLastRegion ? endKey : stopRow;
            splits.add(ByteKeyRange.of((ByteKey)ByteKey.copyFrom((byte[])splitStart), (ByteKey)ByteKey.copyFrom((byte[])splitStop)));
        }
        return splits;
    }
}

