/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.hbase.HBaseQuery;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;

class HBaseQueryCoder
extends AtomicCoder<HBaseQuery>
implements Serializable {
    private static final HBaseQueryCoder INSTANCE = new HBaseQueryCoder();

    private HBaseQueryCoder() {
    }

    static HBaseQueryCoder of() {
        return INSTANCE;
    }

    public void encode(HBaseQuery query, OutputStream outputStream) throws IOException {
        StringUtf8Coder.of().encode(query.getTableId(), outputStream);
        ProtobufUtil.toScan((Scan)query.getScan()).writeDelimitedTo(outputStream);
    }

    public HBaseQuery decode(InputStream inputStream) throws IOException {
        String tableId = StringUtf8Coder.of().decode(inputStream);
        Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)ClientProtos.Scan.parseDelimitedFrom((InputStream)inputStream));
        return HBaseQuery.of(tableId, scan);
    }
}

