/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.hbase.HBaseMutationCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HBaseMutationCoderTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private static final HBaseMutationCoder CODER = HBaseMutationCoder.of();

    @Test
    public void testMutationEncoding() throws Exception {
        Put put = new Put("1".getBytes());
        CoderProperties.structuralValueDecodeEncodeEqual((Coder)CODER, (Object)put);
        Delete delete = new Delete("1".getBytes());
        CoderProperties.structuralValueDecodeEncodeEqual((Coder)CODER, (Object)delete);
        Increment increment = new Increment("1".getBytes());
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Only Put and Delete are supported");
        CoderProperties.coderDecodeEncodeEqual((Coder)CODER, (Object)increment);
    }
}

