/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop.format;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.common.TestRow;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;

@DefaultCoder(value=AvroCoder.class)
class TestRowDBWritable
extends TestRow
implements DBWritable,
Writable {
    private Integer id;
    private String name;

    public TestRowDBWritable() {
    }

    public TestRowDBWritable(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public void write(PreparedStatement statement) throws SQLException {
        statement.setInt(1, this.id);
        statement.setString(2, this.name);
    }

    public void readFields(ResultSet resultSet) throws SQLException {
        this.id = resultSet.getInt(1);
        this.name = resultSet.getString(2);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeChars(this.name);
    }

    public void readFields(DataInput in) throws IOException {
        this.id = in.readInt();
        this.name = in.readUTF();
    }

    private static class PrepareStatementFromTestRow
    implements JdbcIO.PreparedStatementSetter<TestRow> {
        private PrepareStatementFromTestRow() {
        }

        public void setParameters(TestRow element, PreparedStatement statement) throws SQLException {
            statement.setLong(1, element.id().intValue());
            statement.setString(2, element.name());
        }
    }
}

