/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop.format;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.io.hadoop.format.Employee;
import org.apache.beam.sdk.io.hadoop.format.TestEmployeeDataSet;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Splitter;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

class ReuseObjectsEmployeeInputFormat
extends InputFormat<Text, Employee> {
    public RecordReader<Text, Employee> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return new ReuseObjectsEmployeeRecordReader();
    }

    public List<InputSplit> getSplits(JobContext arg0) {
        ArrayList<InputSplit> inputSplitList = new ArrayList<InputSplit>();
        int i = 1;
        while ((long)i <= 3L) {
            ReuseEmployeeInputSplit inputSplitObj = new ReuseEmployeeInputSplit((long)(i - 1) * 5L, (long)i * 5L - 1L);
            inputSplitList.add(inputSplitObj);
            ++i;
        }
        return inputSplitList;
    }

    static class ReuseObjectsEmployeeRecordReader
    extends RecordReader<Text, Employee> {
        private ReuseEmployeeInputSplit split;
        private final Text currentKey = new Text();
        private final Employee currentValue = new Employee();
        private long employeeListIndex = 0L;
        private long recordsRead = 0L;
        private List<KV<String, String>> employeeDataList;

        ReuseObjectsEmployeeRecordReader() {
        }

        public void close() {
        }

        public Text getCurrentKey() {
            return this.currentKey;
        }

        public Employee getCurrentValue() {
            return this.currentValue;
        }

        public float getProgress() {
            return (float)this.recordsRead / (float)this.split.getLength();
        }

        public void initialize(InputSplit split, TaskAttemptContext arg1) {
            this.split = (ReuseEmployeeInputSplit)split;
            this.employeeListIndex = this.split.getStartIndex() - 1L;
            this.recordsRead = 0L;
            this.employeeDataList = TestEmployeeDataSet.populateEmployeeData();
        }

        public boolean nextKeyValue() {
            if (this.recordsRead++ >= this.split.getLength()) {
                return false;
            }
            ++this.employeeListIndex;
            KV<String, String> employeeDetails = this.employeeDataList.get((int)this.employeeListIndex);
            List empData = Splitter.on((char)'_').splitToList((CharSequence)employeeDetails.getValue());
            this.currentKey.set((String)employeeDetails.getKey());
            this.currentValue.setEmpName((String)empData.get(0));
            this.currentValue.setEmpAddress((String)empData.get(1));
            return true;
        }
    }

    static class ReuseEmployeeInputSplit
    extends InputSplit
    implements Writable {
        private long startIndex;
        private long endIndex;

        public ReuseEmployeeInputSplit() {
        }

        ReuseEmployeeInputSplit(long startIndex, long endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public long getLength() {
            return this.endIndex - this.startIndex + 1L;
        }

        public String[] getLocations() {
            return null;
        }

        long getStartIndex() {
            return this.startIndex;
        }

        public long getEndIndex() {
            return this.endIndex;
        }

        public void readFields(DataInput dataIn) throws IOException {
            this.startIndex = dataIn.readLong();
            this.endIndex = dataIn.readLong();
        }

        public void write(DataOutput dataOut) throws IOException {
            dataOut.writeLong(this.startIndex);
            dataOut.writeLong(this.endIndex);
        }
    }
}

