/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop.format;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.hadoop.format.IterableCombinerFn;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IterableCombinerTest {
    private static final TypeDescriptor<String> STRING_TYPE_DESCRIPTOR = TypeDescriptors.strings();
    private static final List<String> FIRST_ITEMS = Arrays.asList("a", "b", "c");
    private static final List<String> SECOND_ITEMS = Arrays.asList("c", "d", "e");

    @Test
    public void testCombining() {
        IterableCombinerFn tested = new IterableCombinerFn(STRING_TYPE_DESCRIPTOR);
        IterableCombinerFn.CollectionAccumulator first = tested.createAccumulator();
        FIRST_ITEMS.forEach(arg_0 -> ((IterableCombinerFn.CollectionAccumulator)first).addInput(arg_0));
        IterableCombinerFn.CollectionAccumulator second = tested.createAccumulator();
        SECOND_ITEMS.forEach(arg_0 -> ((IterableCombinerFn.CollectionAccumulator)second).addInput(arg_0));
        IterableCombinerFn.CollectionAccumulator merged = (IterableCombinerFn.CollectionAccumulator)tested.mergeAccumulators(Arrays.asList(first, second));
        IterableCombinerFn.CollectionAccumulator compacted = (IterableCombinerFn.CollectionAccumulator)tested.compact((Object)merged);
        Object[] allItems = (String[])Stream.of(FIRST_ITEMS, SECOND_ITEMS).flatMap(Collection::stream).toArray(String[]::new);
        MatcherAssert.assertThat((Object)compacted.extractOutput(), (Matcher)Matchers.containsInAnyOrder((Object[])allItems));
    }

    @Test
    public void testSerializing() throws IOException {
        IterableCombinerFn.CollectionAccumulator decodedAccumulator;
        byte[] bytes;
        IterableCombinerFn tested = new IterableCombinerFn(STRING_TYPE_DESCRIPTOR);
        IterableCombinerFn.CollectionAccumulator originalAccumulator = tested.createAccumulator();
        FIRST_ITEMS.forEach(arg_0 -> ((IterableCombinerFn.CollectionAccumulator)originalAccumulator).addInput(arg_0));
        Coder accumulatorCoder = tested.getAccumulatorCoder(null, (Coder)StringUtf8Coder.of());
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            accumulatorCoder.encode((Object)originalAccumulator, (OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.flush();
            bytes = byteArrayOutputStream.toByteArray();
        }
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
            decodedAccumulator = (IterableCombinerFn.CollectionAccumulator)accumulatorCoder.decode((InputStream)byteArrayInputStream);
        }
        Object[] originalItems = FIRST_ITEMS.toArray(new String[0]);
        MatcherAssert.assertThat((Object)originalAccumulator.extractOutput(), (Matcher)Matchers.containsInAnyOrder((Object[])originalItems));
        MatcherAssert.assertThat((Object)decodedAccumulator.extractOutput(), (Matcher)Matchers.containsInAnyOrder((Object[])originalItems));
    }
}

