/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.hadoop.SerializableConfiguration;
import org.apache.beam.sdk.io.hadoop.WritableCoder;
import org.apache.beam.sdk.io.hadoop.format.ConfigurableEmployeeInputFormat;
import org.apache.beam.sdk.io.hadoop.format.Employee;
import org.apache.beam.sdk.io.hadoop.format.EmployeeInputFormat;
import org.apache.beam.sdk.io.hadoop.format.HadoopFormatIO;
import org.apache.beam.sdk.io.hadoop.format.ReuseObjectsEmployeeInputFormat;
import org.apache.beam.sdk.io.hadoop.format.TestEmployeeDataSet;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.SourceTestUtils;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.db.DBInputFormat;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.MockSettings;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class HadoopFormatIOReadTest {
    private static SerializableConfiguration serConf;
    private static SimpleFunction<Text, String> myKeyTranslate;
    private static SimpleFunction<Employee, String> myValueTranslate;
    @Rule
    public final transient TestPipeline p = TestPipeline.create();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private PBegin input = PBegin.in((Pipeline)this.p);

    @BeforeClass
    public static void setUp() {
        serConf = HadoopFormatIOReadTest.loadTestConfiguration(EmployeeInputFormat.class, Text.class, Employee.class);
        myKeyTranslate = new SimpleFunction<Text, String>(){

            public String apply(Text input) {
                return input.toString();
            }
        };
        myValueTranslate = new SimpleFunction<Employee, String>(){

            public String apply(Employee input) {
                return input.getEmpName() + "_" + input.getEmpAddress();
            }
        };
    }

    @Test
    public void testReadBuildsCorrectly() {
        HadoopFormatIO.Read read = HadoopFormatIO.read().withConfiguration(serConf.get()).withKeyTranslation(myKeyTranslate).withValueTranslation(myValueTranslate);
        Assert.assertEquals((Object)serConf.get(), (Object)read.getConfiguration().get());
        Assert.assertEquals(myKeyTranslate, (Object)read.getKeyTranslationFunction());
        Assert.assertEquals(myValueTranslate, (Object)read.getValueTranslationFunction());
        Assert.assertEquals((Object)myValueTranslate.getOutputTypeDescriptor(), (Object)read.getValueTypeDescriptor());
        Assert.assertEquals((Object)myKeyTranslate.getOutputTypeDescriptor(), (Object)read.getKeyTypeDescriptor());
    }

    @Test
    public void testReadBuildsCorrectlyInDifferentOrder() {
        HadoopFormatIO.Read read = HadoopFormatIO.read().withValueTranslation(myValueTranslate).withConfiguration(serConf.get()).withKeyTranslation(myKeyTranslate);
        Assert.assertEquals((Object)serConf.get(), (Object)read.getConfiguration().get());
        Assert.assertEquals(myKeyTranslate, (Object)read.getKeyTranslationFunction());
        Assert.assertEquals(myValueTranslate, (Object)read.getValueTranslationFunction());
        Assert.assertEquals((Object)myKeyTranslate.getOutputTypeDescriptor(), (Object)read.getKeyTypeDescriptor());
        Assert.assertEquals((Object)myValueTranslate.getOutputTypeDescriptor(), (Object)read.getValueTypeDescriptor());
    }

    @Test
    public void testReadBuildsCorrectlyIfWithConfigurationIsCalledMoreThanOneTime() {
        SerializableConfiguration diffConf = HadoopFormatIOReadTest.loadTestConfiguration(EmployeeInputFormat.class, Employee.class, Text.class);
        HadoopFormatIO.Read read = HadoopFormatIO.read().withConfiguration(serConf.get()).withKeyTranslation(myKeyTranslate).withConfiguration(diffConf.get());
        Assert.assertEquals((Object)diffConf.get(), (Object)read.getConfiguration().get());
        Assert.assertEquals(myKeyTranslate, (Object)read.getKeyTranslationFunction());
        Assert.assertEquals(null, (Object)read.getValueTranslationFunction());
        Assert.assertEquals((Object)myKeyTranslate.getOutputTypeDescriptor(), (Object)read.getKeyTypeDescriptor());
        Assert.assertEquals((Object)diffConf.get().getClass("value.class", Object.class), (Object)read.getValueTypeDescriptor().getRawType());
    }

    @Test
    public void testReadObjectCreationFailsIfConfigurationIsNull() {
        this.thrown.expect(IllegalArgumentException.class);
        HadoopFormatIO.read().withConfiguration(null);
    }

    @Test
    public void testReadObjectCreationWithConfiguration() {
        HadoopFormatIO.Read read = HadoopFormatIO.read().withConfiguration(serConf.get());
        Assert.assertEquals((Object)serConf.get(), (Object)read.getConfiguration().get());
        Assert.assertEquals(null, (Object)read.getKeyTranslationFunction());
        Assert.assertEquals(null, (Object)read.getValueTranslationFunction());
        Assert.assertEquals((Object)serConf.get().getClass("key.class", Object.class), (Object)read.getKeyTypeDescriptor().getRawType());
        Assert.assertEquals((Object)serConf.get().getClass("value.class", Object.class), (Object)read.getValueTypeDescriptor().getRawType());
    }

    @Test
    public void testReadObjectCreationFailsIfKeyTranslationFunctionIsNull() {
        this.thrown.expect(IllegalArgumentException.class);
        HadoopFormatIO.read().withConfiguration(serConf.get()).withKeyTranslation(null);
    }

    @Test
    public void testReadObjectCreationWithConfigurationKeyTranslation() {
        HadoopFormatIO.Read read = HadoopFormatIO.read().withConfiguration(serConf.get()).withKeyTranslation(myKeyTranslate);
        Assert.assertEquals((Object)serConf.get(), (Object)read.getConfiguration().get());
        Assert.assertEquals(myKeyTranslate, (Object)read.getKeyTranslationFunction());
        Assert.assertEquals(null, (Object)read.getValueTranslationFunction());
        Assert.assertEquals((Object)myKeyTranslate.getOutputTypeDescriptor().getRawType(), (Object)read.getKeyTypeDescriptor().getRawType());
        Assert.assertEquals((Object)serConf.get().getClass("value.class", Object.class), (Object)read.getValueTypeDescriptor().getRawType());
    }

    @Test
    public void testReadObjectCreationFailsIfValueTranslationFunctionIsNull() {
        this.thrown.expect(IllegalArgumentException.class);
        HadoopFormatIO.read().withConfiguration(serConf.get()).withValueTranslation(null);
    }

    @Test
    public void testReadObjectCreationWithConfigurationValueTranslation() {
        HadoopFormatIO.Read read = HadoopFormatIO.read().withConfiguration(serConf.get()).withValueTranslation(myValueTranslate);
        Assert.assertEquals((Object)serConf.get(), (Object)read.getConfiguration().get());
        Assert.assertEquals(null, (Object)read.getKeyTranslationFunction());
        Assert.assertEquals(myValueTranslate, (Object)read.getValueTranslationFunction());
        Assert.assertEquals((Object)serConf.get().getClass("key.class", Object.class), (Object)read.getKeyTypeDescriptor().getRawType());
        Assert.assertEquals((Object)myValueTranslate.getOutputTypeDescriptor().getRawType(), (Object)read.getValueTypeDescriptor().getRawType());
    }

    @Test
    public void testReadObjectCreationWithConfigurationKeyTranslationValueTranslation() {
        HadoopFormatIO.Read read = HadoopFormatIO.read().withConfiguration(serConf.get()).withKeyTranslation(myKeyTranslate).withValueTranslation(myValueTranslate);
        Assert.assertEquals((Object)serConf.get(), (Object)read.getConfiguration().get());
        Assert.assertEquals(myKeyTranslate, (Object)read.getKeyTranslationFunction());
        Assert.assertEquals(myValueTranslate, (Object)read.getValueTranslationFunction());
        Assert.assertEquals((Object)myKeyTranslate.getOutputTypeDescriptor().getRawType(), (Object)read.getKeyTypeDescriptor().getRawType());
        Assert.assertEquals((Object)myValueTranslate.getOutputTypeDescriptor().getRawType(), (Object)read.getValueTypeDescriptor().getRawType());
    }

    @Test
    public void testReadValidationFailsMissingConfiguration() {
        HadoopFormatIO.Read read = HadoopFormatIO.read();
        this.thrown.expect(IllegalArgumentException.class);
        read.validateTransform();
    }

    @Test
    public void testReadValidationFailsMissingInputFormatInConf() {
        Configuration configuration = new Configuration();
        configuration.setClass("key.class", Text.class, Object.class);
        configuration.setClass("value.class", Employee.class, Object.class);
        this.thrown.expect(IllegalArgumentException.class);
        HadoopFormatIO.read().withConfiguration(configuration);
    }

    @Test
    public void testReadValidationFailsMissingKeyClassInConf() {
        Configuration configuration = new Configuration();
        configuration.setClass("mapreduce.job.inputformat.class", EmployeeInputFormat.class, InputFormat.class);
        configuration.setClass("value.class", Employee.class, Object.class);
        this.thrown.expect(IllegalArgumentException.class);
        HadoopFormatIO.read().withConfiguration(configuration);
    }

    @Test
    public void testReadValidationFailsMissingValueClassInConf() {
        Configuration configuration = new Configuration();
        configuration.setClass("mapreduce.job.inputformat.class", EmployeeInputFormat.class, InputFormat.class);
        configuration.setClass("key.class", Text.class, Object.class);
        this.thrown.expect(IllegalArgumentException.class);
        HadoopFormatIO.read().withConfiguration(configuration);
    }

    @Test
    public void testReadValidationFailsWithWrongInputTypeKeyTranslationFunction() {
        SimpleFunction<LongWritable, String> myKeyTranslateWithWrongInputType = new SimpleFunction<LongWritable, String>(){

            public String apply(LongWritable input) {
                return input.toString();
            }
        };
        HadoopFormatIO.Read read = HadoopFormatIO.read().withConfiguration(serConf.get()).withKeyTranslation((SimpleFunction)myKeyTranslateWithWrongInputType);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(String.format("Key translation's input type is not same as hadoop InputFormat : %s key class : %s", serConf.get().getClass("mapreduce.job.inputformat.class", InputFormat.class), serConf.get().getClass("key.class", Object.class)));
        read.validateTransform();
    }

    @Test
    public void testReadValidationFailsWithWrongInputTypeValueTranslationFunction() {
        SimpleFunction<LongWritable, String> myValueTranslateWithWrongInputType = new SimpleFunction<LongWritable, String>(){

            public String apply(LongWritable input) {
                return input.toString();
            }
        };
        HadoopFormatIO.Read read = HadoopFormatIO.read().withConfiguration(serConf.get()).withValueTranslation((SimpleFunction)myValueTranslateWithWrongInputType);
        String expectedMessage = String.format("Value translation's input type is not same as hadoop InputFormat :  %s value class : %s", serConf.get().getClass("mapreduce.job.inputformat.class", InputFormat.class), serConf.get().getClass("value.class", Object.class));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(expectedMessage);
        read.validateTransform();
    }

    @Test
    public void testReadingData() {
        HadoopFormatIO.Read read = HadoopFormatIO.read().withConfiguration(serConf.get());
        List<KV<Text, Employee>> expected = TestEmployeeDataSet.getEmployeeData();
        PCollection actual = (PCollection)this.p.apply("ReadTest", (PTransform)read);
        PAssert.that((PCollection)actual).containsInAnyOrder(expected);
        this.p.run();
    }

    @Test
    public void testReadDisplayData() {
        HadoopFormatIO.HadoopInputFormatBoundedSource boundedSource = new HadoopFormatIO.HadoopInputFormatBoundedSource(serConf, (Coder)WritableCoder.of(Text.class), (Coder)AvroCoder.of(Employee.class), null, null, new HadoopFormatIO.SerializableSplit());
        DisplayData displayData = DisplayData.from((HasDisplayData)boundedSource);
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"mapreduce.job.inputformat.class", (String)serConf.get().get("mapreduce.job.inputformat.class")));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"key.class", (String)serConf.get().get("key.class")));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"value.class", (String)serConf.get().get("value.class")));
    }

    @Test
    public void testReadIfCreateRecordReaderFails() throws Exception {
        this.thrown.expect(Exception.class);
        this.thrown.expectMessage("Exception in creating RecordReader");
        InputFormat mockInputFormat = (InputFormat)Mockito.mock(EmployeeInputFormat.class);
        Mockito.when((Object)mockInputFormat.createRecordReader((InputSplit)Mockito.any(InputSplit.class), (TaskAttemptContext)Mockito.any(TaskAttemptContext.class))).thenThrow(new Throwable[]{new IOException("Exception in creating RecordReader")});
        HadoopFormatIO.HadoopInputFormatBoundedSource boundedSource = new HadoopFormatIO.HadoopInputFormatBoundedSource(serConf, (Coder)WritableCoder.of(Text.class), (Coder)AvroCoder.of(Employee.class), null, null, new HadoopFormatIO.SerializableSplit());
        boundedSource.setInputFormatObj(mockInputFormat);
        SourceTestUtils.readFromSource((BoundedSource)boundedSource, (PipelineOptions)this.p.getOptions());
    }

    @Test
    public void testReadWithNullCreateRecordReader() throws Exception {
        InputFormat mockInputFormat = (InputFormat)Mockito.mock(EmployeeInputFormat.class);
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage(String.format("Null RecordReader object returned by %s", mockInputFormat.getClass()));
        Mockito.when((Object)mockInputFormat.createRecordReader((InputSplit)Mockito.any(InputSplit.class), (TaskAttemptContext)Mockito.any(TaskAttemptContext.class))).thenReturn(null);
        HadoopFormatIO.HadoopInputFormatBoundedSource boundedSource = new HadoopFormatIO.HadoopInputFormatBoundedSource(serConf, (Coder)WritableCoder.of(Text.class), (Coder)AvroCoder.of(Employee.class), null, null, new HadoopFormatIO.SerializableSplit());
        boundedSource.setInputFormatObj(mockInputFormat);
        SourceTestUtils.readFromSource((BoundedSource)boundedSource, (PipelineOptions)this.p.getOptions());
    }

    @Test
    public void testReadersStartWhenZeroRecords() throws Exception {
        InputFormat mockInputFormat = (InputFormat)Mockito.mock(EmployeeInputFormat.class);
        EmployeeInputFormat.EmployeeRecordReader mockReader = (EmployeeInputFormat.EmployeeRecordReader)((Object)Mockito.mock(EmployeeInputFormat.EmployeeRecordReader.class));
        Mockito.when((Object)mockInputFormat.createRecordReader((InputSplit)Mockito.any(), (TaskAttemptContext)Mockito.any())).thenReturn((Object)mockReader);
        Mockito.when((Object)mockReader.nextKeyValue()).thenReturn((Object)false);
        InputSplit mockInputSplit = (InputSplit)Mockito.mock(EmployeeInputFormat.NewObjectsEmployeeInputSplit.class);
        HadoopFormatIO.HadoopInputFormatBoundedSource boundedSource = new HadoopFormatIO.HadoopInputFormatBoundedSource(serConf, (Coder)WritableCoder.of(Text.class), (Coder)AvroCoder.of(Employee.class), null, null, new HadoopFormatIO.SerializableSplit(mockInputSplit));
        boundedSource.setInputFormatObj(mockInputFormat);
        BoundedSource.BoundedReader reader = boundedSource.createReader(this.p.getOptions());
        Assert.assertFalse((boolean)reader.start());
        Assert.assertEquals((Object)1.0, (Object)reader.getFractionConsumed());
        reader.close();
    }

    @Test
    public void testReadersGetFractionConsumed() throws Exception {
        List<KV<Text, Employee>> referenceRecords = TestEmployeeDataSet.getEmployeeData();
        HadoopFormatIO.HadoopInputFormatBoundedSource<Text, Employee> hifSource = this.getTestHIFSource(EmployeeInputFormat.class, (Class)Text.class, (Class)Employee.class, (Coder)WritableCoder.of(Text.class), (Coder)AvroCoder.of(Employee.class));
        long estimatedSize = hifSource.getEstimatedSizeBytes(this.p.getOptions());
        Assert.assertEquals((long)referenceRecords.size(), (long)estimatedSize);
        List boundedSourceList = hifSource.split(0L, this.p.getOptions());
        Assert.assertEquals((long)3L, (long)boundedSourceList.size());
        ArrayList bundleRecords = new ArrayList();
        for (BoundedSource source : boundedSourceList) {
            ArrayList<KV> elements = new ArrayList<KV>();
            BoundedSource.BoundedReader reader = source.createReader(this.p.getOptions());
            float recordsRead = 0.0f;
            Assert.assertEquals((Object)0.0, (Object)reader.getFractionConsumed());
            boolean start = reader.start();
            Assert.assertTrue((boolean)start);
            if (start) {
                elements.add((KV)reader.getCurrent());
                boolean advance = reader.advance();
                Assert.assertEquals((Object)((recordsRead += 1.0f) / 5.0f), (Object)reader.getFractionConsumed());
                Assert.assertTrue((boolean)advance);
                while (advance) {
                    elements.add((KV)reader.getCurrent());
                    advance = reader.advance();
                    Assert.assertEquals((Object)((recordsRead += 1.0f) / 5.0f), (Object)reader.getFractionConsumed());
                }
                bundleRecords.addAll(elements);
            }
            Assert.assertEquals((Object)1.0, (Object)reader.getFractionConsumed());
            reader.close();
        }
        Assert.assertThat(bundleRecords, (Matcher)Matchers.containsInAnyOrder((Object[])referenceRecords.toArray()));
    }

    @Test
    public void testGetFractionConsumedForBadProgressValue() throws Exception {
        InputFormat mockInputFormat = (InputFormat)Mockito.mock(EmployeeInputFormat.class);
        EmployeeInputFormat.EmployeeRecordReader mockReader = (EmployeeInputFormat.EmployeeRecordReader)((Object)Mockito.mock(EmployeeInputFormat.EmployeeRecordReader.class));
        Mockito.when((Object)mockInputFormat.createRecordReader((InputSplit)Mockito.any(), (TaskAttemptContext)Mockito.any())).thenReturn((Object)mockReader);
        Mockito.when((Object)mockReader.nextKeyValue()).thenReturn((Object)true);
        Mockito.when((Object)Float.valueOf(mockReader.getProgress())).thenReturn((Object)Float.valueOf(2.0f));
        InputSplit mockInputSplit = (InputSplit)Mockito.mock(EmployeeInputFormat.NewObjectsEmployeeInputSplit.class);
        HadoopFormatIO.HadoopInputFormatBoundedSource boundedSource = new HadoopFormatIO.HadoopInputFormatBoundedSource(serConf, (Coder)WritableCoder.of(Text.class), (Coder)AvroCoder.of(Employee.class), null, null, new HadoopFormatIO.SerializableSplit(mockInputSplit));
        boundedSource.setInputFormatObj(mockInputFormat);
        BoundedSource.BoundedReader reader = boundedSource.createReader(this.p.getOptions());
        Assert.assertEquals((Object)0.0, (Object)reader.getFractionConsumed());
        boolean start = reader.start();
        Assert.assertTrue((boolean)start);
        if (start) {
            boolean advance = reader.advance();
            Assert.assertEquals(null, (Object)reader.getFractionConsumed());
            Assert.assertTrue((boolean)advance);
            if (advance) {
                advance = reader.advance();
                Assert.assertEquals(null, (Object)reader.getFractionConsumed());
            }
        }
        Assert.assertEquals(null, (Object)reader.getFractionConsumed());
        reader.close();
    }

    @Test
    public void testReaderAndParentSourceReadsSameData() throws Exception {
        InputSplit mockInputSplit = (InputSplit)Mockito.mock(EmployeeInputFormat.NewObjectsEmployeeInputSplit.class);
        HadoopFormatIO.HadoopInputFormatBoundedSource boundedSource = new HadoopFormatIO.HadoopInputFormatBoundedSource(serConf, (Coder)WritableCoder.of(Text.class), (Coder)AvroCoder.of(Employee.class), null, null, new HadoopFormatIO.SerializableSplit(mockInputSplit));
        BoundedSource.BoundedReader reader = boundedSource.createReader(this.p.getOptions());
        SourceTestUtils.assertUnstartedReaderReadsSameAsItsSource((BoundedSource.BoundedReader)reader, (PipelineOptions)this.p.getOptions());
    }

    @Test
    public void testGetCurrentSourceFunction() throws Exception {
        HadoopFormatIO.SerializableSplit split = new HadoopFormatIO.SerializableSplit();
        HadoopFormatIO.HadoopInputFormatBoundedSource source = new HadoopFormatIO.HadoopInputFormatBoundedSource(serConf, (Coder)WritableCoder.of(Text.class), (Coder)AvroCoder.of(Employee.class), null, null, split);
        BoundedSource.BoundedReader hifReader = source.createReader(this.p.getOptions());
        BoundedSource hifSource = hifReader.getCurrentSource();
        Assert.assertEquals((Object)hifSource, (Object)source);
    }

    @Test
    public void testCreateReaderIfSplitNotCalled() throws Exception {
        HadoopFormatIO.HadoopInputFormatBoundedSource<Text, Employee> hifSource = this.getTestHIFSource(EmployeeInputFormat.class, (Class)Text.class, (Class)Employee.class, (Coder)WritableCoder.of(Text.class), (Coder)AvroCoder.of(Employee.class));
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("Cannot create reader as source is not split yet.");
        hifSource.createReader(this.p.getOptions());
    }

    @Test
    public void testComputeSplitsIfGetSplitsReturnsEmptyList() throws Exception {
        InputFormat mockInputFormat = (InputFormat)Mockito.mock(EmployeeInputFormat.class);
        HadoopFormatIO.SerializableSplit mockInputSplit = (HadoopFormatIO.SerializableSplit)Mockito.mock(HadoopFormatIO.SerializableSplit.class);
        Mockito.when((Object)mockInputFormat.getSplits((JobContext)Mockito.any(JobContext.class))).thenReturn(new ArrayList());
        HadoopFormatIO.HadoopInputFormatBoundedSource hifSource = new HadoopFormatIO.HadoopInputFormatBoundedSource(serConf, (Coder)WritableCoder.of(Text.class), (Coder)AvroCoder.of(Employee.class), null, null, mockInputSplit);
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("Error in computing splits, getSplits() returns a empty list");
        hifSource.setInputFormatObj(mockInputFormat);
        hifSource.computeSplitsIfNecessary();
    }

    @Test
    public void testComputeSplitsIfGetSplitsReturnsNullValue() throws Exception {
        InputFormat mockInputFormat = (InputFormat)Mockito.mock(EmployeeInputFormat.class);
        HadoopFormatIO.SerializableSplit mockInputSplit = (HadoopFormatIO.SerializableSplit)Mockito.mock(HadoopFormatIO.SerializableSplit.class);
        Mockito.when((Object)mockInputFormat.getSplits((JobContext)Mockito.any(JobContext.class))).thenReturn(null);
        HadoopFormatIO.HadoopInputFormatBoundedSource hifSource = new HadoopFormatIO.HadoopInputFormatBoundedSource(serConf, (Coder)WritableCoder.of(Text.class), (Coder)AvroCoder.of(Employee.class), null, null, mockInputSplit);
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("Error in computing splits, getSplits() returns null.");
        hifSource.setInputFormatObj(mockInputFormat);
        hifSource.computeSplitsIfNecessary();
    }

    @Test
    public void testComputeSplitsIfGetSplitsReturnsListHavingNullValues() throws Exception {
        InputSplit mockInputSplit = (InputSplit)Mockito.mock(InputSplit.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Writable.class}));
        ArrayList<InputSplit> inputSplitList = new ArrayList<InputSplit>();
        inputSplitList.add(mockInputSplit);
        inputSplitList.add(null);
        InputFormat mockInputFormat = (InputFormat)Mockito.mock(EmployeeInputFormat.class);
        Mockito.when((Object)mockInputFormat.getSplits((JobContext)Mockito.any(JobContext.class))).thenReturn(inputSplitList);
        HadoopFormatIO.HadoopInputFormatBoundedSource hifSource = new HadoopFormatIO.HadoopInputFormatBoundedSource(serConf, (Coder)WritableCoder.of(Text.class), (Coder)AvroCoder.of(Employee.class), null, null, new HadoopFormatIO.SerializableSplit());
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("Error in computing splits, split is null in InputSplits list populated by getSplits() : ");
        hifSource.setInputFormatObj(mockInputFormat);
        hifSource.computeSplitsIfNecessary();
    }

    @Test
    public void testImmutablityOfOutputOfReadIfRecordReaderObjectsAreMutable() throws Exception {
        List<BoundedSource<KV<Text, Employee>>> boundedSourceList = this.getBoundedSourceList(ReuseObjectsEmployeeInputFormat.class, (Class)Text.class, (Class)Employee.class, (Coder)WritableCoder.of(Text.class), (Coder)AvroCoder.of(Employee.class));
        ArrayList bundleRecords = new ArrayList();
        for (BoundedSource<KV<Text, Employee>> source : boundedSourceList) {
            List elems = SourceTestUtils.readFromSource(source, (PipelineOptions)this.p.getOptions());
            bundleRecords.addAll(elems);
        }
        List<KV<Text, Employee>> referenceRecords = TestEmployeeDataSet.getEmployeeData();
        Assert.assertThat(bundleRecords, (Matcher)Matchers.containsInAnyOrder((Object[])referenceRecords.toArray()));
    }

    @Test
    public void testReadingWithConfigurableInputFormat() throws Exception {
        List<BoundedSource<KV<Text, Employee>>> boundedSourceList = this.getBoundedSourceList(ConfigurableEmployeeInputFormat.class, (Class)Text.class, (Class)Employee.class, (Coder)WritableCoder.of(Text.class), (Coder)AvroCoder.of(Employee.class));
        for (BoundedSource<KV<Text, Employee>> source : boundedSourceList) {
            HadoopFormatIO.HadoopInputFormatBoundedSource hifSource = (HadoopFormatIO.HadoopInputFormatBoundedSource)source;
            hifSource.createInputFormatInstance();
            ConfigurableEmployeeInputFormat inputFormatObj = (ConfigurableEmployeeInputFormat)hifSource.getInputFormat();
            Assert.assertTrue((boolean)inputFormatObj.isConfSet);
        }
    }

    @Test
    public void testImmutablityOfOutputOfReadIfRecordReaderObjectsAreImmutable() throws Exception {
        List<BoundedSource<KV<Text, Employee>>> boundedSourceList = this.getBoundedSourceList(EmployeeInputFormat.class, (Class)Text.class, (Class)Employee.class, (Coder)WritableCoder.of(Text.class), (Coder)AvroCoder.of(Employee.class));
        ArrayList bundleRecords = new ArrayList();
        for (BoundedSource<KV<Text, Employee>> source : boundedSourceList) {
            List elems = SourceTestUtils.readFromSource(source, (PipelineOptions)this.p.getOptions());
            bundleRecords.addAll(elems);
        }
        List<KV<Text, Employee>> referenceRecords = TestEmployeeDataSet.getEmployeeData();
        Assert.assertThat(bundleRecords, (Matcher)Matchers.containsInAnyOrder((Object[])referenceRecords.toArray()));
    }

    @Test
    public void testValidateConfigurationWithDBInputFormat() {
        Configuration conf = new Configuration();
        conf.setClass("key.class", LongWritable.class, Object.class);
        conf.setClass("value.class", Text.class, Object.class);
        conf.setClass("mapreduce.job.inputformat.class", DBInputFormat.class, InputFormat.class);
        this.thrown.expect(IllegalArgumentException.class);
        HadoopFormatIO.read().withConfiguration(new SerializableConfiguration(conf).get()).withKeyTranslation(myKeyTranslate).withValueTranslation(myValueTranslate);
    }

    private static SerializableConfiguration loadTestConfiguration(Class<?> inputFormatClassName, Class<?> keyClass, Class<?> valueClass) {
        Configuration conf = new Configuration();
        conf.setClass("mapreduce.job.inputformat.class", inputFormatClassName, InputFormat.class);
        conf.setClass("key.class", keyClass, Object.class);
        conf.setClass("value.class", valueClass, Object.class);
        return new SerializableConfiguration(conf);
    }

    private <K, V> HadoopFormatIO.HadoopInputFormatBoundedSource<K, V> getTestHIFSource(Class<?> inputFormatClass, Class<K> inputFormatKeyClass, Class<V> inputFormatValueClass, Coder<K> keyCoder, Coder<V> valueCoder) {
        SerializableConfiguration serConf = HadoopFormatIOReadTest.loadTestConfiguration(inputFormatClass, inputFormatKeyClass, inputFormatValueClass);
        return new HadoopFormatIO.HadoopInputFormatBoundedSource(serConf, keyCoder, valueCoder, null, null);
    }

    private <K, V> List<BoundedSource<KV<K, V>>> getBoundedSourceList(Class<?> inputFormatClass, Class<K> inputFormatKeyClass, Class<V> inputFormatValueClass, Coder<K> keyCoder, Coder<V> valueCoder) throws Exception {
        HadoopFormatIO.HadoopInputFormatBoundedSource<K, V> boundedSource = this.getTestHIFSource(inputFormatClass, inputFormatKeyClass, inputFormatValueClass, keyCoder, valueCoder);
        return boundedSource.split(0L, this.p.getOptions());
    }
}

