/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop.format;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.mapping.annotations.Column;
import com.datastax.driver.mapping.annotations.Table;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.beam.sdk.io.common.HashingFn;
import org.apache.beam.sdk.io.common.NetworkTestHelper;
import org.apache.beam.sdk.io.hadoop.format.HadoopFormatIO;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.values.PCollection;
import org.apache.cassandra.hadoop.cql3.CqlInputFormat;
import org.apache.cassandra.service.EmbeddedCassandraService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HadoopFormatIOCassandraTest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CASSANDRA_KEYSPACE = "beamdb";
    private static final String CASSANDRA_HOST = "127.0.0.1";
    private static final String CASSANDRA_TABLE = "scientists";
    private static final String CASSANDRA_NATIVE_PORT_PROPERTY = "cassandra.input.native.port";
    private static final String CASSANDRA_THRIFT_PORT_PROPERTY = "cassandra.input.thrift.port";
    private static final String CASSANDRA_THRIFT_ADDRESS_PROPERTY = "cassandra.input.thrift.address";
    private static final String CASSANDRA_PARTITIONER_CLASS_PROPERTY = "cassandra.input.partitioner.class";
    private static final String CASSANDRA_PARTITIONER_CLASS_VALUE = "Murmur3Partitioner";
    private static final String CASSANDRA_KEYSPACE_PROPERTY = "cassandra.input.keyspace";
    private static final String CASSANDRA_COLUMNFAMILY_PROPERTY = "cassandra.input.columnfamily";
    private static int cassandraPort;
    private static int cassandraNativePort;
    private static transient Cluster cluster;
    private static transient Session session;
    private static final long TEST_DATA_ROW_COUNT = 10L;
    private static final EmbeddedCassandraService cassandra;
    @Rule
    public final transient TestPipeline p = TestPipeline.create();
    private final SimpleFunction<Row, String> myValueTranslate = new SimpleFunction<Row, String>(){

        public String apply(Row input) {
            return input.getInt("id") + "|" + input.getString("scientist");
        }
    };

    @Test
    public void testHIFReadForCassandra() {
        String expectedHashCode = "1b9780833cce000138b9afa25ba63486";
        Configuration conf = this.getConfiguration();
        PCollection cassandraData = (PCollection)this.p.apply((PTransform)HadoopFormatIO.read().withConfiguration(conf).withValueTranslation(this.myValueTranslate));
        PAssert.thatSingleton((PCollection)((PCollection)cassandraData.apply("Count", Count.globally()))).isEqualTo((Object)10L);
        PCollection textValues = (PCollection)cassandraData.apply((PTransform)Values.create());
        PCollection consolidatedHashcode = (PCollection)textValues.apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new HashingFn()).withoutDefaults());
        PAssert.that((PCollection)consolidatedHashcode).containsInAnyOrder((Object[])new String[]{expectedHashCode});
        this.p.run().waitUntilFinish();
    }

    @Test
    public void testHIFReadForCassandraQuery() {
        Long expectedCount = 1L;
        String expectedChecksum = "f11caabc7a9fc170e22b41218749166c";
        Configuration conf = this.getConfiguration();
        conf.set("cassandra.input.cql", "select * from beamdb.scientists where token(id) > ? and token(id) <= ? and scientist='Faraday1' allow filtering");
        PCollection cassandraData = (PCollection)this.p.apply((PTransform)HadoopFormatIO.read().withConfiguration(conf).withValueTranslation(this.myValueTranslate));
        PAssert.thatSingleton((PCollection)((PCollection)cassandraData.apply("Count", Count.globally()))).isEqualTo((Object)expectedCount);
        PCollection textValues = (PCollection)cassandraData.apply((PTransform)Values.create());
        PCollection consolidatedHashcode = (PCollection)textValues.apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new HashingFn()).withoutDefaults());
        PAssert.that((PCollection)consolidatedHashcode).containsInAnyOrder((Object[])new String[]{expectedChecksum});
        this.p.run().waitUntilFinish();
    }

    private Configuration getConfiguration() {
        Configuration conf = new Configuration();
        conf.set(CASSANDRA_NATIVE_PORT_PROPERTY, String.valueOf(cassandraNativePort));
        conf.set(CASSANDRA_THRIFT_PORT_PROPERTY, String.valueOf(cassandraPort));
        conf.set(CASSANDRA_THRIFT_ADDRESS_PROPERTY, CASSANDRA_HOST);
        conf.set(CASSANDRA_PARTITIONER_CLASS_PROPERTY, CASSANDRA_PARTITIONER_CLASS_VALUE);
        conf.set(CASSANDRA_KEYSPACE_PROPERTY, CASSANDRA_KEYSPACE);
        conf.set(CASSANDRA_COLUMNFAMILY_PROPERTY, CASSANDRA_TABLE);
        conf.setClass("mapreduce.job.inputformat.class", CqlInputFormat.class, InputFormat.class);
        conf.setClass("key.class", Long.class, Object.class);
        conf.setClass("value.class", Row.class, Object.class);
        return conf;
    }

    private static void createCassandraData() {
        session.execute("DROP KEYSPACE IF EXISTS beamdb");
        session.execute("CREATE KEYSPACE beamdb WITH REPLICATION = {'class':'SimpleStrategy', 'replication_factor':1};");
        session.execute("USE beamdb");
        session.execute("CREATE TABLE scientists(id int, scientist text, PRIMARY KEY(id));");
        int i = 0;
        while ((long)i < 10L) {
            session.execute("INSERT INTO scientists(id, scientist) values(" + i + ", 'Faraday" + i + "');");
            ++i;
        }
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        cassandraPort = NetworkTestHelper.getAvailableLocalPort();
        cassandraNativePort = NetworkTestHelper.getAvailableLocalPort();
        HadoopFormatIOCassandraTest.replacePortsInConfFile();
        cassandra.start();
        SocketOptions socketOptions = new SocketOptions();
        socketOptions.setReadTimeoutMillis(0);
        socketOptions.setConnectTimeoutMillis(60000);
        cluster = Cluster.builder().addContactPoint(CASSANDRA_HOST).withClusterName("beam").withSocketOptions(socketOptions).withPort(cassandraNativePort).build();
        session = cluster.connect();
        HadoopFormatIOCassandraTest.createCassandraData();
    }

    private static void replacePortsInConfFile() throws Exception {
        URI uri = HadoopFormatIOCassandraTest.class.getResource("/cassandra.yaml").toURI();
        Path cassandraYamlPath = new File(uri).toPath();
        String content = new String(Files.readAllBytes(cassandraYamlPath), Charset.defaultCharset());
        content = content.replaceAll("9042", String.valueOf(cassandraNativePort));
        content = content.replaceAll("9061", String.valueOf(cassandraPort));
        Files.write(cassandraYamlPath, content.getBytes(Charset.defaultCharset()), new OpenOption[0]);
    }

    @AfterClass
    public static void afterClass() {
        session.close();
        cluster.close();
    }

    static {
        cassandra = new EmbeddedCassandraService();
    }

    @Table(name="scientists", keyspace="beamdb")
    public static class Scientist
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @Column(name="scientist")
        private String name;
        @Column(name="id")
        private int id;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String toString() {
            return this.id + ":" + this.name;
        }
    }
}

