/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop.format;

import com.datastax.driver.core.Row;
import java.io.Serializable;
import org.apache.beam.sdk.io.common.HashingFn;
import org.apache.beam.sdk.io.hadoop.format.HadoopFormatIO;
import org.apache.beam.sdk.io.hadoop.format.HadoopFormatIOTestOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.values.PCollection;
import org.apache.cassandra.hadoop.cql3.CqlInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HadoopFormatIOCassandraIT
implements Serializable {
    private static final String CASSANDRA_KEYSPACE = "ycsb";
    private static final String CASSANDRA_TABLE = "usertable";
    private static final String CASSANDRA_THRIFT_PORT_PROPERTY = "cassandra.input.thrift.port";
    private static final String CASSANDRA_THRIFT_ADDRESS_PROPERTY = "cassandra.input.thrift.address";
    private static final String CASSANDRA_PARTITIONER_CLASS_PROPERTY = "cassandra.input.partitioner.class";
    private static final String CASSANDRA_KEYSPACE_PROPERTY = "cassandra.input.keyspace";
    private static final String CASSANDRA_COLUMNFAMILY_PROPERTY = "cassandra.input.columnfamily";
    private static final String CASSANDRA_PARTITIONER_CLASS_VALUE = "Murmur3Partitioner";
    private static final String USERNAME = "cassandra.username";
    private static final String PASSWORD = "cassandra.password";
    private static final String INPUT_KEYSPACE_USERNAME_CONFIG = "cassandra.input.keyspace.username";
    private static final String INPUT_KEYSPACE_PASSWD_CONFIG = "cassandra.input.keyspace.passwd";
    private static HadoopFormatIOTestOptions options;
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    private final SimpleFunction<Row, String> myValueTranslate = new SimpleFunction<Row, String>(){

        public String apply(Row input) {
            return input.getString("y_id") + "|" + input.getString("field0") + "|" + input.getString("field1") + "|" + input.getString("field2") + "|" + input.getString("field3") + "|" + input.getString("field4") + "|" + input.getString("field5") + "|" + input.getString("field6") + "|" + input.getString("field7") + "|" + input.getString("field8") + "|" + input.getString("field9");
        }
    };

    @BeforeClass
    public static void setUp() {
        PipelineOptionsFactory.register(HadoopFormatIOTestOptions.class);
        options = (HadoopFormatIOTestOptions)TestPipeline.testingPipelineOptions().as(HadoopFormatIOTestOptions.class);
    }

    @Test
    public void testHIFReadForCassandra() {
        String expectedHashCode = "1a30ad400afe4ebf5fde75f5d2d95408";
        Long expectedRecordsCount = 1000L;
        Configuration conf = HadoopFormatIOCassandraIT.getConfiguration(options);
        PCollection cassandraData = (PCollection)this.pipeline.apply((PTransform)HadoopFormatIO.read().withConfiguration(conf).withValueTranslation(this.myValueTranslate));
        PAssert.thatSingleton((PCollection)((PCollection)cassandraData.apply("Count", Count.globally()))).isEqualTo((Object)expectedRecordsCount);
        PCollection textValues = (PCollection)cassandraData.apply((PTransform)Values.create());
        PCollection consolidatedHashcode = (PCollection)textValues.apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new HashingFn()).withoutDefaults());
        PAssert.that((PCollection)consolidatedHashcode).containsInAnyOrder((Object[])new String[]{expectedHashCode});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testHIFReadForCassandraQuery() {
        String expectedHashCode = "7bead6d6385c5f4dd0524720cd320b49";
        Long expectedNumRows = 1L;
        Configuration conf = HadoopFormatIOCassandraIT.getConfiguration(options);
        conf.set("cassandra.input.cql", "select * from ycsb.usertable where token(y_id) > ? and token(y_id) <= ? and field0 = 'user48:field0:431531'");
        PCollection cassandraData = (PCollection)this.pipeline.apply((PTransform)HadoopFormatIO.read().withConfiguration(conf).withValueTranslation(this.myValueTranslate));
        PAssert.thatSingleton((PCollection)((PCollection)cassandraData.apply("Count", Count.globally()))).isEqualTo((Object)expectedNumRows);
        PCollection textValues = (PCollection)cassandraData.apply((PTransform)Values.create());
        PCollection consolidatedHashcode = (PCollection)textValues.apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new HashingFn()).withoutDefaults());
        PAssert.that((PCollection)consolidatedHashcode).containsInAnyOrder((Object[])new String[]{expectedHashCode});
        this.pipeline.run().waitUntilFinish();
    }

    private static Configuration getConfiguration(HadoopFormatIOTestOptions options) {
        Configuration conf = new Configuration();
        conf.set(CASSANDRA_THRIFT_PORT_PROPERTY, options.getCassandraServerPort().toString());
        conf.set(CASSANDRA_THRIFT_ADDRESS_PROPERTY, options.getCassandraServerIp());
        conf.set(CASSANDRA_PARTITIONER_CLASS_PROPERTY, CASSANDRA_PARTITIONER_CLASS_VALUE);
        conf.set(CASSANDRA_KEYSPACE_PROPERTY, CASSANDRA_KEYSPACE);
        conf.set(CASSANDRA_COLUMNFAMILY_PROPERTY, CASSANDRA_TABLE);
        conf.set(USERNAME, options.getCassandraUserName());
        conf.set(PASSWORD, options.getCassandraPassword());
        conf.set(INPUT_KEYSPACE_USERNAME_CONFIG, options.getCassandraUserName());
        conf.set(INPUT_KEYSPACE_PASSWD_CONFIG, options.getCassandraPassword());
        conf.setClass("mapreduce.job.inputformat.class", CqlInputFormat.class, InputFormat.class);
        conf.setClass("key.class", Long.class, Object.class);
        conf.setClass("value.class", Row.class, Object.class);
        return conf;
    }
}

