/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop.format;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.beam.sdk.io.hadoop.format.HDFSSynchronization;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class HDFSSynchronizationTest {
    private static final String DEFAULT_JOB_ID = String.valueOf(1);
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    private HDFSSynchronization tested;
    private Configuration configuration;

    @Before
    public void setup() {
        this.tested = new HDFSSynchronization(this.tmpFolder.getRoot().getAbsolutePath());
        this.configuration = new Configuration();
        this.configuration.set("mapreduce.job.id", DEFAULT_JOB_ID);
    }

    @Test
    public void tryAcquireJobLockTest() {
        boolean firstAttempt = this.tested.tryAcquireJobLock(this.configuration);
        boolean secondAttempt = this.tested.tryAcquireJobLock(this.configuration);
        boolean thirdAttempt = this.tested.tryAcquireJobLock(this.configuration);
        Assert.assertTrue((boolean)this.isFileExists(this.getJobLockPath()));
        this.tested.releaseJobIdLock(this.configuration);
        boolean fourthAttempt = this.tested.tryAcquireJobLock(this.configuration);
        boolean fifthAttempt = this.tested.tryAcquireJobLock(this.configuration);
        Assert.assertTrue((boolean)firstAttempt);
        Assert.assertFalse((boolean)secondAttempt);
        Assert.assertFalse((boolean)thirdAttempt);
        Assert.assertTrue((boolean)fourthAttempt);
        Assert.assertFalse((boolean)fifthAttempt);
    }

    @Test(expected=NullPointerException.class)
    public void testMissingJobId() {
        Configuration conf = new Configuration();
        this.tested.tryAcquireJobLock(conf);
    }

    @Test
    public void testMultipleTaskDeletion() {
        String jobFolder = this.getFileInJobFolder("");
        this.tested.tryAcquireJobLock(this.configuration);
        Assert.assertTrue((boolean)this.isFileExists(this.getJobLockPath()));
        this.tested.releaseJobIdLock(this.configuration);
        Assert.assertFalse((boolean)this.isFileExists(this.getJobLockPath()));
        Assert.assertFalse((boolean)this.isFolderExists(jobFolder));
        this.tested.releaseJobIdLock(this.configuration);
    }

    @Test
    public void testTaskIdLockAcquire() {
        int tasksCount = 100;
        for (int i = 0; i < tasksCount; ++i) {
            TaskID taskID = this.tested.acquireTaskIdLock(this.configuration);
            Assert.assertTrue((boolean)this.isFileExists(this.getTaskIdPath(taskID)));
        }
        String jobFolderName = this.getFileInJobFolder("");
        File jobFolder = new File(jobFolderName);
        Assert.assertTrue((boolean)jobFolder.isDirectory());
        Assert.assertEquals((long)(tasksCount * 2), (long)jobFolder.list().length);
    }

    @Test
    public void testTaskAttemptIdAcquire() {
        int tasksCount = 100;
        int taskId = 25;
        for (int i = 0; i < tasksCount; ++i) {
            TaskAttemptID taskAttemptID = this.tested.acquireTaskAttemptIdLock(this.configuration, taskId);
            Assert.assertTrue((boolean)this.isFileExists(this.getTaskAttemptIdPath(taskId, taskAttemptID.getId())));
        }
    }

    @Test
    public void testCatchingRemoteException() throws IOException {
        FileSystem mockedFileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        RemoteException thrownException = new RemoteException(AlreadyBeingCreatedException.class.getName(), "Failed to CREATE_FILE");
        Mockito.when((Object)mockedFileSystem.createNewFile((Path)Mockito.any())).thenThrow(new Throwable[]{thrownException});
        HDFSSynchronization synchronization = new HDFSSynchronization("someDir", (HDFSSynchronization.ThrowingFunction & Serializable)conf -> mockedFileSystem);
        Assert.assertFalse((boolean)synchronization.tryAcquireJobLock(this.configuration));
    }

    private String getTaskAttemptIdPath(int taskId, int taskAttemptId) {
        return this.getFileInJobFolder(taskId + "_" + taskAttemptId);
    }

    private String getTaskIdPath(TaskID taskID) {
        return this.getFileInJobFolder(String.valueOf(taskID.getId()));
    }

    private String getJobLockPath() {
        return this.getFileInJobFolder("_job");
    }

    private String getFileInJobFolder(String filename) {
        return this.tmpFolder.getRoot().getAbsolutePath() + File.separator + DEFAULT_JOB_ID + File.separator + filename;
    }

    private boolean isFileExists(String path) {
        File file = new File(path);
        return file.exists() && !file.isDirectory();
    }

    private boolean isFolderExists(String path) {
        File file = new File(path);
        return file.exists();
    }
}

