/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hdfs;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.io.hdfs.HadoopFileSystemModule;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.hadoop.conf.Configuration;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HadoopFileSystemModuleTest {
    @Test
    public void testObjectMapperIsAbleToFindModule() {
        List modules = ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader());
        MatcherAssert.assertThat((Object)modules, (Matcher)Matchers.hasItem((Matcher)Matchers.instanceOf(HadoopFileSystemModule.class)));
    }

    @Test
    public void testConfigurationSerializationDeserialization() throws Exception {
        Configuration baseConfiguration = new Configuration(false);
        baseConfiguration.set("testPropertyA", "baseA");
        baseConfiguration.set("testPropertyC", "baseC");
        Configuration configuration = new Configuration(false);
        configuration.addResource(baseConfiguration);
        configuration.set("testPropertyA", "A");
        configuration.set("testPropertyB", "B");
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new HadoopFileSystemModule());
        String serializedConfiguration = objectMapper.writeValueAsString((Object)configuration);
        Configuration deserializedConfiguration = (Configuration)objectMapper.readValue(serializedConfiguration, Configuration.class);
        MatcherAssert.assertThat((Object)deserializedConfiguration, (Matcher)Matchers.containsInAnyOrder((Object[])new Map.Entry[]{new AbstractMap.SimpleEntry<String, String>("testPropertyA", "A"), new AbstractMap.SimpleEntry<String, String>("testPropertyB", "B"), new AbstractMap.SimpleEntry<String, String>("testPropertyC", "baseC")}));
    }
}

