/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hdfs;

import java.net.URI;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.beam.sdk.io.FileSystemRegistrar;
import org.apache.beam.sdk.io.hdfs.HadoopFileSystem;
import org.apache.beam.sdk.io.hdfs.HadoopFileSystemOptions;
import org.apache.beam.sdk.io.hdfs.HadoopFileSystemRegistrar;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HadoopFileSystemRegistrarTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    private Configuration configuration;
    private MiniDFSCluster hdfsCluster;
    private URI hdfsClusterBaseUri;

    @Before
    public void setUp() throws Exception {
        this.configuration = new Configuration();
        this.configuration.set("hdfs.minidfs.basedir", this.tmpFolder.getRoot().getAbsolutePath());
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(this.configuration);
        this.hdfsCluster = builder.build();
        this.hdfsClusterBaseUri = new URI(this.configuration.get("fs.defaultFS") + "/");
    }

    @After
    public void tearDown() {
        this.hdfsCluster.shutdown();
    }

    @Test
    public void testServiceLoader() {
        HadoopFileSystemOptions options = (HadoopFileSystemOptions)PipelineOptionsFactory.as(HadoopFileSystemOptions.class);
        options.setHdfsConfiguration((List)ImmutableList.of((Object)this.configuration));
        for (FileSystemRegistrar registrar : Lists.newArrayList(ServiceLoader.load(FileSystemRegistrar.class).iterator())) {
            if (!(registrar instanceof HadoopFileSystemRegistrar)) continue;
            Iterable fileSystems = registrar.fromOptions((PipelineOptions)options);
            Assert.assertEquals((Object)this.hdfsClusterBaseUri.getScheme(), (Object)((HadoopFileSystem)Iterables.getOnlyElement((Iterable)fileSystems)).getScheme());
            return;
        }
        Assert.fail((String)("Expected to find " + HadoopFileSystemRegistrar.class));
    }
}

