/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hdfs;

import java.net.URI;
import java.util.Collections;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.fs.ResourceIdTester;
import org.apache.beam.sdk.io.hdfs.HadoopFileSystemOptions;
import org.apache.beam.sdk.io.hdfs.HadoopResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HadoopResourceIdTest {
    private @UnknownKeyFor @NonNull @Initialized MiniDFSCluster hdfsCluster;
    private @UnknownKeyFor @NonNull @Initialized URI hdfsClusterBaseUri;
    @Rule
    public @UnknownKeyFor @NonNull @Initialized TemporaryFolder tmpFolder = new TemporaryFolder();

    @Before
    public void setUp() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Configuration configuration = new Configuration();
        configuration.set("hdfs.minidfs.basedir", this.tmpFolder.getRoot().getAbsolutePath());
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(configuration);
        this.hdfsCluster = builder.build();
        this.hdfsClusterBaseUri = new URI(configuration.get("fs.defaultFS") + "/");
        HadoopFileSystemOptions options = (HadoopFileSystemOptions)PipelineOptionsFactory.as(HadoopFileSystemOptions.class);
        options.setHdfsConfiguration(Collections.singletonList(configuration));
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
    }

    @After
    public void tearDown() {
        this.hdfsCluster.shutdown();
    }

    @Test
    public void testResourceIdTester() {
        ResourceId baseDirectory = FileSystems.matchNewResource((String)("hdfs://" + this.hdfsClusterBaseUri.getPath()), (boolean)true);
        ResourceIdTester.runResourceIdBattery((ResourceId)baseDirectory);
    }

    @Test
    public void testGetFilename() {
        Assert.assertNull((Object)this.toResourceIdentifier("").getFilename());
        Assert.assertEquals((Object)"abc", (Object)this.toResourceIdentifier("/dirA/abc").getFilename());
        Assert.assertEquals((Object)"abc", (Object)this.toResourceIdentifier("/dirA/abc/").getFilename());
        Assert.assertEquals((Object)"xyz.txt", (Object)this.toResourceIdentifier("/dirA/abc/xyz.txt").getFilename());
    }

    private @UnknownKeyFor @NonNull @Initialized ResourceId toResourceIdentifier(@UnknownKeyFor @NonNull @Initialized String path) {
        return new HadoopResourceId(this.hdfsClusterBaseUri.resolve(path));
    }
}

