/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hdfs;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.io.hdfs.HadoopFileSystemOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.Files;
import org.apache.hadoop.conf.Configuration;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class HadoopFileSystemOptionsTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testParsingHdfsConfiguration() {
        HadoopFileSystemOptions options = (HadoopFileSystemOptions)PipelineOptionsFactory.fromArgs((String[])new String[]{"--hdfsConfiguration=[{\"propertyA\": \"A\"},{\"propertyB\": \"B\"}]"}).as(HadoopFileSystemOptions.class);
        Assert.assertEquals((long)2L, (long)options.getHdfsConfiguration().size());
        Assert.assertThat((Object)((Configuration)options.getHdfsConfiguration().get(0)), (Matcher)Matchers.contains((Object[])new Map.Entry[]{new AbstractMap.SimpleEntry<String, String>("propertyA", "A")}));
        Assert.assertThat((Object)((Configuration)options.getHdfsConfiguration().get(1)), (Matcher)Matchers.contains((Object[])new Map.Entry[]{new AbstractMap.SimpleEntry<String, String>("propertyB", "B")}));
    }

    @Test
    public void testDefaultUnsetEnvHdfsConfiguration() {
        HadoopFileSystemOptions.ConfigurationLocator projectFactory = (HadoopFileSystemOptions.ConfigurationLocator)Mockito.spy((Object)new HadoopFileSystemOptions.ConfigurationLocator());
        Mockito.when((Object)projectFactory.getEnvironment()).thenReturn((Object)ImmutableMap.of());
        Assert.assertNull((Object)projectFactory.create(PipelineOptionsFactory.create()));
    }

    @Test
    public void testDefaultJustSetHadoopConfDirConfiguration() throws IOException {
        Files.write((CharSequence)HadoopFileSystemOptionsTest.createPropertyData("A"), (File)this.tmpFolder.newFile("core-site.xml"), (Charset)StandardCharsets.UTF_8);
        Files.write((CharSequence)HadoopFileSystemOptionsTest.createPropertyData("B"), (File)this.tmpFolder.newFile("hdfs-site.xml"), (Charset)StandardCharsets.UTF_8);
        HadoopFileSystemOptions.ConfigurationLocator configurationLocator = (HadoopFileSystemOptions.ConfigurationLocator)Mockito.spy((Object)new HadoopFileSystemOptions.ConfigurationLocator());
        HashMap environment = Maps.newHashMap();
        environment.put("HADOOP_CONF_DIR", this.tmpFolder.getRoot().getAbsolutePath());
        Mockito.when((Object)configurationLocator.getEnvironment()).thenReturn((Object)environment);
        List configurationList = configurationLocator.create(PipelineOptionsFactory.create());
        Assert.assertEquals((long)1L, (long)configurationList.size());
        Assert.assertThat((Object)((Configuration)configurationList.get(0)).get("propertyA"), (Matcher)Matchers.equalTo((Object)"A"));
        Assert.assertThat((Object)((Configuration)configurationList.get(0)).get("propertyB"), (Matcher)Matchers.equalTo((Object)"B"));
    }

    @Test
    public void testDefaultJustSetHadoopConfDirMultiPathConfiguration() throws IOException {
        File hadoopConfDir = this.tmpFolder.newFolder("hadoop");
        File otherConfDir = this.tmpFolder.newFolder("_other_");
        Files.write((CharSequence)HadoopFileSystemOptionsTest.createPropertyData("A"), (File)new File(hadoopConfDir, "core-site.xml"), (Charset)StandardCharsets.UTF_8);
        Files.write((CharSequence)HadoopFileSystemOptionsTest.createPropertyData("B"), (File)new File(hadoopConfDir, "hdfs-site.xml"), (Charset)StandardCharsets.UTF_8);
        HadoopFileSystemOptions.ConfigurationLocator configurationLocator = (HadoopFileSystemOptions.ConfigurationLocator)Mockito.spy((Object)new HadoopFileSystemOptions.ConfigurationLocator());
        String multiPath = hadoopConfDir.getAbsolutePath().concat(":").concat(otherConfDir.getAbsolutePath());
        HashMap environment = Maps.newHashMap();
        environment.put("HADOOP_CONF_DIR", multiPath);
        Mockito.when((Object)configurationLocator.getEnvironment()).thenReturn((Object)environment);
        List configurationList = configurationLocator.create(PipelineOptionsFactory.create());
        Assert.assertEquals((long)1L, (long)configurationList.size());
        Assert.assertThat((Object)((Configuration)configurationList.get(0)).get("propertyA"), (Matcher)Matchers.equalTo((Object)"A"));
        Assert.assertThat((Object)((Configuration)configurationList.get(0)).get("propertyB"), (Matcher)Matchers.equalTo((Object)"B"));
    }

    @Test
    public void testDefaultJustSetYarnConfDirConfiguration() throws IOException {
        Files.write((CharSequence)HadoopFileSystemOptionsTest.createPropertyData("A"), (File)this.tmpFolder.newFile("core-site.xml"), (Charset)StandardCharsets.UTF_8);
        Files.write((CharSequence)HadoopFileSystemOptionsTest.createPropertyData("B"), (File)this.tmpFolder.newFile("hdfs-site.xml"), (Charset)StandardCharsets.UTF_8);
        HadoopFileSystemOptions.ConfigurationLocator configurationLocator = (HadoopFileSystemOptions.ConfigurationLocator)Mockito.spy((Object)new HadoopFileSystemOptions.ConfigurationLocator());
        HashMap environment = Maps.newHashMap();
        environment.put("YARN_CONF_DIR", this.tmpFolder.getRoot().getAbsolutePath());
        Mockito.when((Object)configurationLocator.getEnvironment()).thenReturn((Object)environment);
        List configurationList = configurationLocator.create(PipelineOptionsFactory.create());
        Assert.assertEquals((long)1L, (long)configurationList.size());
        Assert.assertThat((Object)((Configuration)configurationList.get(0)).get("propertyA"), (Matcher)Matchers.equalTo((Object)"A"));
        Assert.assertThat((Object)((Configuration)configurationList.get(0)).get("propertyB"), (Matcher)Matchers.equalTo((Object)"B"));
    }

    @Test
    public void testDefaultJustSetYarnConfDirMultiPathConfiguration() throws IOException {
        File hadoopConfDir = this.tmpFolder.newFolder("hadoop");
        File otherConfDir = this.tmpFolder.newFolder("_other_");
        Files.write((CharSequence)HadoopFileSystemOptionsTest.createPropertyData("A"), (File)new File(hadoopConfDir, "core-site.xml"), (Charset)StandardCharsets.UTF_8);
        Files.write((CharSequence)HadoopFileSystemOptionsTest.createPropertyData("B"), (File)new File(hadoopConfDir, "hdfs-site.xml"), (Charset)StandardCharsets.UTF_8);
        HadoopFileSystemOptions.ConfigurationLocator configurationLocator = (HadoopFileSystemOptions.ConfigurationLocator)Mockito.spy((Object)new HadoopFileSystemOptions.ConfigurationLocator());
        String multiPath = hadoopConfDir.getAbsolutePath().concat(":").concat(otherConfDir.getAbsolutePath());
        HashMap environment = Maps.newHashMap();
        environment.put("YARN_CONF_DIR", multiPath);
        Mockito.when((Object)configurationLocator.getEnvironment()).thenReturn((Object)environment);
        List configurationList = configurationLocator.create(PipelineOptionsFactory.create());
        Assert.assertEquals((long)1L, (long)configurationList.size());
        Assert.assertThat((Object)((Configuration)configurationList.get(0)).get("propertyA"), (Matcher)Matchers.equalTo((Object)"A"));
        Assert.assertThat((Object)((Configuration)configurationList.get(0)).get("propertyB"), (Matcher)Matchers.equalTo((Object)"B"));
    }

    @Test
    public void testDefaultSetYarnConfDirAndHadoopConfDirAndSameConfiguration() throws IOException {
        Files.write((CharSequence)HadoopFileSystemOptionsTest.createPropertyData("A"), (File)this.tmpFolder.newFile("core-site.xml"), (Charset)StandardCharsets.UTF_8);
        Files.write((CharSequence)HadoopFileSystemOptionsTest.createPropertyData("B"), (File)this.tmpFolder.newFile("hdfs-site.xml"), (Charset)StandardCharsets.UTF_8);
        HadoopFileSystemOptions.ConfigurationLocator configurationLocator = (HadoopFileSystemOptions.ConfigurationLocator)Mockito.spy((Object)new HadoopFileSystemOptions.ConfigurationLocator());
        HashMap environment = Maps.newHashMap();
        environment.put("YARN_CONF_DIR", this.tmpFolder.getRoot().getAbsolutePath());
        environment.put("HADOOP_CONF_DIR", this.tmpFolder.getRoot().getAbsolutePath());
        Mockito.when((Object)configurationLocator.getEnvironment()).thenReturn((Object)environment);
        List configurationList = configurationLocator.create(PipelineOptionsFactory.create());
        Assert.assertEquals((long)1L, (long)configurationList.size());
        Assert.assertThat((Object)((Configuration)configurationList.get(0)).get("propertyA"), (Matcher)Matchers.equalTo((Object)"A"));
        Assert.assertThat((Object)((Configuration)configurationList.get(0)).get("propertyB"), (Matcher)Matchers.equalTo((Object)"B"));
    }

    @Test
    public void testDefaultSetYarnConfDirAndHadoopConfDirMultiPathAndSameConfiguration() throws IOException {
        File hadoopConfDir = this.tmpFolder.newFolder("hadoop");
        File otherConfDir = this.tmpFolder.newFolder("_other_");
        Files.write((CharSequence)HadoopFileSystemOptionsTest.createPropertyData("A"), (File)new File(hadoopConfDir, "core-site.xml"), (Charset)StandardCharsets.UTF_8);
        Files.write((CharSequence)HadoopFileSystemOptionsTest.createPropertyData("B"), (File)new File(hadoopConfDir, "hdfs-site.xml"), (Charset)StandardCharsets.UTF_8);
        HadoopFileSystemOptions.ConfigurationLocator configurationLocator = (HadoopFileSystemOptions.ConfigurationLocator)Mockito.spy((Object)new HadoopFileSystemOptions.ConfigurationLocator());
        String multiPath = hadoopConfDir.getAbsolutePath().concat(":").concat(otherConfDir.getAbsolutePath());
        HashMap environment = Maps.newHashMap();
        environment.put("YARN_CONF_DIR", multiPath);
        environment.put("HADOOP_CONF_DIR", multiPath);
        Mockito.when((Object)configurationLocator.getEnvironment()).thenReturn((Object)environment);
        List configurationList = configurationLocator.create(PipelineOptionsFactory.create());
        Assert.assertEquals((long)1L, (long)configurationList.size());
        Assert.assertThat((Object)((Configuration)configurationList.get(0)).get("propertyA"), (Matcher)Matchers.equalTo((Object)"A"));
        Assert.assertThat((Object)((Configuration)configurationList.get(0)).get("propertyB"), (Matcher)Matchers.equalTo((Object)"B"));
    }

    @Test
    public void testDefaultSetYarnConfDirAndHadoopConfDirNotSameConfiguration() throws IOException {
        File hadoopConfDir = this.tmpFolder.newFolder("hadoop");
        File yarnConfDir = this.tmpFolder.newFolder("yarn");
        Files.write((CharSequence)HadoopFileSystemOptionsTest.createPropertyData("A"), (File)new File(hadoopConfDir, "core-site.xml"), (Charset)StandardCharsets.UTF_8);
        Files.write((CharSequence)HadoopFileSystemOptionsTest.createPropertyData("B"), (File)new File(hadoopConfDir, "hdfs-site.xml"), (Charset)StandardCharsets.UTF_8);
        Files.write((CharSequence)HadoopFileSystemOptionsTest.createPropertyData("C"), (File)new File(yarnConfDir, "core-site.xml"), (Charset)StandardCharsets.UTF_8);
        Files.write((CharSequence)HadoopFileSystemOptionsTest.createPropertyData("D"), (File)new File(yarnConfDir, "hdfs-site.xml"), (Charset)StandardCharsets.UTF_8);
        HadoopFileSystemOptions.ConfigurationLocator configurationLocator = (HadoopFileSystemOptions.ConfigurationLocator)Mockito.spy((Object)new HadoopFileSystemOptions.ConfigurationLocator());
        HashMap environment = Maps.newHashMap();
        environment.put("YARN_CONF_DIR", hadoopConfDir.getAbsolutePath());
        environment.put("HADOOP_CONF_DIR", yarnConfDir.getAbsolutePath());
        Mockito.when((Object)configurationLocator.getEnvironment()).thenReturn((Object)environment);
        List configurationList = configurationLocator.create(PipelineOptionsFactory.create());
        Assert.assertEquals((long)2L, (long)configurationList.size());
        int hadoopConfIndex = ((Configuration)configurationList.get(0)).get("propertyA") != null ? 0 : 1;
        Assert.assertThat((Object)((Configuration)configurationList.get(hadoopConfIndex)).get("propertyA"), (Matcher)Matchers.equalTo((Object)"A"));
        Assert.assertThat((Object)((Configuration)configurationList.get(hadoopConfIndex)).get("propertyB"), (Matcher)Matchers.equalTo((Object)"B"));
        Assert.assertThat((Object)((Configuration)configurationList.get(1 - hadoopConfIndex)).get("propertyC"), (Matcher)Matchers.equalTo((Object)"C"));
        Assert.assertThat((Object)((Configuration)configurationList.get(1 - hadoopConfIndex)).get("propertyD"), (Matcher)Matchers.equalTo((Object)"D"));
    }

    private static String createPropertyData(String property) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?xml-stylesheet type=\"text/xsl\" href=\"configuration.xsl\"?>\n<configuration>\n    <property>\n        <name>property" + property + "</name>\n        <value>" + property + "</value>\n    </property>\n</configuration>";
    }
}

