/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop;

import java.io.Serializable;
import java.util.Map;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.SerializationUtils;
import org.apache.beam.sdk.io.hadoop.SerializableConfiguration;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SerializableConfigurationTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private static final SerializableConfiguration DEFAULT_SERIALIZABLE_CONF = new SerializableConfiguration(new Configuration());

    @Test
    public void testSerializationDeserialization() {
        Configuration conf = new Configuration();
        conf.set("hadoop.silly.test", "test-value");
        byte[] object = SerializationUtils.serialize((Serializable)new SerializableConfiguration(conf));
        SerializableConfiguration serConf = (SerializableConfiguration)SerializationUtils.deserialize((byte[])object);
        Assert.assertNotNull((Object)serConf);
        Assert.assertEquals((Object)"test-value", (Object)serConf.get().get("hadoop.silly.test"));
    }

    @Test
    public void testConstruction() {
        Assert.assertNotNull((Object)DEFAULT_SERIALIZABLE_CONF);
        Assert.assertNotNull((Object)DEFAULT_SERIALIZABLE_CONF.get());
        this.thrown.expect(NullPointerException.class);
        new SerializableConfiguration(null);
    }

    @Test
    public void testCreateNewConfiguration() {
        Configuration confFromNull = SerializableConfiguration.newConfiguration(null);
        Assert.assertNotNull((Object)confFromNull);
        Configuration conf = SerializableConfiguration.newConfiguration((SerializableConfiguration)new SerializableConfiguration(confFromNull));
        Assert.assertNotNull((Object)conf);
    }

    @Test
    public void testCreateNewJob() throws Exception {
        Job jobFromNull = SerializableConfiguration.newJob(null);
        Assert.assertNotNull((Object)jobFromNull);
        Job job = SerializableConfiguration.newJob((SerializableConfiguration)DEFAULT_SERIALIZABLE_CONF);
        Assert.assertNotNull((Object)job);
    }

    @Test
    public void testFromMap() {
        SerializableConfiguration testConf = SerializableConfiguration.fromMap((Map)ImmutableMap.of((Object)"hadoop.silly.test", (Object)"test-value"));
        Assert.assertEquals((Object)"test-value", (Object)testConf.get().get("hadoop.silly.test", "default-value"));
    }
}

