/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.auto.service.AutoService;
import java.util.Map;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.schemas.io.Failure;
import org.apache.beam.sdk.schemas.io.GenericDlqProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
@AutoService(value={GenericDlqProvider.class})
public class PubsubDlqProvider
implements GenericDlqProvider {
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "pubsub";
    }

    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Failure>, @UnknownKeyFor @NonNull @Initialized PDone> newDlqTransform(@UnknownKeyFor @NonNull @Initialized String config) {
        return new DlqTransform(config);
    }

    private static class DlqTransform
    extends PTransform<PCollection<Failure>, PDone> {
        private final @UnknownKeyFor @NonNull @Initialized String topic;

        DlqTransform(@UnknownKeyFor @NonNull @Initialized String topic) {
            this.topic = topic;
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Failure> input) {
            return (PDone)((PCollection)input.apply("Failure to PubsubMessage", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(PubsubMessage.class)).via(DlqTransform::getMessage))).apply("Write Failures to Pub/Sub", PubsubIO.writeMessages().to(this.topic));
        }

        private static @UnknownKeyFor @NonNull @Initialized PubsubMessage getMessage(@UnknownKeyFor @NonNull @Initialized Failure failure) {
            return new PubsubMessage(failure.getPayload(), (Map<String, String>)ImmutableMap.of((Object)"beam-dlq-error", (Object)failure.getError()));
        }
    }
}

