/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.bigtable.AutoValue_BigtableWriteOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

@AutoValue
abstract class BigtableWriteOptions
implements Serializable {
    BigtableWriteOptions() {
    }

    abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getTableId();

    abstract @Nullable @UnknownKeyFor @Initialized Duration getAttemptTimeout();

    abstract @Nullable @UnknownKeyFor @Initialized Duration getOperationTimeout();

    abstract @Nullable @UnknownKeyFor @Initialized Long getMaxElementsPerBatch();

    abstract @Nullable @UnknownKeyFor @Initialized Long getMaxBytesPerBatch();

    abstract @Nullable @UnknownKeyFor @Initialized Long getMaxOutstandingElements();

    abstract @Nullable @UnknownKeyFor @Initialized Long getMaxOutstandingBytes();

    abstract @Nullable @UnknownKeyFor @Initialized Integer getThrottlingTargetMs();

    abstract @Nullable @UnknownKeyFor @Initialized Boolean getFlowControl();

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_BigtableWriteOptions.Builder();
    }

    @UnknownKeyFor @NonNull @Initialized boolean isDataAccessible() {
        return this.getTableId() != null && this.getTableId().isAccessible();
    }

    void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        builder.addIfNotNull(DisplayData.item((String)"tableId", this.getTableId()).withLabel("Bigtable Table Id")).addIfNotNull(DisplayData.item((String)"attemptTimeout", (Duration)this.getAttemptTimeout()).withLabel("Write Attempt Timeout")).addIfNotNull(DisplayData.item((String)"operationTimeout", (Duration)this.getOperationTimeout()).withLabel("Write Operation Timeout")).addIfNotNull(DisplayData.item((String)"maxElementsPerBatch", (Long)this.getMaxElementsPerBatch()).withLabel("Write batch element count")).addIfNotNull(DisplayData.item((String)"maxBytesPerBatch", (Long)this.getMaxBytesPerBatch()).withLabel("Write batch byte size")).addIfNotNull(DisplayData.item((String)"maxOutstandingElements", (Long)this.getMaxOutstandingElements()).withLabel("Write max outstanding elements")).addIfNotNull(DisplayData.item((String)"maxOutstandingBytes", (Long)this.getMaxOutstandingBytes()).withLabel("Write max outstanding bytes")).addIfNotNull(DisplayData.item((String)"flowControl", (Boolean)this.getFlowControl()).withLabel("Write flow control is enabled"));
    }

    void validate() {
        Preconditions.checkArgument((this.getTableId() != null && (!this.getTableId().isAccessible() || !((String)this.getTableId().get()).isEmpty()) ? 1 : 0) != 0, (Object)"Could not obtain Bigtable table id");
        if (this.getAttemptTimeout() != null && this.getOperationTimeout() != null) {
            Preconditions.checkArgument((boolean)this.getAttemptTimeout().isShorterThan((ReadableDuration)this.getOperationTimeout()), (Object)"attempt timeout can't be longer than operation timeout");
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setTableId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setAttemptTimeout(@UnknownKeyFor @NonNull @Initialized Duration var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setOperationTimeout(@UnknownKeyFor @NonNull @Initialized Duration var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxElementsPerBatch(@UnknownKeyFor @NonNull @Initialized long var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxBytesPerBatch(@UnknownKeyFor @NonNull @Initialized long var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxOutstandingElements(@UnknownKeyFor @NonNull @Initialized long var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxOutstandingBytes(@UnknownKeyFor @NonNull @Initialized long var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setThrottlingTargetMs(@UnknownKeyFor @NonNull @Initialized int var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setFlowControl(@UnknownKeyFor @NonNull @Initialized boolean var1);

        abstract @UnknownKeyFor @NonNull @Initialized BigtableWriteOptions build();
    }
}

