/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.testing;

import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableRow;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.gcp.testing.BigqueryMatcher;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffAdapter;
import org.apache.beam.sdk.util.FastNanoClockAndSleeper;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class BigqueryMatcherTest {
    private final String appName = "test-app";
    private final String projectId = "test-project";
    private final String query = "test-query";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public FastNanoClockAndSleeper fastClock = new FastNanoClockAndSleeper();
    @Mock
    private Bigquery mockBigqueryClient;
    @Mock
    private Bigquery.Jobs mockJobs;
    @Mock
    private Bigquery.Jobs.Query mockQuery;
    @Mock
    private PipelineResult mockResult;

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockBigqueryClient.jobs()).thenReturn((Object)this.mockJobs);
        Mockito.when((Object)this.mockJobs.query(Matchers.anyString(), (QueryRequest)Matchers.any(QueryRequest.class))).thenReturn((Object)this.mockQuery);
    }

    @Test
    public void testBigqueryMatcherThatSucceeds() throws Exception {
        BigqueryMatcher matcher = (BigqueryMatcher)((Object)Mockito.spy((Object)((Object)new BigqueryMatcher("test-app", "test-project", "test-query", "9bb47f5c90d2a99cad526453dff5ed5ec74650dc"))));
        ((BigqueryMatcher)((Object)Mockito.doReturn((Object)this.mockBigqueryClient).when((Object)matcher))).newBigqueryClient(Matchers.anyString());
        Mockito.when((Object)((QueryResponse)this.mockQuery.execute())).thenReturn((Object)this.createResponseContainingTestData());
        MatcherAssert.assertThat((Object)this.mockResult, (Matcher)matcher);
        ((BigqueryMatcher)((Object)Mockito.verify((Object)((Object)matcher)))).newBigqueryClient((String)Matchers.eq((Object)"test-app"));
        ((Bigquery.Jobs)Mockito.verify((Object)this.mockJobs)).query((String)Matchers.eq((Object)"test-project"), (QueryRequest)Matchers.eq((Object)new QueryRequest().setQuery("test-query")));
    }

    @Test
    public void testBigqueryMatcherFailsForChecksumMismatch() throws IOException {
        BigqueryMatcher matcher = (BigqueryMatcher)((Object)Mockito.spy((Object)((Object)new BigqueryMatcher("test-app", "test-project", "test-query", "incorrect-checksum"))));
        ((BigqueryMatcher)((Object)Mockito.doReturn((Object)this.mockBigqueryClient).when((Object)matcher))).newBigqueryClient(Matchers.anyString());
        Mockito.when((Object)((QueryResponse)this.mockQuery.execute())).thenReturn((Object)this.createResponseContainingTestData());
        this.thrown.expect(AssertionError.class);
        this.thrown.expectMessage("Total number of rows are: 1");
        this.thrown.expectMessage("abc");
        try {
            MatcherAssert.assertThat((Object)this.mockResult, (Matcher)matcher);
        }
        finally {
            ((BigqueryMatcher)((Object)Mockito.verify((Object)((Object)matcher)))).newBigqueryClient((String)Matchers.eq((Object)"test-app"));
            ((Bigquery.Jobs)Mockito.verify((Object)this.mockJobs)).query((String)Matchers.eq((Object)"test-project"), (QueryRequest)Matchers.eq((Object)new QueryRequest().setQuery("test-query")));
        }
    }

    @Test
    public void testBigqueryMatcherFailsWhenQueryJobNotComplete() throws Exception {
        BigqueryMatcher matcher = (BigqueryMatcher)((Object)Mockito.spy((Object)((Object)new BigqueryMatcher("test-app", "test-project", "test-query", "some-checksum"))));
        ((BigqueryMatcher)((Object)Mockito.doReturn((Object)this.mockBigqueryClient).when((Object)matcher))).newBigqueryClient(Matchers.anyString());
        Mockito.when((Object)((QueryResponse)this.mockQuery.execute())).thenReturn((Object)new QueryResponse().setJobComplete(Boolean.valueOf(false)));
        this.thrown.expect(AssertionError.class);
        this.thrown.expectMessage("The query job hasn't completed.");
        this.thrown.expectMessage("jobComplete=false");
        try {
            MatcherAssert.assertThat((Object)this.mockResult, (Matcher)matcher);
        }
        finally {
            ((BigqueryMatcher)((Object)Mockito.verify((Object)((Object)matcher)))).newBigqueryClient((String)Matchers.eq((Object)"test-app"));
            ((Bigquery.Jobs)Mockito.verify((Object)this.mockJobs)).query((String)Matchers.eq((Object)"test-project"), (QueryRequest)Matchers.eq((Object)new QueryRequest().setQuery("test-query")));
        }
    }

    @Test
    public void testQueryWithRetriesWhenServiceFails() throws Exception {
        BigqueryMatcher matcher = (BigqueryMatcher)((Object)Mockito.spy((Object)((Object)new BigqueryMatcher("test-app", "test-project", "test-query", "some-checksum"))));
        Mockito.when((Object)((QueryResponse)this.mockQuery.execute())).thenThrow(new Throwable[]{new IOException()});
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("Unable to get BigQuery response after retrying");
        try {
            matcher.queryWithRetries(this.mockBigqueryClient, new QueryRequest(), (Sleeper)this.fastClock, BackOffAdapter.toGcpBackOff((BackOff)BigqueryMatcher.BACKOFF_FACTORY.backoff()));
        }
        finally {
            ((Bigquery.Jobs)Mockito.verify((Object)this.mockJobs, (VerificationMode)Mockito.atLeast((int)4))).query((String)Matchers.eq((Object)"test-project"), (QueryRequest)Matchers.eq((Object)new QueryRequest()));
        }
    }

    @Test
    public void testQueryWithRetriesWhenQueryResponseNull() throws Exception {
        BigqueryMatcher matcher = (BigqueryMatcher)((Object)Mockito.spy((Object)((Object)new BigqueryMatcher("test-app", "test-project", "test-query", "some-checksum"))));
        Mockito.when((Object)((QueryResponse)this.mockQuery.execute())).thenReturn(null);
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("Unable to get BigQuery response after retrying");
        try {
            matcher.queryWithRetries(this.mockBigqueryClient, new QueryRequest(), (Sleeper)this.fastClock, BackOffAdapter.toGcpBackOff((BackOff)BigqueryMatcher.BACKOFF_FACTORY.backoff()));
        }
        finally {
            ((Bigquery.Jobs)Mockito.verify((Object)this.mockJobs, (VerificationMode)Mockito.atLeast((int)4))).query((String)Matchers.eq((Object)"test-project"), (QueryRequest)Matchers.eq((Object)new QueryRequest()));
        }
    }

    private QueryResponse createResponseContainingTestData() {
        TableCell field1 = new TableCell();
        field1.setV((Object)"abc");
        TableCell field2 = new TableCell();
        field2.setV((Object)"2");
        TableCell field3 = new TableCell();
        field3.setV((Object)"testing BigQuery matcher.");
        TableRow row = new TableRow();
        row.setF((List)Lists.newArrayList((Object[])new TableCell[]{field1, field2, field3}));
        QueryResponse response = new QueryResponse();
        response.setJobComplete(Boolean.valueOf(true));
        response.setRows((List)Lists.newArrayList((Object[])new TableRow[]{row}));
        response.setTotalRows(BigInteger.ONE);
        return response;
    }
}

