/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.testing;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableRow;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.testing.SerializableMatcher;
import org.apache.beam.sdk.util.BackOffAdapter;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Transport;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class BigqueryMatcher
extends TypeSafeMatcher<PipelineResult>
implements SerializableMatcher<PipelineResult> {
    private static final Logger LOG = LoggerFactory.getLogger(BigqueryMatcher.class);
    static final int MAX_QUERY_RETRIES = 4;
    private static final Duration INITIAL_BACKOFF = Duration.standardSeconds((long)1L);
    private static final int TOTAL_FORMATTED_ROWS = 20;
    static final FluentBackoff BACKOFF_FACTORY = FluentBackoff.DEFAULT.withMaxRetries(4).withInitialBackoff(INITIAL_BACKOFF);
    private final String applicationName;
    private final String projectId;
    private final String query;
    private final String expectedChecksum;
    private String actualChecksum;
    private transient QueryResponse response;

    public BigqueryMatcher(String applicationName, String projectId, String query, String expectedChecksum) {
        this.validateArgument("applicationName", applicationName);
        this.validateArgument("projectId", projectId);
        this.validateArgument("query", query);
        this.validateArgument("expectedChecksum", expectedChecksum);
        this.applicationName = applicationName;
        this.projectId = projectId;
        this.query = query;
        this.expectedChecksum = expectedChecksum;
    }

    protected boolean matchesSafely(PipelineResult pipelineResult) {
        LOG.info("Verifying Bigquery data");
        Bigquery bigqueryClient = this.newBigqueryClient(this.applicationName);
        LOG.debug("Executing query: {}", (Object)this.query);
        try {
            QueryRequest queryContent = new QueryRequest();
            queryContent.setQuery(this.query);
            this.response = this.queryWithRetries(bigqueryClient, queryContent, Sleeper.DEFAULT, BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)BACKOFF_FACTORY.backoff()));
        }
        catch (IOException | InterruptedException e) {
            if (e instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException("Failed to fetch BigQuery data.", e);
        }
        if (!this.response.getJobComplete().booleanValue()) {
            return false;
        }
        this.actualChecksum = this.generateHash(this.response.getRows());
        LOG.debug("Generated a SHA1 checksum based on queried data: {}", (Object)this.actualChecksum);
        return this.expectedChecksum.equals(this.actualChecksum);
    }

    @VisibleForTesting
    Bigquery newBigqueryClient(String applicationName) {
        HttpTransport transport = Transport.getTransport();
        JsonFactory jsonFactory = Transport.getJsonFactory();
        Credentials credential = this.getDefaultCredential();
        return new Bigquery.Builder(transport, jsonFactory, (HttpRequestInitializer)new HttpCredentialsAdapter(credential)).setApplicationName(applicationName).build();
    }

    @Nonnull
    @VisibleForTesting
    QueryResponse queryWithRetries(Bigquery bigqueryClient, QueryRequest queryContent, Sleeper sleeper, BackOff backOff) throws IOException, InterruptedException {
        IOException lastException = null;
        do {
            if (lastException != null) {
                LOG.warn("Retrying query ({}) after exception", (Object)queryContent.getQuery(), (Object)lastException);
            }
            try {
                QueryResponse response = (QueryResponse)bigqueryClient.jobs().query(this.projectId, queryContent).execute();
                if (response != null) {
                    return response;
                }
                lastException = new IOException("Expected valid response from query job, but received null.");
            }
            catch (IOException e) {
                lastException = e;
            }
        } while (BackOffUtils.next((Sleeper)sleeper, (BackOff)backOff));
        throw new RuntimeException(String.format("Unable to get BigQuery response after retrying %d times using query (%s)", 4, queryContent.getQuery()), lastException);
    }

    private void validateArgument(String name, String value) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0, (String)"Expected valid %s, but was %s", (Object)name, (Object)value);
    }

    private Credentials getDefaultCredential() {
        GoogleCredentials credential;
        try {
            credential = GoogleCredentials.getApplicationDefault();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get application default credential.", e);
        }
        if (credential.createScopedRequired()) {
            ArrayList bigqueryScope = Lists.newArrayList((Object[])new String[]{"https://www.googleapis.com/auth/cloud-platform.read-only"});
            credential = credential.createScoped((Collection)bigqueryScope);
        }
        return credential;
    }

    private String generateHash(@Nonnull List<TableRow> rows) {
        ArrayList rowHashes = Lists.newArrayList();
        for (TableRow row : rows) {
            ArrayList cellsInOneRow = Lists.newArrayList();
            for (TableCell cell : row.getF()) {
                cellsInOneRow.add(Objects.toString(cell.getV()));
                Collections.sort(cellsInOneRow);
            }
            rowHashes.add(Hashing.sha1().hashString((CharSequence)((Object)cellsInOneRow).toString(), StandardCharsets.UTF_8));
        }
        return Hashing.combineUnordered((Iterable)rowHashes).toString();
    }

    public void describeTo(Description description) {
        description.appendText("Expected checksum is (").appendText(this.expectedChecksum).appendText(")");
    }

    public void describeMismatchSafely(PipelineResult pResult, Description description) {
        String info = this.response.getJobComplete() == false ? String.format("The query job hasn't completed. Got response: %s", this.response) : String.format("was (%s).%n\tTotal number of rows are: %d.%n\tQueried data details:%s", this.actualChecksum, this.response.getTotalRows(), this.formatRows(20));
        description.appendText(info);
    }

    private String formatRows(int totalNumRows) {
        StringBuilder samples = new StringBuilder();
        List rows = this.response.getRows();
        for (int i = 0; i < totalNumRows && i < rows.size(); ++i) {
            samples.append(String.format("%n\t\t", new Object[0]));
            for (TableCell field : ((TableRow)rows.get(i)).getF()) {
                samples.append(String.format("%-10s", field.getV()));
            }
        }
        if (rows.size() > totalNumRows) {
            samples.append(String.format("%n\t\t...", new Object[0]));
        }
        return samples.toString();
    }
}

