/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.junit.Assert;
import org.junit.Test;

public class SpannerSchemaTest {
    @Test
    public void testSingleTable() throws Exception {
        SpannerSchema schema = SpannerSchema.builder().addColumn("test", "pk", "STRING(48)").addKeyPart("test", "pk", false).addColumn("test", "maxKey", "STRING(MAX)").build();
        Assert.assertEquals((long)1L, (long)schema.getTables().size());
        Assert.assertEquals((long)2L, (long)schema.getColumns("test").size());
        Assert.assertEquals((long)1L, (long)schema.getKeyParts("test").size());
    }

    @Test
    public void testTwoTables() throws Exception {
        SpannerSchema schema = SpannerSchema.builder().addColumn("test", "pk", "STRING(48)").addKeyPart("test", "pk", false).addColumn("test", "maxKey", "STRING(MAX)").addColumn("other", "pk", "INT64").addKeyPart("other", "pk", true).addColumn("other", "maxKey", "STRING(MAX)").build();
        Assert.assertEquals((long)2L, (long)schema.getTables().size());
        Assert.assertEquals((long)2L, (long)schema.getColumns("test").size());
        Assert.assertEquals((long)1L, (long)schema.getKeyParts("test").size());
        Assert.assertEquals((long)2L, (long)schema.getColumns("other").size());
        Assert.assertEquals((long)1L, (long)schema.getKeyParts("other").size());
    }
}

