/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.WaitForOption;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Operation;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.TimestampBound;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.spanner.RandomUtils;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SpannerReadIT {
    private static final int MAX_DB_NAME_LENGTH = 30;
    @Rule
    public final transient TestPipeline p = TestPipeline.create();
    private Spanner spanner;
    private DatabaseAdminClient databaseAdminClient;
    private SpannerTestPipelineOptions options;
    private String databaseName;
    private String project;

    @Before
    public void setUp() throws Exception {
        PipelineOptionsFactory.register(SpannerTestPipelineOptions.class);
        this.options = (SpannerTestPipelineOptions)TestPipeline.testingPipelineOptions().as(SpannerTestPipelineOptions.class);
        this.project = ((GcpOptions)this.options.as(GcpOptions.class)).getProject();
        this.spanner = (Spanner)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(this.project)).build().getService();
        this.databaseName = this.generateDatabaseName();
        this.databaseAdminClient = this.spanner.getDatabaseAdminClient();
        this.databaseAdminClient.dropDatabase(this.options.getInstanceId(), this.databaseName);
        Operation op = this.databaseAdminClient.createDatabase(this.options.getInstanceId(), this.databaseName, Collections.singleton("CREATE TABLE " + this.options.getTable() + " (  Key           INT64,  Value         STRING(MAX),) PRIMARY KEY (Key)"));
        op.waitFor(new WaitForOption[0]);
        this.makeTestData();
    }

    @Test
    public void testRead() throws Exception {
        SpannerConfig spannerConfig = this.createSpannerConfig();
        PCollectionView tx = (PCollectionView)this.p.apply((PTransform)SpannerIO.createTransaction().withSpannerConfig(spannerConfig).withTimestampBound(TimestampBound.strong()));
        PCollection output = (PCollection)this.p.apply((PTransform)SpannerIO.read().withSpannerConfig(spannerConfig).withTable(this.options.getTable()).withColumns(new String[]{"Key", "Value"}).withTransaction(tx));
        PAssert.thatSingleton((PCollection)((PCollection)output.apply("Count rows", Count.globally()))).isEqualTo((Object)5L);
        this.p.run();
    }

    @Test
    public void testQuery() throws Exception {
        SpannerConfig spannerConfig = this.createSpannerConfig();
        PCollectionView tx = (PCollectionView)this.p.apply((PTransform)SpannerIO.createTransaction().withSpannerConfig(spannerConfig).withTimestampBound(TimestampBound.strong()));
        PCollection output = (PCollection)this.p.apply((PTransform)SpannerIO.read().withSpannerConfig(spannerConfig).withQuery("SELECT * FROM " + this.options.getTable()).withTransaction(tx));
        PAssert.thatSingleton((PCollection)((PCollection)output.apply("Count rows", Count.globally()))).isEqualTo((Object)5L);
        this.p.run();
    }

    @Test
    public void testReadAllRecordsInDb() throws Exception {
        SpannerConfig spannerConfig = this.createSpannerConfig();
        PCollectionView tx = (PCollectionView)this.p.apply((PTransform)SpannerIO.createTransaction().withSpannerConfig(spannerConfig).withTimestampBound(TimestampBound.strong()));
        PCollection allRecords = (PCollection)((PCollection)((PCollection)this.p.apply((PTransform)SpannerIO.read().withSpannerConfig(spannerConfig).withBatching(false).withQuery("SELECT t.table_name FROM information_schema.tables AS t WHERE t.table_catalog = '' AND t.table_schema = ''"))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(ReadOperation.class)).via((SerializableFunction & Serializable)input -> {
            String tableName = input.getString(0);
            return ReadOperation.create().withQuery("SELECT * FROM " + tableName);
        }))).apply((PTransform)SpannerIO.readAll().withTransaction(tx).withSpannerConfig(spannerConfig));
        PAssert.thatSingleton((PCollection)((PCollection)allRecords.apply("Count rows", Count.globally()))).isEqualTo((Object)5L);
        this.p.run();
    }

    private void makeTestData() {
        DatabaseClient databaseClient = this.getDatabaseClient();
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        int i = 0;
        while ((long)i < 5L) {
            mutations.add(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)this.options.getTable()).set("key").to((long)i)).set("value").to(RandomUtils.randomAlphaNumeric(100))).build());
            ++i;
        }
        databaseClient.writeAtLeastOnce(mutations);
    }

    private SpannerConfig createSpannerConfig() {
        return SpannerConfig.create().withProjectId(this.project).withInstanceId(this.options.getInstanceId()).withDatabaseId(this.databaseName);
    }

    private DatabaseClient getDatabaseClient() {
        return this.spanner.getDatabaseClient(DatabaseId.of((String)this.project, (String)this.options.getInstanceId(), (String)this.databaseName));
    }

    @After
    public void tearDown() throws Exception {
        this.databaseAdminClient.dropDatabase(this.options.getInstanceId(), this.databaseName);
        this.spanner.close();
    }

    private String generateDatabaseName() {
        String random = RandomUtils.randomAlphaNumeric(29 - this.options.getDatabaseIdPrefix().length());
        return this.options.getDatabaseIdPrefix() + "-" + random;
    }

    public static interface SpannerTestPipelineOptions
    extends TestPipelineOptions {
        @Description(value="Instance ID to write to in Spanner")
        @Default.String(value="beam-test")
        public String getInstanceId();

        public void setInstanceId(String var1);

        @Description(value="Database ID prefix to write to in Spanner")
        @Default.String(value="beam-testdb")
        public String getDatabaseIdPrefix();

        public void setDatabaseIdPrefix(String var1);

        @Description(value="Table name")
        @Default.String(value="users")
        public String getTable();

        public void setTable(String var1);
    }
}

