/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ServiceFactory;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeyRange;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.spanner.FakeServiceFactory;
import org.apache.beam.sdk.io.gcp.spanner.MutationGroup;
import org.apache.beam.sdk.io.gcp.spanner.MutationGroupEncoder;
import org.apache.beam.sdk.io.gcp.spanner.MutationSizeEstimator;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.apache.beam.sdk.io.gcp.spanner.SpannerWriteResult;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class SpannerIOWriteTest
implements Serializable {
    private static final long CELLS_PER_KEY = 7L;
    @Rule
    public transient TestPipeline pipeline = TestPipeline.create();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();
    private FakeServiceFactory serviceFactory;

    @Before
    public void setUp() throws Exception {
        this.serviceFactory = new FakeServiceFactory();
        ReadOnlyTransaction tx = (ReadOnlyTransaction)Mockito.mock(ReadOnlyTransaction.class);
        Mockito.when((Object)this.serviceFactory.mockDatabaseClient().readOnlyTransaction()).thenReturn((Object)tx);
        this.preparePkMetadata(tx, Arrays.asList(SpannerIOWriteTest.pkMetadata("tEsT", "key", "ASC")));
        this.prepareColumnMetadata(tx, Arrays.asList(SpannerIOWriteTest.columnMetadata("tEsT", "key", "INT64", 7L)));
    }

    private static Struct columnMetadata(String tableName, String columnName, String type, long cellsMutated) {
        return Struct.newBuilder().add("table_name", Value.string((String)tableName)).add("column_name", Value.string((String)columnName)).add("spanner_type", Value.string((String)type)).add("cells_mutated", Value.int64((long)cellsMutated)).build();
    }

    private static Struct pkMetadata(String tableName, String columnName, String ordering) {
        return Struct.newBuilder().add("table_name", Value.string((String)tableName)).add("column_name", Value.string((String)columnName)).add("column_ordering", Value.string((String)ordering)).build();
    }

    private void prepareColumnMetadata(ReadOnlyTransaction tx, List<Struct> rows) {
        Type type = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"table_name", (Type)Type.string()), Type.StructField.of((String)"column_name", (Type)Type.string()), Type.StructField.of((String)"spanner_type", (Type)Type.string()), Type.StructField.of((String)"cells_mutated", (Type)Type.int64())});
        Mockito.when((Object)tx.executeQuery((Statement)Mockito.argThat((Matcher)new ArgumentMatcher<Statement>(){

            public boolean matches(Object argument) {
                if (!(argument instanceof Statement)) {
                    return false;
                }
                Statement st = (Statement)argument;
                return st.getSql().contains("information_schema.columns");
            }
        }), new Options.QueryOption[0])).thenReturn((Object)ResultSets.forRows((Type)type, rows));
    }

    private void preparePkMetadata(ReadOnlyTransaction tx, List<Struct> rows) {
        Type type = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"table_name", (Type)Type.string()), Type.StructField.of((String)"column_name", (Type)Type.string()), Type.StructField.of((String)"column_ordering", (Type)Type.string())});
        Mockito.when((Object)tx.executeQuery((Statement)Mockito.argThat((Matcher)new ArgumentMatcher<Statement>(){

            public boolean matches(Object argument) {
                if (!(argument instanceof Statement)) {
                    return false;
                }
                Statement st = (Statement)argument;
                return st.getSql().contains("information_schema.index_columns");
            }
        }), new Options.QueryOption[0])).thenReturn((Object)ResultSets.forRows((Type)type, rows));
    }

    @Test
    public void emptyTransform() throws Exception {
        SpannerIO.Write write = SpannerIO.write();
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("requires instance id to be set with");
        write.expand(null);
    }

    @Test
    public void emptyInstanceId() throws Exception {
        SpannerIO.Write write = SpannerIO.write().withDatabaseId("123");
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("requires instance id to be set with");
        write.expand(null);
    }

    @Test
    public void emptyDatabaseId() throws Exception {
        SpannerIO.Write write = SpannerIO.write().withInstanceId("123");
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("requires database id to be set with");
        write.expand(null);
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void singleMutationPipeline() throws Exception {
        Mutation mutation = SpannerIOWriteTest.m(2L);
        PCollection mutations = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)mutation, (Object[])new Mutation[0]));
        mutations.apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory));
        this.pipeline.run();
        this.verifyBatches(SpannerIOWriteTest.batch(SpannerIOWriteTest.m(2L)));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void singleMutationGroupPipeline() throws Exception {
        PCollection mutations = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), SpannerIOWriteTest.m(2L), SpannerIOWriteTest.m(3L)), (Object[])new MutationGroup[0]));
        mutations.apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory).grouped());
        this.pipeline.run();
        this.verifyBatches(SpannerIOWriteTest.batch(SpannerIOWriteTest.m(1L), SpannerIOWriteTest.m(2L), SpannerIOWriteTest.m(3L)));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void batching() throws Exception {
        MutationGroup one = SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]);
        MutationGroup two = SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), new Mutation[0]);
        PCollection mutations = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)one, (Object[])new MutationGroup[]{two}));
        mutations.apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory).withBatchSizeBytes(1000000000L).withSampler((PTransform)SpannerIOWriteTest.fakeSampler(SpannerIOWriteTest.m(1000L))).grouped());
        this.pipeline.run();
        this.verifyBatches(SpannerIOWriteTest.batch(SpannerIOWriteTest.m(1L), SpannerIOWriteTest.m(2L)));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void batchingWithDeletes() throws Exception {
        PCollection mutations = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), (Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.del(3L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.del(4L), new Mutation[0])}));
        mutations.apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory).withBatchSizeBytes(1000000000L).withSampler((PTransform)SpannerIOWriteTest.fakeSampler(SpannerIOWriteTest.m(1000L))).grouped());
        this.pipeline.run();
        this.verifyBatches(SpannerIOWriteTest.batch(SpannerIOWriteTest.m(1L), SpannerIOWriteTest.m(2L), SpannerIOWriteTest.del(3L), SpannerIOWriteTest.del(4L)));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void noBatchingRangeDelete() throws Exception {
        Mutation all = Mutation.delete((String)"test", (KeySet)KeySet.all());
        Mutation prefix = Mutation.delete((String)"test", (KeySet)KeySet.prefixRange((Key)Key.of((Object[])new Object[]{1L})));
        Mutation range = Mutation.delete((String)"test", (KeySet)KeySet.range((KeyRange)KeyRange.openOpen((Key)Key.of((Object[])new Object[]{1L}), (Key)Key.newBuilder().build())));
        PCollection mutations = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), (Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.del(5L, 6L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.delRange(50L, 55L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.delRange(11L, 20L), new Mutation[0]), SpannerIOWriteTest.g(all, new Mutation[0]), SpannerIOWriteTest.g(prefix, new Mutation[0]), SpannerIOWriteTest.g(range, new Mutation[0])}));
        mutations.apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory).withBatchSizeBytes(1000000000L).withSampler((PTransform)SpannerIOWriteTest.fakeSampler(SpannerIOWriteTest.m(1000L))).grouped());
        this.pipeline.run();
        this.verifyBatches(SpannerIOWriteTest.batch(SpannerIOWriteTest.m(1L), SpannerIOWriteTest.m(2L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.del(5L, 6L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.delRange(11L, 20L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.delRange(50L, 55L)), SpannerIOWriteTest.batch(all), SpannerIOWriteTest.batch(prefix), SpannerIOWriteTest.batch(range));
    }

    private void verifyBatches(Iterable<Mutation> ... batches) {
        for (Iterable<Mutation> b : batches) {
            ((DatabaseClient)Mockito.verify((Object)this.serviceFactory.mockDatabaseClient(), (VerificationMode)Mockito.times((int)1))).writeAtLeastOnce(SpannerIOWriteTest.mutationsInNoOrder(b));
        }
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void sizeBatchingGroups() throws Exception {
        long batchSize = MutationSizeEstimator.sizeOf((MutationGroup)SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0])) * 2L;
        PCollection mutations = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), (Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(3L), new Mutation[0])}));
        mutations.apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory).withBatchSizeBytes(batchSize).withSampler((PTransform)SpannerIOWriteTest.fakeSampler(SpannerIOWriteTest.m(1000L))).grouped());
        this.pipeline.run();
        ((DatabaseClient)Mockito.verify((Object)this.serviceFactory.mockDatabaseClient(), (VerificationMode)Mockito.times((int)1))).writeAtLeastOnce(this.iterableOfSize(2));
        ((DatabaseClient)Mockito.verify((Object)this.serviceFactory.mockDatabaseClient(), (VerificationMode)Mockito.times((int)1))).writeAtLeastOnce(this.iterableOfSize(1));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void cellBatchingGroups() throws Exception {
        long maxNumMutations = 14L;
        PCollection mutations = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), (Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(3L), new Mutation[0])}));
        mutations.apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory).withMaxNumMutations(maxNumMutations).withBatchSizeBytes(Integer.MAX_VALUE).withSampler((PTransform)SpannerIOWriteTest.fakeSampler(SpannerIOWriteTest.m(1000L))).grouped());
        this.pipeline.run();
        ((DatabaseClient)Mockito.verify((Object)this.serviceFactory.mockDatabaseClient(), (VerificationMode)Mockito.times((int)1))).writeAtLeastOnce(this.iterableOfSize(2));
        ((DatabaseClient)Mockito.verify((Object)this.serviceFactory.mockDatabaseClient(), (VerificationMode)Mockito.times((int)1))).writeAtLeastOnce(this.iterableOfSize(1));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void noBatching() throws Exception {
        PCollection mutations = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), (Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), new Mutation[0])}));
        mutations.apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory).withBatchSizeBytes(1L).withSampler((PTransform)SpannerIOWriteTest.fakeSampler(SpannerIOWriteTest.m(1000L))).grouped());
        this.pipeline.run();
        this.verifyBatches(SpannerIOWriteTest.batch(SpannerIOWriteTest.m(1L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(2L)));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void batchingPlusSampling() throws Exception {
        PCollection mutations = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), (Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(3L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(4L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(5L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(6L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(7L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(8L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(9L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(10L), new Mutation[0])}));
        mutations.apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory).withBatchSizeBytes(1000000000L).withSampler((PTransform)SpannerIOWriteTest.fakeSampler(SpannerIOWriteTest.m(2L), SpannerIOWriteTest.m(5L), SpannerIOWriteTest.m(10L))).grouped());
        this.pipeline.run();
        this.verifyBatches(SpannerIOWriteTest.batch(SpannerIOWriteTest.m(1L), SpannerIOWriteTest.m(2L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(3L), SpannerIOWriteTest.m(4L), SpannerIOWriteTest.m(5L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(6L), SpannerIOWriteTest.m(7L), SpannerIOWriteTest.m(8L), SpannerIOWriteTest.m(9L), SpannerIOWriteTest.m(10L)));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void reportFailures() throws Exception {
        PCollection mutations = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), (Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(3L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(4L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(5L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(6L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(7L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(8L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(9L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(10L), new Mutation[0])}));
        Mockito.when((Object)this.serviceFactory.mockDatabaseClient().writeAtLeastOnce((Iterable)Matchers.any())).thenAnswer(invocationOnMock -> {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ALREADY_EXISTS, (String)"oops");
        });
        SpannerWriteResult result = (SpannerWriteResult)mutations.apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory).withBatchSizeBytes(1000000000L).withFailureMode(SpannerIO.FailureMode.REPORT_FAILURES).withSampler((PTransform)SpannerIOWriteTest.fakeSampler(SpannerIOWriteTest.m(2L), SpannerIOWriteTest.m(5L), SpannerIOWriteTest.m(10L))).grouped());
        PAssert.that((PCollection)result.getFailedMutations()).satisfies((SerializableFunction & Serializable)m -> {
            Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)m));
            return null;
        });
        this.pipeline.run();
        this.verifyBatches(SpannerIOWriteTest.batch(SpannerIOWriteTest.m(1L), SpannerIOWriteTest.m(2L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(3L), SpannerIOWriteTest.m(4L), SpannerIOWriteTest.m(5L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(6L), SpannerIOWriteTest.m(7L), SpannerIOWriteTest.m(8L), SpannerIOWriteTest.m(9L), SpannerIOWriteTest.m(10L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(1L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(2L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(3L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(4L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(5L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(6L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(7L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(8L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(9L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(10L)));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void noBatchingPlusSampling() throws Exception {
        PCollection mutations = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)SpannerIOWriteTest.g(SpannerIOWriteTest.m(1L), new Mutation[0]), (Object[])new MutationGroup[]{SpannerIOWriteTest.g(SpannerIOWriteTest.m(2L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(3L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(4L), new Mutation[0]), SpannerIOWriteTest.g(SpannerIOWriteTest.m(5L), new Mutation[0])}));
        mutations.apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory).withBatchSizeBytes(1L).withSampler((PTransform)SpannerIOWriteTest.fakeSampler(SpannerIOWriteTest.m(2L))).grouped());
        this.pipeline.run();
        this.verifyBatches(SpannerIOWriteTest.batch(SpannerIOWriteTest.m(1L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(2L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(3L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(4L)), SpannerIOWriteTest.batch(SpannerIOWriteTest.m(5L)));
    }

    @Test
    public void displayData() throws Exception {
        SpannerIO.Write write = SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withBatchSizeBytes(123L);
        DisplayData data = DisplayData.from((HasDisplayData)write);
        Assert.assertThat((Object)data.items(), (Matcher)org.hamcrest.Matchers.hasSize((int)4));
        Assert.assertThat((Object)data, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"projectId", (String)"test-project"));
        Assert.assertThat((Object)data, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"instanceId", (String)"test-instance"));
        Assert.assertThat((Object)data, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"databaseId", (String)"test-database"));
        Assert.assertThat((Object)data, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"batchSizeBytes", (long)123L));
    }

    private static MutationGroup g(Mutation m, Mutation ... other) {
        return MutationGroup.create((Mutation)m, (Mutation[])other);
    }

    private static Mutation m(Long key) {
        return ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(key)).build();
    }

    private static Iterable<Mutation> batch(Mutation ... m) {
        return Arrays.asList(m);
    }

    private static Mutation del(Long ... keys) {
        KeySet.Builder builder = KeySet.newBuilder();
        for (Long key : keys) {
            builder.addKey(Key.of((Object[])new Object[]{key}));
        }
        return Mutation.delete((String)"test", (KeySet)builder.build());
    }

    private static Mutation delRange(Long start, Long end) {
        return Mutation.delete((String)"test", (KeySet)KeySet.range((KeyRange)KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{start}), (Key)Key.of((Object[])new Object[]{end}))));
    }

    private static Iterable<Mutation> mutationsInNoOrder(Iterable<Mutation> expected) {
        final ImmutableSet mutations = ImmutableSet.copyOf(expected);
        return (Iterable)Mockito.argThat((Matcher)new ArgumentMatcher<Iterable<Mutation>>(){

            public boolean matches(Object argument) {
                if (!(argument instanceof Iterable)) {
                    return false;
                }
                ImmutableSet actual = ImmutableSet.copyOf((Iterable)((Iterable)argument));
                return actual.equals((Object)mutations);
            }

            public void describeTo(Description description) {
                description.appendText("Iterable must match ").appendValue((Object)mutations);
            }
        });
    }

    private Iterable<Mutation> iterableOfSize(final int size) {
        return (Iterable)Mockito.argThat((Matcher)new ArgumentMatcher<Iterable<Mutation>>(){

            public boolean matches(Object argument) {
                return argument instanceof Iterable && Iterables.size((Iterable)((Iterable)argument)) == size;
            }

            public void describeTo(Description description) {
                description.appendText("The size of the iterable must equal ").appendValue((Object)size);
            }
        });
    }

    private static FakeSampler fakeSampler(Mutation ... mutations) {
        SpannerSchema.Builder schema = SpannerSchema.builder();
        schema.addColumn("test", "key", "INT64", 7L);
        schema.addKeyPart("test", "key", false);
        return new FakeSampler(schema.build(), Arrays.asList(mutations));
    }

    private static class FakeSampler
    extends PTransform<PCollection<KV<String, byte[]>>, PCollection<KV<String, List<byte[]>>>> {
        private final SpannerSchema schema;
        private final List<Mutation> mutations;

        private FakeSampler(SpannerSchema schema, List<Mutation> mutations) {
            this.schema = schema;
            this.mutations = mutations;
        }

        public PCollection<KV<String, List<byte[]>>> expand(PCollection<KV<String, byte[]>> input) {
            MutationGroupEncoder coder = new MutationGroupEncoder(this.schema);
            HashMap<String, List> map = new HashMap<String, List>();
            for (Mutation m : this.mutations) {
                String table = m.getTable().toLowerCase();
                List list = map.computeIfAbsent(table, k -> new ArrayList());
                list.add(coder.encodeKey(m));
            }
            ArrayList<KV> result = new ArrayList<KV>();
            for (Map.Entry entry : map.entrySet()) {
                ((List)entry.getValue()).sort(SpannerIO.SerializableBytesComparator.INSTANCE);
                result.add(KV.of((Object)((String)entry.getKey()), (Object)((List)entry.getValue())));
            }
            return (PCollection)input.getPipeline().apply((PTransform)Create.of(result));
        }
    }
}

