/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Mutation;
import java.util.Arrays;
import org.apache.beam.sdk.io.gcp.spanner.MutationGroup;
import org.apache.beam.sdk.io.gcp.spanner.MutationSizeEstimator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class MutationSizeEstimatorTest {
    @Test
    public void primitives() throws Exception {
        Mutation int64 = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").to(1L)).build();
        Mutation float64 = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").to(2.9)).build();
        Mutation bool = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").to(false)).build();
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)int64), (Matcher)Matchers.is((Object)8L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)float64), (Matcher)Matchers.is((Object)8L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)bool), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void primitiveArrays() throws Exception {
        Mutation int64 = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").toInt64Array(new long[]{1L, 2L, 3L})).build();
        Mutation float64 = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").toFloat64Array(new double[]{1.0, 2.0})).build();
        Mutation bool = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").toBoolArray(new boolean[]{true, true, false, true})).build();
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)int64), (Matcher)Matchers.is((Object)24L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)float64), (Matcher)Matchers.is((Object)16L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)bool), (Matcher)Matchers.is((Object)4L));
    }

    @Test
    public void nullPrimitiveArrays() throws Exception {
        Mutation int64 = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").toInt64Array((long[])null)).build();
        Mutation float64 = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").toFloat64Array((double[])null)).build();
        Mutation bool = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").toBoolArray((boolean[])null)).build();
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)int64), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)float64), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)bool), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void strings() throws Exception {
        Mutation emptyString = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").to("")).build();
        Mutation nullString = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").to((String)null)).build();
        Mutation sampleString = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").to("abc")).build();
        Mutation sampleArray = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").toStringArray(Arrays.asList("one", "two", null))).build();
        Mutation nullArray = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").toStringArray(null)).build();
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)emptyString), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)nullString), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)sampleString), (Matcher)Matchers.is((Object)3L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)sampleArray), (Matcher)Matchers.is((Object)6L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)nullArray), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void bytes() throws Exception {
        Mutation empty = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").to(ByteArray.fromBase64((String)""))).build();
        Mutation nullValue = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").to((ByteArray)null)).build();
        Mutation sample = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").to(ByteArray.fromBase64((String)"abcdabcd"))).build();
        Mutation nullArray = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").toBytesArray(null)).build();
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)empty), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)nullValue), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)sample), (Matcher)Matchers.is((Object)6L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)nullArray), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void dates() throws Exception {
        Mutation timestamp = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").to(Timestamp.now())).build();
        Mutation nullTimestamp = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").to((Timestamp)null)).build();
        Mutation date = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").to(Date.fromYearMonthDay((int)2017, (int)10, (int)10))).build();
        Mutation nullDate = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").to((Date)null)).build();
        Mutation timestampArray = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").toTimestampArray(Arrays.asList(Timestamp.now(), null))).build();
        Mutation dateArray = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").toDateArray(Arrays.asList(null, Date.fromYearMonthDay((int)2017, (int)1, (int)1), null, Date.fromYearMonthDay((int)2017, (int)1, (int)2)))).build();
        Mutation nullTimestampArray = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").toTimestampArray(null)).build();
        Mutation nullDateArray = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").toDateArray(null)).build();
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)timestamp), (Matcher)Matchers.is((Object)12L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)date), (Matcher)Matchers.is((Object)12L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)nullTimestamp), (Matcher)Matchers.is((Object)12L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)nullDate), (Matcher)Matchers.is((Object)12L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)timestampArray), (Matcher)Matchers.is((Object)24L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)dateArray), (Matcher)Matchers.is((Object)48L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)nullTimestampArray), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((Mutation)nullDateArray), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void group() throws Exception {
        Mutation int64 = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").to(1L)).build();
        Mutation float64 = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").to(2.9)).build();
        Mutation bool = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("one").to(false)).build();
        MutationGroup group = MutationGroup.create((Mutation)int64, (Mutation[])new Mutation[]{float64, bool});
        Assert.assertThat((Object)MutationSizeEstimator.sizeOf((MutationGroup)group), (Matcher)Matchers.is((Object)17L));
    }
}

