/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeyRange;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.UnsignedBytes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.io.gcp.spanner.MutationGroup;
import org.apache.beam.sdk.io.gcp.spanner.MutationGroupEncoder;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class MutationGroupEncoderTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private SpannerSchema allTypesSchema;

    @Before
    public void setUp() throws Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addColumn("test", "intkey", "INT64");
        builder.addKeyPart("test", "intkey", false);
        builder.addColumn("test", "bool", "BOOL");
        builder.addColumn("test", "int64", "INT64");
        builder.addColumn("test", "float64", "FLOAT64");
        builder.addColumn("test", "string", "STRING");
        builder.addColumn("test", "bytes", "BYTES");
        builder.addColumn("test", "timestamp", "TIMESTAMP");
        builder.addColumn("test", "date", "DATE");
        builder.addColumn("test", "nullbool", "BOOL");
        builder.addColumn("test", "nullint64", "INT64");
        builder.addColumn("test", "nullfloat64", "FLOAT64");
        builder.addColumn("test", "nullstring", "STRING");
        builder.addColumn("test", "nullbytes", "BYTES");
        builder.addColumn("test", "nulltimestamp", "TIMESTAMP");
        builder.addColumn("test", "nulldate", "DATE");
        builder.addColumn("test", "arrbool", "ARRAY<BOOL>");
        builder.addColumn("test", "arrint64", "ARRAY<INT64>");
        builder.addColumn("test", "arrfloat64", "ARRAY<FLOAT64>");
        builder.addColumn("test", "arrstring", "ARRAY<STRING>");
        builder.addColumn("test", "arrbytes", "ARRAY<BYTES>");
        builder.addColumn("test", "arrtimestamp", "ARRAY<TIMESTAMP>");
        builder.addColumn("test", "arrdate", "ARRAY<DATE>");
        builder.addColumn("test", "nullarrbool", "ARRAY<BOOL>");
        builder.addColumn("test", "nullarrint64", "ARRAY<INT64>");
        builder.addColumn("test", "nullarrfloat64", "ARRAY<FLOAT64>");
        builder.addColumn("test", "nullarrstring", "ARRAY<STRING>");
        builder.addColumn("test", "nullarrbytes", "ARRAY<BYTES>");
        builder.addColumn("test", "nullarrtimestamp", "ARRAY<TIMESTAMP>");
        builder.addColumn("test", "nullarrdate", "ARRAY<DATE>");
        this.allTypesSchema = builder.build();
    }

    @Test
    public void testAllTypesSingleMutation() throws Exception {
        this.encodeAndVerify(this.g(this.appendAllTypes(Mutation.newInsertOrUpdateBuilder((String)"test")).build(), new Mutation[0]));
        this.encodeAndVerify(this.g(this.appendAllTypes(Mutation.newInsertBuilder((String)"test")).build(), new Mutation[0]));
        this.encodeAndVerify(this.g(this.appendAllTypes(Mutation.newUpdateBuilder((String)"test")).build(), new Mutation[0]));
        this.encodeAndVerify(this.g(this.appendAllTypes(Mutation.newReplaceBuilder((String)"test")).build(), new Mutation[0]));
    }

    @Test
    public void testAllTypesMultipleMutations() throws Exception {
        this.encodeAndVerify(this.g(this.appendAllTypes(Mutation.newInsertOrUpdateBuilder((String)"test")).build(), this.appendAllTypes(Mutation.newInsertBuilder((String)"test")).build(), this.appendAllTypes(Mutation.newUpdateBuilder((String)"test")).build(), this.appendAllTypes(Mutation.newReplaceBuilder((String)"test")).build(), Mutation.delete((String)"test", (KeySet)KeySet.range((KeyRange)KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{1L}), (Key)Key.of((Object[])new Object[]{2L}))))));
    }

    @Test
    public void testUnknownColumn() throws Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addKeyPart("test", "bool_field", false);
        builder.addColumn("test", "bool_field", "BOOL");
        SpannerSchema schema = builder.build();
        Mutation mutation = ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"test").set("unknown").to(true)).build();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Columns [unknown] were not defined in table test");
        MutationGroupEncoderTest.encodeAndVerify(this.g(mutation, new Mutation[0]), schema);
    }

    @Test
    public void testUnknownTable() throws Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addKeyPart("test", "bool_field", false);
        builder.addColumn("test", "bool_field", "BOOL");
        SpannerSchema schema = builder.build();
        Mutation mutation = ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"unknown").set("bool_field").to(true)).build();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Unknown table 'unknown'");
        MutationGroupEncoderTest.encodeAndVerify(this.g(mutation, new Mutation[0]), schema);
    }

    @Test
    public void testMutationCaseInsensitive() throws Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addKeyPart("test", "bool_field", false);
        builder.addColumn("test", "bool_field", "BOOL");
        SpannerSchema schema = builder.build();
        Mutation mutation = ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEsT").set("BoOL_FiELd").to(true)).build();
        MutationGroupEncoderTest.encodeAndVerify(this.g(mutation, new Mutation[0]), schema);
    }

    @Test
    public void testDeleteCaseInsensitive() throws Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addKeyPart("test", "bool_field", false);
        builder.addColumn("test", "int_field", "INT64");
        SpannerSchema schema = builder.build();
        Mutation mutation = Mutation.delete((String)"TeSt", (Key)Key.of((Object[])new Object[]{1L}));
        MutationGroupEncoderTest.encodeAndVerify(this.g(mutation, new Mutation[0]), schema);
    }

    @Test
    public void testDeletes() throws Exception {
        this.encodeAndVerify(this.g(Mutation.delete((String)"test", (Key)Key.of((Object[])new Object[]{1L})), new Mutation[0]));
        this.encodeAndVerify(this.g(Mutation.delete((String)"test", (Key)Key.of((Object[])new Object[]{null})), new Mutation[0]));
        KeySet allTypes = KeySet.newBuilder().addKey(Key.of((Object[])new Object[]{1L})).addKey(Key.of((Object[])new Object[]{null})).addKey(Key.of((Object[])new Object[]{1.2})).addKey(Key.of((Object[])new Object[]{null})).addKey(Key.of((Object[])new Object[]{"one"})).addKey(Key.of((Object[])new Object[]{null})).addKey(Key.of((Object[])new Object[]{ByteArray.fromBase64((String)"abcd")})).addKey(Key.of((Object[])new Object[]{null})).addKey(Key.of((Object[])new Object[]{Timestamp.now()})).addKey(Key.of((Object[])new Object[]{null})).addKey(Key.of((Object[])new Object[]{Date.fromYearMonthDay((int)2012, (int)1, (int)1)})).addKey(Key.of((Object[])new Object[]{null})).build();
        this.encodeAndVerify(this.g(Mutation.delete((String)"test", (KeySet)allTypes), new Mutation[0]));
        this.encodeAndVerify(this.g(Mutation.delete((String)"test", (KeySet)KeySet.range((KeyRange)KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{1L}), (Key)Key.of((Object[])new Object[]{2L})))), new Mutation[0]));
    }

    private Mutation.WriteBuilder appendAllTypes(Mutation.WriteBuilder builder) {
        Timestamp ts = Timestamp.now();
        Date date = Date.fromYearMonthDay((int)2017, (int)1, (int)1);
        return (Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)builder.set("bool").to(true)).set("int64").to(1L)).set("float64").to(1.0)).set("string").to("my string")).set("bytes").to(ByteArray.fromBase64((String)"abcdedf"))).set("timestamp").to(ts)).set("date").to(date)).set("arrbool").toBoolArray(Arrays.asList(true, false, null, true, null, false))).set("arrint64").toInt64Array(Arrays.asList(10L, -12L, null, null, 100000L))).set("arrfloat64").toFloat64Array(Arrays.asList(10.0, -12.23, null, null, 100000.33231))).set("arrstring").toStringArray(Arrays.asList("one", "two", null, null, "three"))).set("arrbytes").toBytesArray(Arrays.asList(ByteArray.fromBase64((String)"abcs"), null))).set("arrtimestamp").toTimestampArray(Arrays.asList(Timestamp.MIN_VALUE, null, ts))).set("arrdate").toDateArray(Arrays.asList(null, date))).set("nullbool").to((Boolean)null)).set("nullint64").to((Long)null)).set("nullfloat64").to((Double)null)).set("nullstring").to((String)null)).set("nullbytes").to((ByteArray)null)).set("nulltimestamp").to((Timestamp)null)).set("nulldate").to((Date)null)).set("nullarrbool").toBoolArray((Iterable)null)).set("nullarrint64").toInt64Array((Iterable)null)).set("nullarrfloat64").toFloat64Array((Iterable)null)).set("nullarrstring").toStringArray(null)).set("nullarrbytes").toBytesArray(null)).set("nullarrtimestamp").toTimestampArray(null)).set("nullarrdate").toDateArray(null);
    }

    @Test
    public void int64Keys() throws Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addColumn("test", "key", "INT64");
        builder.addKeyPart("test", "key", false);
        builder.addColumn("test", "keydesc", "INT64");
        builder.addKeyPart("test", "keydesc", true);
        SpannerSchema schema = builder.build();
        List<Mutation> mutations = Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(1L)).set("keydesc").to(0L)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(2L)).set("keydesc").to((Long)null)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(2L)).set("keydesc").to(10L)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(2L)).set("keydesc").to(9L)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to((Long)null)).set("keydesc").to(0L)).build());
        List<Key> keys = Arrays.asList(Key.of((Object[])new Object[]{1L, 0L}), Key.of((Object[])new Object[]{2L, null}), Key.of((Object[])new Object[]{2L, 10L}), Key.of((Object[])new Object[]{2L, 9L}), Key.of((Object[])new Object[]{2L, 0L}));
        this.verifyEncodedOrdering(schema, mutations);
        this.verifyEncodedOrdering(schema, "test", keys);
    }

    @Test
    public void float64Keys() throws Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addColumn("test", "key", "FLOAT64");
        builder.addKeyPart("test", "key", false);
        builder.addColumn("test", "keydesc", "FLOAT64");
        builder.addKeyPart("test", "keydesc", true);
        SpannerSchema schema = builder.build();
        List<Mutation> mutations = Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(1.0)).set("keydesc").to(0.0)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(2.0)).set("keydesc").to((Long)null)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(2.0)).set("keydesc").to(10.0)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(2.0)).set("keydesc").to(9.0)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(2.0)).set("keydesc").to(0.0)).build());
        List<Key> keys = Arrays.asList(Key.of((Object[])new Object[]{1.0, 0.0}), Key.of((Object[])new Object[]{2.0, null}), Key.of((Object[])new Object[]{2.0, 10.0}), Key.of((Object[])new Object[]{2.0, 9.0}), Key.of((Object[])new Object[]{2.0, 0.0}));
        this.verifyEncodedOrdering(schema, mutations);
        this.verifyEncodedOrdering(schema, "test", keys);
    }

    @Test
    public void stringKeys() throws Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addColumn("test", "key", "STRING");
        builder.addKeyPart("test", "key", false);
        builder.addColumn("test", "keydesc", "STRING");
        builder.addKeyPart("test", "keydesc", true);
        SpannerSchema schema = builder.build();
        List<Mutation> mutations = Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to("a")).set("keydesc").to("bc")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to("b")).set("keydesc").to((String)null)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to("b")).set("keydesc").to("z")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to("b")).set("keydesc").to("y")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to("b")).set("keydesc").to("a")).build());
        List<Key> keys = Arrays.asList(Key.of((Object[])new Object[]{"a", "bc"}), Key.of((Object[])new Object[]{"b", null}), Key.of((Object[])new Object[]{"b", "z"}), Key.of((Object[])new Object[]{"b", "y"}), Key.of((Object[])new Object[]{"b", "a"}));
        this.verifyEncodedOrdering(schema, mutations);
        this.verifyEncodedOrdering(schema, "test", keys);
    }

    @Test
    public void bytesKeys() throws Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addColumn("test", "key", "BYTES");
        builder.addKeyPart("test", "key", false);
        builder.addColumn("test", "keydesc", "BYTES");
        builder.addKeyPart("test", "keydesc", true);
        SpannerSchema schema = builder.build();
        List<Mutation> mutations = Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(ByteArray.fromBase64((String)"abc"))).set("keydesc").to(ByteArray.fromBase64((String)"zzz"))).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(ByteArray.fromBase64((String)"xxx"))).set("keydesc").to((ByteArray)null)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(ByteArray.fromBase64((String)"xxx"))).set("keydesc").to(ByteArray.fromBase64((String)"zzzz"))).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(ByteArray.fromBase64((String)"xxx"))).set("keydesc").to(ByteArray.fromBase64((String)"ssss"))).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(ByteArray.fromBase64((String)"xxx"))).set("keydesc").to(ByteArray.fromBase64((String)"aaa"))).build());
        List<Key> keys = Arrays.asList(Key.of((Object[])new Object[]{ByteArray.fromBase64((String)"abc"), ByteArray.fromBase64((String)"zzz")}), Key.of((Object[])new Object[]{ByteArray.fromBase64((String)"xxx"), null}), Key.of((Object[])new Object[]{ByteArray.fromBase64((String)"xxx"), ByteArray.fromBase64((String)"zzz")}), Key.of((Object[])new Object[]{ByteArray.fromBase64((String)"xxx"), ByteArray.fromBase64((String)"sss")}), Key.of((Object[])new Object[]{ByteArray.fromBase64((String)"xxx"), ByteArray.fromBase64((String)"aaa")}));
        this.verifyEncodedOrdering(schema, mutations);
        this.verifyEncodedOrdering(schema, "test", keys);
    }

    @Test
    public void dateKeys() throws Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addColumn("test", "key", "DATE");
        builder.addKeyPart("test", "key", false);
        builder.addColumn("test", "keydesc", "DATE");
        builder.addKeyPart("test", "keydesc", true);
        SpannerSchema schema = builder.build();
        List<Mutation> mutations = Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Date.fromYearMonthDay((int)2012, (int)10, (int)10))).set("keydesc").to(Date.fromYearMonthDay((int)2000, (int)10, (int)10))).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Date.fromYearMonthDay((int)2020, (int)10, (int)10))).set("keydesc").to((Date)null)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Date.fromYearMonthDay((int)2020, (int)10, (int)10))).set("keydesc").to(Date.fromYearMonthDay((int)2050, (int)10, (int)10))).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Date.fromYearMonthDay((int)2020, (int)10, (int)10))).set("keydesc").to(Date.fromYearMonthDay((int)2000, (int)10, (int)10))).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Date.fromYearMonthDay((int)2020, (int)10, (int)10))).set("keydesc").to(Date.fromYearMonthDay((int)1900, (int)10, (int)10))).build());
        List<Key> keys = Arrays.asList(Key.of((Object[])new Object[]{Date.fromYearMonthDay((int)2012, (int)10, (int)10), ByteArray.fromBase64((String)"zzz")}), Key.of((Object[])new Object[]{Date.fromYearMonthDay((int)2015, (int)10, (int)10), null}), Key.of((Object[])new Object[]{Date.fromYearMonthDay((int)2015, (int)10, (int)10), Date.fromYearMonthDay((int)2050, (int)10, (int)10)}), Key.of((Object[])new Object[]{Date.fromYearMonthDay((int)2015, (int)10, (int)10), Date.fromYearMonthDay((int)2000, (int)10, (int)10)}), Key.of((Object[])new Object[]{Date.fromYearMonthDay((int)2015, (int)10, (int)10), Date.fromYearMonthDay((int)1900, (int)10, (int)10)}));
        this.verifyEncodedOrdering(schema, mutations);
        this.verifyEncodedOrdering(schema, "test", keys);
    }

    @Test
    public void timestampKeys() throws Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addColumn("test", "key", "TIMESTAMP");
        builder.addKeyPart("test", "key", false);
        builder.addColumn("test", "keydesc", "TIMESTAMP");
        builder.addKeyPart("test", "keydesc", true);
        SpannerSchema schema = builder.build();
        List<Mutation> mutations = Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Timestamp.ofTimeMicroseconds((long)10000L))).set("keydesc").to(Timestamp.ofTimeMicroseconds((long)50000L))).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Timestamp.ofTimeMicroseconds((long)20000L))).set("keydesc").to((Timestamp)null)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Timestamp.ofTimeMicroseconds((long)20000L))).set("keydesc").to(Timestamp.ofTimeMicroseconds((long)90000L))).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Timestamp.ofTimeMicroseconds((long)20000L))).set("keydesc").to(Timestamp.ofTimeMicroseconds((long)50000L))).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("key").to(Timestamp.ofTimeMicroseconds((long)20000L))).set("keydesc").to(Timestamp.ofTimeMicroseconds((long)10000L))).build());
        List<Key> keys = Arrays.asList(Key.of((Object[])new Object[]{Timestamp.ofTimeMicroseconds((long)10000L), ByteArray.fromBase64((String)"zzz")}), Key.of((Object[])new Object[]{Timestamp.ofTimeMicroseconds((long)20000L), null}), Key.of((Object[])new Object[]{Timestamp.ofTimeMicroseconds((long)20000L), Timestamp.ofTimeMicroseconds((long)90000L)}), Key.of((Object[])new Object[]{Timestamp.ofTimeMicroseconds((long)20000L), Timestamp.ofTimeMicroseconds((long)50000L)}), Key.of((Object[])new Object[]{Timestamp.ofTimeMicroseconds((long)20000L), Timestamp.ofTimeMicroseconds((long)10000L)}));
        this.verifyEncodedOrdering(schema, mutations);
        this.verifyEncodedOrdering(schema, "test", keys);
    }

    @Test
    public void boolKeys() throws Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        builder.addColumn("test", "boolkey", "BOOL");
        builder.addKeyPart("test", "boolkey", false);
        builder.addColumn("test", "boolkeydesc", "BOOL");
        builder.addKeyPart("test", "boolkeydesc", true);
        SpannerSchema schema = builder.build();
        List<Mutation> mutations = Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("boolkey").to(true)).set("boolkeydesc").to(false)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("boolkey").to(false)).set("boolkeydesc").to(false)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("boolkey").to(false)).set("boolkeydesc").to(true)).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"test").set("boolkey").to((Boolean)null)).set("boolkeydesc").to(false)).build());
        List<Key> keys = Arrays.asList(Key.of((Object[])new Object[]{true, ByteArray.fromBase64((String)"zzz")}), Key.of((Object[])new Object[]{false, null}), Key.of((Object[])new Object[]{false, false}), Key.of((Object[])new Object[]{false, true}), Key.of((Object[])new Object[]{null, false}));
        this.verifyEncodedOrdering(schema, mutations);
        this.verifyEncodedOrdering(schema, "test", keys);
    }

    private void verifyEncodedOrdering(SpannerSchema schema, List<Mutation> mutations) {
        MutationGroupEncoder encoder = new MutationGroupEncoder(schema);
        ArrayList<byte[]> mutationEncodings = new ArrayList<byte[]>(mutations.size());
        for (Mutation m : mutations) {
            mutationEncodings.add(encoder.encodeKey(m));
        }
        ArrayList copy = new ArrayList(mutationEncodings);
        copy.sort(UnsignedBytes.lexicographicalComparator());
        Assert.assertEquals(mutationEncodings, copy);
    }

    private void verifyEncodedOrdering(SpannerSchema schema, String table, List<Key> keys) {
        MutationGroupEncoder encoder = new MutationGroupEncoder(schema);
        ArrayList<byte[]> keyEncodings = new ArrayList<byte[]>(keys.size());
        for (Key k : keys) {
            keyEncodings.add(encoder.encodeKey(table, k));
        }
        ArrayList copy = new ArrayList(keyEncodings);
        copy.sort(UnsignedBytes.lexicographicalComparator());
        Assert.assertEquals(keyEncodings, copy);
    }

    private MutationGroup g(Mutation mutation, Mutation ... other) {
        return MutationGroup.create((Mutation)mutation, (Mutation[])other);
    }

    private void encodeAndVerify(MutationGroup expected) {
        SpannerSchema schema = this.allTypesSchema;
        MutationGroupEncoderTest.encodeAndVerify(expected, schema);
    }

    private static void encodeAndVerify(MutationGroup expected, SpannerSchema schema) {
        MutationGroupEncoder coder = new MutationGroupEncoder(schema);
        byte[] encode = coder.encode(expected);
        MutationGroup actual = coder.decode(encode);
        Assert.assertTrue((boolean)MutationGroupEncoderTest.mutationGroupsEqual(expected, actual));
    }

    private static boolean mutationGroupsEqual(MutationGroup a, MutationGroup b) {
        ImmutableList alist = ImmutableList.copyOf((Iterable)a);
        ImmutableList blist = ImmutableList.copyOf((Iterable)b);
        if (alist.size() != blist.size()) {
            return false;
        }
        for (int i = 0; i < alist.size(); ++i) {
            if (MutationGroupEncoderTest.mutationsEqual((Mutation)alist.get(i), (Mutation)blist.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean mutationsEqual(Mutation a, Mutation b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getOperation() != b.getOperation()) {
            return false;
        }
        if (!a.getTable().equalsIgnoreCase(b.getTable())) {
            return false;
        }
        if (a.getOperation() == Mutation.Op.DELETE) {
            return a.getKeySet().equals((Object)b.getKeySet());
        }
        return ImmutableSet.copyOf(MutationGroupEncoderTest.getNormalizedColumns(a)).equals((Object)ImmutableSet.copyOf(MutationGroupEncoderTest.getNormalizedColumns(b))) && ImmutableSet.copyOf((Iterable)a.getValues()).equals((Object)ImmutableSet.copyOf((Iterable)b.getValues()));
    }

    private static Iterable<String> getNormalizedColumns(Mutation a) {
        return Iterables.transform((Iterable)a.getColumns(), String::toLowerCase);
    }
}

