/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.services.pubsub.Pubsub;
import com.google.api.services.pubsub.model.PublishRequest;
import com.google.api.services.pubsub.model.PublishResponse;
import com.google.api.services.pubsub.model.PubsubMessage;
import com.google.api.services.pubsub.model.PullRequest;
import com.google.api.services.pubsub.model.PullResponse;
import com.google.api.services.pubsub.model.ReceivedMessage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubJsonClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class PubsubJsonClientTest {
    private Pubsub mockPubsub;
    private PubsubClient client;
    private static final PubsubClient.TopicPath TOPIC = PubsubClient.topicPathFromName((String)"testProject", (String)"testTopic");
    private static final PubsubClient.SubscriptionPath SUBSCRIPTION = PubsubClient.subscriptionPathFromName((String)"testProject", (String)"testSubscription");
    private static final long REQ_TIME = 1234L;
    private static final long PUB_TIME = 3456L;
    private static final long MESSAGE_TIME = 6789L;
    private static final String TIMESTAMP_ATTRIBUTE = "timestamp";
    private static final String ID_ATTRIBUTE = "id";
    private static final String MESSAGE_ID = "testMessageId";
    private static final String DATA = "testData";
    private static final String RECORD_ID = "testRecordId";
    private static final String ACK_ID = "testAckId";

    @Before
    public void setup() {
        this.mockPubsub = (Pubsub)Mockito.mock(Pubsub.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.client = new PubsubJsonClient(TIMESTAMP_ATTRIBUTE, ID_ATTRIBUTE, this.mockPubsub);
    }

    @After
    public void teardown() throws IOException {
        this.client.close();
        this.client = null;
        this.mockPubsub = null;
    }

    @Test
    public void pullOneMessage() throws IOException {
        String expectedSubscription = SUBSCRIPTION.getPath();
        PullRequest expectedRequest = new PullRequest().setReturnImmediately(Boolean.valueOf(true)).setMaxMessages(Integer.valueOf(10));
        PubsubMessage expectedPubsubMessage = new PubsubMessage().setMessageId(MESSAGE_ID).encodeData(DATA.getBytes(StandardCharsets.UTF_8)).setPublishTime(String.valueOf(3456L)).setAttributes((Map)ImmutableMap.of((Object)TIMESTAMP_ATTRIBUTE, (Object)String.valueOf(6789L), (Object)ID_ATTRIBUTE, (Object)RECORD_ID));
        ReceivedMessage expectedReceivedMessage = new ReceivedMessage().setMessage(expectedPubsubMessage).setAckId(ACK_ID);
        PullResponse expectedResponse = new PullResponse().setReceivedMessages((List)ImmutableList.of((Object)expectedReceivedMessage));
        Mockito.when((Object)this.mockPubsub.projects().subscriptions().pull(expectedSubscription, expectedRequest).execute()).thenReturn((Object)expectedResponse);
        List acutalMessages = this.client.pull(1234L, SUBSCRIPTION, 10, true);
        Assert.assertEquals((long)1L, (long)acutalMessages.size());
        PubsubClient.IncomingMessage actualMessage = (PubsubClient.IncomingMessage)acutalMessages.get(0);
        Assert.assertEquals((Object)ACK_ID, (Object)actualMessage.ackId);
        Assert.assertEquals((Object)DATA, (Object)new String(actualMessage.elementBytes, StandardCharsets.UTF_8));
        Assert.assertEquals((Object)RECORD_ID, (Object)actualMessage.recordId);
        Assert.assertEquals((long)1234L, (long)actualMessage.requestTimeMsSinceEpoch);
        Assert.assertEquals((long)6789L, (long)actualMessage.timestampMsSinceEpoch);
    }

    @Test
    public void publishOneMessage() throws IOException {
        String expectedTopic = TOPIC.getPath();
        PubsubMessage expectedPubsubMessage = new PubsubMessage().encodeData(DATA.getBytes(StandardCharsets.UTF_8)).setAttributes((Map)ImmutableMap.builder().put((Object)TIMESTAMP_ATTRIBUTE, (Object)String.valueOf(6789L)).put((Object)ID_ATTRIBUTE, (Object)RECORD_ID).put((Object)"k", (Object)"v").build());
        PublishRequest expectedRequest = new PublishRequest().setMessages((List)ImmutableList.of((Object)expectedPubsubMessage));
        PublishResponse expectedResponse = new PublishResponse().setMessageIds((List)ImmutableList.of((Object)MESSAGE_ID));
        Mockito.when((Object)this.mockPubsub.projects().topics().publish(expectedTopic, expectedRequest).execute()).thenReturn((Object)expectedResponse);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("k", "v");
        PubsubClient.OutgoingMessage actualMessage = new PubsubClient.OutgoingMessage(DATA.getBytes(StandardCharsets.UTF_8), attrs, 6789L, RECORD_ID);
        int n = this.client.publish(TOPIC, (List)ImmutableList.of((Object)actualMessage));
        Assert.assertEquals((long)1L, (long)n);
    }

    @Test
    public void publishOneMessageWithOnlyTimestampAndIdAttributes() throws IOException {
        String expectedTopic = TOPIC.getPath();
        PubsubMessage expectedPubsubMessage = new PubsubMessage().encodeData(DATA.getBytes(StandardCharsets.UTF_8)).setAttributes((Map)ImmutableMap.builder().put((Object)TIMESTAMP_ATTRIBUTE, (Object)String.valueOf(6789L)).put((Object)ID_ATTRIBUTE, (Object)RECORD_ID).build());
        PublishRequest expectedRequest = new PublishRequest().setMessages((List)ImmutableList.of((Object)expectedPubsubMessage));
        PublishResponse expectedResponse = new PublishResponse().setMessageIds((List)ImmutableList.of((Object)MESSAGE_ID));
        Mockito.when((Object)this.mockPubsub.projects().topics().publish(expectedTopic, expectedRequest).execute()).thenReturn((Object)expectedResponse);
        PubsubClient.OutgoingMessage actualMessage = new PubsubClient.OutgoingMessage(DATA.getBytes(StandardCharsets.UTF_8), (Map)ImmutableMap.of(), 6789L, RECORD_ID);
        int n = this.client.publish(TOPIC, (List)ImmutableList.of((Object)actualMessage));
        Assert.assertEquals((long)1L, (long)n);
    }

    @Test
    public void publishOneMessageWithNoTimestampOrIdAttribute() throws IOException {
        this.client = new PubsubJsonClient(null, null, this.mockPubsub);
        String expectedTopic = TOPIC.getPath();
        PubsubMessage expectedPubsubMessage = new PubsubMessage().encodeData(DATA.getBytes(StandardCharsets.UTF_8)).setAttributes((Map)ImmutableMap.builder().put((Object)"k", (Object)"v").build());
        PublishRequest expectedRequest = new PublishRequest().setMessages((List)ImmutableList.of((Object)expectedPubsubMessage));
        PublishResponse expectedResponse = new PublishResponse().setMessageIds((List)ImmutableList.of((Object)MESSAGE_ID));
        Mockito.when((Object)this.mockPubsub.projects().topics().publish(expectedTopic, expectedRequest).execute()).thenReturn((Object)expectedResponse);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("k", "v");
        PubsubClient.OutgoingMessage actualMessage = new PubsubClient.OutgoingMessage(DATA.getBytes(StandardCharsets.UTF_8), attrs, 6789L, RECORD_ID);
        int n = this.client.publish(TOPIC, (List)ImmutableList.of((Object)actualMessage));
        Assert.assertEquals((long)1L, (long)n);
    }
}

