/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.util.Set;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.UsesUnboundedPCollections;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataEvaluator;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PubsubIOTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testPubsubIOGetName() {
        Assert.assertEquals((Object)"PubsubIO.Read", (Object)PubsubIO.readStrings().fromTopic("projects/myproject/topics/mytopic").getName());
        Assert.assertEquals((Object)"PubsubIO.Write", (Object)PubsubIO.writeStrings().to("projects/myproject/topics/mytopic").getName());
    }

    @Test
    public void testTopicValidationSuccess() throws Exception {
        PubsubIO.readStrings().fromTopic("projects/my-project/topics/abc");
        PubsubIO.readStrings().fromTopic("projects/my-project/topics/ABC");
        PubsubIO.readStrings().fromTopic("projects/my-project/topics/AbC-DeF");
        PubsubIO.readStrings().fromTopic("projects/my-project/topics/AbC-1234");
        PubsubIO.readStrings().fromTopic("projects/my-project/topics/AbC-1234-_.~%+-_.~%+-_.~%+-abc");
        PubsubIO.readStrings().fromTopic("projects/my-project/topics/A-really-long-one-" + "111111111111111111111111111111111111111111111111111111111111111111111111111111111" + "111111111111111111111111111111111111111111111111111111111111111111111111111111111" + "11111111111111111111111111111111111111111111111111111111111111111111111111");
    }

    @Test
    public void testTopicValidationBadCharacter() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        PubsubIO.readStrings().fromTopic("projects/my-project/topics/abc-*-abc");
    }

    @Test
    public void testTopicValidationTooLong() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        PubsubIO.readStrings().fromTopic("projects/my-project/topics/A-really-long-one-" + "111111111111111111111111111111111111111111111111111111111111111111111111111111111" + "111111111111111111111111111111111111111111111111111111111111111111111111111111111" + "1111111111111111111111111111111111111111111111111111111111111111111111111111");
    }

    @Test
    public void testReadTopicDisplayData() {
        String topic = "projects/project/topics/topic";
        PubsubIO.Read read = PubsubIO.readStrings().fromTopic((ValueProvider)ValueProvider.StaticValueProvider.of((Object)topic)).withTimestampAttribute("myTimestamp").withIdAttribute("myId");
        DisplayData displayData = DisplayData.from((HasDisplayData)read);
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"topic", (String)topic));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"timestampAttribute", (String)"myTimestamp"));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"idAttribute", (String)"myId"));
    }

    @Test
    public void testReadSubscriptionDisplayData() {
        String subscription = "projects/project/subscriptions/subscription";
        PubsubIO.Read read = PubsubIO.readStrings().fromSubscription((ValueProvider)ValueProvider.StaticValueProvider.of((Object)subscription)).withTimestampAttribute("myTimestamp").withIdAttribute("myId");
        DisplayData displayData = DisplayData.from((HasDisplayData)read);
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"subscription", (String)subscription));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"timestampAttribute", (String)"myTimestamp"));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"idAttribute", (String)"myId"));
    }

    @Test
    public void testNullTopic() {
        String subscription = "projects/project/subscriptions/subscription";
        PubsubIO.Read read = PubsubIO.readStrings().fromSubscription((ValueProvider)ValueProvider.StaticValueProvider.of((Object)subscription));
        Assert.assertNull((Object)read.getTopicProvider());
        Assert.assertNotNull((Object)read.getSubscriptionProvider());
        Assert.assertNotNull((Object)DisplayData.from((HasDisplayData)read));
    }

    @Test
    public void testNullSubscription() {
        String topic = "projects/project/topics/topic";
        PubsubIO.Read read = PubsubIO.readStrings().fromTopic((ValueProvider)ValueProvider.StaticValueProvider.of((Object)topic));
        Assert.assertNotNull((Object)read.getTopicProvider());
        Assert.assertNull((Object)read.getSubscriptionProvider());
        Assert.assertNotNull((Object)DisplayData.from((HasDisplayData)read));
    }

    @Test
    public void testValueProviderSubscription() {
        ValueProvider.StaticValueProvider provider = ValueProvider.StaticValueProvider.of((Object)"projects/project/subscriptions/subscription");
        PubsubIO.Read pubsubRead = PubsubIO.readStrings().fromSubscription((ValueProvider)provider);
        Pipeline.create().apply((PTransform)pubsubRead);
        Assert.assertThat((Object)pubsubRead.getSubscriptionProvider(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)pubsubRead.getSubscriptionProvider().isAccessible(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((PubsubIO.PubsubSubscription)pubsubRead.getSubscriptionProvider().get()).asPath(), (Matcher)Matchers.equalTo((Object)((String)provider.get())));
    }

    @Test
    public void testRuntimeValueProviderSubscription() {
        TestPipeline pipeline = TestPipeline.create();
        ValueProvider subscription = pipeline.newProvider((Object)"projects/project/subscriptions/subscription");
        PubsubIO.Read pubsubRead = PubsubIO.readStrings().fromSubscription(subscription);
        pipeline.apply((PTransform)pubsubRead);
        Assert.assertThat((Object)pubsubRead.getSubscriptionProvider(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)pubsubRead.getSubscriptionProvider().isAccessible(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testValueProviderTopic() {
        ValueProvider.StaticValueProvider provider = ValueProvider.StaticValueProvider.of((Object)"projects/project/topics/topic");
        PubsubIO.Read pubsubRead = PubsubIO.readStrings().fromTopic((ValueProvider)provider);
        Pipeline.create().apply((PTransform)pubsubRead);
        Assert.assertThat((Object)pubsubRead.getTopicProvider(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)pubsubRead.getTopicProvider().isAccessible(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((PubsubIO.PubsubTopic)pubsubRead.getTopicProvider().get()).asPath(), (Matcher)Matchers.equalTo((Object)((String)provider.get())));
    }

    @Test
    public void testRuntimeValueProviderTopic() {
        TestPipeline pipeline = TestPipeline.create();
        ValueProvider topic = pipeline.newProvider((Object)"projects/project/topics/topic");
        PubsubIO.Read pubsubRead = PubsubIO.readStrings().fromTopic(topic);
        pipeline.apply((PTransform)pubsubRead);
        Assert.assertThat((Object)pubsubRead.getTopicProvider(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)pubsubRead.getTopicProvider().isAccessible(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesUnboundedPCollections.class})
    public void testPrimitiveReadDisplayData() {
        DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
        PubsubIO.Read baseRead = PubsubIO.readStrings();
        PubsubIO.Read read = baseRead.fromSubscription("projects/project/subscriptions/subscription");
        Set displayData = evaluator.displayDataForPrimitiveSourceTransforms((PTransform)read);
        Assert.assertThat((String)"PubsubIO.Read should include the subscription in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"subscription")));
        read = baseRead.fromTopic("projects/project/topics/topic");
        displayData = evaluator.displayDataForPrimitiveSourceTransforms((PTransform)read);
        Assert.assertThat((String)"PubsubIO.Read should include the topic in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"topic")));
    }

    @Test
    public void testWriteDisplayData() {
        String topic = "projects/project/topics/topic";
        PubsubIO.Write write = PubsubIO.writeStrings().to(topic).withTimestampAttribute("myTimestamp").withIdAttribute("myId");
        DisplayData displayData = DisplayData.from((HasDisplayData)write);
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"topic", (String)topic));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"timestampAttribute", (String)"myTimestamp"));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"idAttribute", (String)"myId"));
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testPrimitiveWriteDisplayData() {
        DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
        PubsubIO.Write write = PubsubIO.writeStrings().to("projects/project/topics/topic");
        Set displayData = evaluator.displayDataForPrimitiveTransforms((PTransform)write);
        Assert.assertThat((String)"PubsubIO.Write should include the topic in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"topic")));
    }
}

