/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.JobStatistics4;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.DatumWriter;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryAvroUtils;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.FakeBigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.FakeDatasetService;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.util.BackOffAdapter;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Transport;
import org.joda.time.Duration;

class FakeJobService
implements BigQueryServices.JobService,
Serializable {
    private static final JsonFactory JSON_FACTORY = Transport.getJsonFactory();
    private static final int GET_JOBS_TRANSITION_INTERVAL = 2;
    private final FakeDatasetService datasetService = new FakeDatasetService();
    private static com.google.common.collect.Table<String, String, JobInfo> allJobs;
    private static int numExtractJobCalls;
    private static com.google.common.collect.Table<String, String, List<ResourceId>> filesForLoadJobs;
    private static com.google.common.collect.Table<String, String, JobStatistics> dryRunQueryResults;

    FakeJobService() {
    }

    public static void setUp() {
        allJobs = HashBasedTable.create();
        numExtractJobCalls = 0;
        filesForLoadJobs = HashBasedTable.create();
        dryRunQueryResults = HashBasedTable.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLoadJob(JobReference jobRef, JobConfigurationLoad loadConfig) throws IOException {
        com.google.common.collect.Table<String, String, JobInfo> table = allJobs;
        synchronized (table) {
            this.verifyUniqueJobId(jobRef.getJobId());
            Job job = new Job();
            job.setJobReference(jobRef);
            job.setConfiguration(new JobConfiguration().setLoad(loadConfig));
            job.setKind(" bigquery#job");
            job.setStatus(new JobStatus().setState("PENDING"));
            if (loadConfig.getSourceUris().size() > 0) {
                ImmutableList.Builder sourceFiles = ImmutableList.builder();
                ImmutableList.Builder loadFiles = ImmutableList.builder();
                for (String filename : loadConfig.getSourceUris()) {
                    sourceFiles.add((Object)FileSystems.matchNewResource((String)filename, (boolean)false));
                    loadFiles.add((Object)FileSystems.matchNewResource((String)(filename + ThreadLocalRandom.current().nextInt()), (boolean)false));
                }
                FileSystems.copy((List)sourceFiles.build(), (List)loadFiles.build(), (MoveOptions[])new MoveOptions[0]);
                filesForLoadJobs.put((Object)jobRef.getProjectId(), (Object)jobRef.getJobId(), (Object)loadFiles.build());
            }
            allJobs.put((Object)jobRef.getProjectId(), (Object)jobRef.getJobId(), (Object)new JobInfo(job));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startExtractJob(JobReference jobRef, JobConfigurationExtract extractConfig) throws IOException {
        Preconditions.checkArgument((boolean)"AVRO".equals(extractConfig.getDestinationFormat()), (Object)"Only extract to AVRO is supported");
        com.google.common.collect.Table<String, String, JobInfo> table = allJobs;
        synchronized (table) {
            this.verifyUniqueJobId(jobRef.getJobId());
            ++numExtractJobCalls;
            Job job = new Job();
            job.setJobReference(jobRef);
            job.setConfiguration(new JobConfiguration().setExtract(extractConfig));
            job.setKind(" bigquery#job");
            job.setStatus(new JobStatus().setState("PENDING"));
            allJobs.put((Object)jobRef.getProjectId(), (Object)jobRef.getJobId(), (Object)new JobInfo(job));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumExtractJobCalls() {
        com.google.common.collect.Table<String, String, JobInfo> table = allJobs;
        synchronized (table) {
            return numExtractJobCalls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startQueryJob(JobReference jobRef, JobConfigurationQuery query) {
        com.google.common.collect.Table<String, String, JobInfo> table = allJobs;
        synchronized (table) {
            Job job = new Job();
            job.setJobReference(jobRef);
            job.setConfiguration(new JobConfiguration().setQuery(query));
            job.setKind(" bigquery#job");
            job.setStatus(new JobStatus().setState("PENDING"));
            allJobs.put((Object)jobRef.getProjectId(), (Object)jobRef.getJobId(), (Object)new JobInfo(job));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCopyJob(JobReference jobRef, JobConfigurationTableCopy copyConfig) throws IOException {
        com.google.common.collect.Table<String, String, JobInfo> table = allJobs;
        synchronized (table) {
            this.verifyUniqueJobId(jobRef.getJobId());
            Job job = new Job();
            job.setJobReference(jobRef);
            job.setConfiguration(new JobConfiguration().setCopy(copyConfig));
            job.setKind(" bigquery#job");
            job.setStatus(new JobStatus().setState("PENDING"));
            allJobs.put((Object)jobRef.getProjectId(), (Object)jobRef.getJobId(), (Object)new JobInfo(job));
        }
    }

    public Job pollJob(JobReference jobRef, int maxAttempts) throws InterruptedException {
        BackOff backoff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)FluentBackoff.DEFAULT.withMaxRetries(maxAttempts).withInitialBackoff(Duration.millis((long)10L)).withMaxBackoff(Duration.standardSeconds((long)1L)).backoff());
        Sleeper sleeper = Sleeper.DEFAULT;
        try {
            do {
                JobStatus status;
                Job job;
                if ((job = this.getJob(jobRef)) == null || (status = job.getStatus()) == null || !"DONE".equals(status.getState()) && !"FAILED".equals(status.getState())) continue;
                return job;
            } while (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff));
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expectDryRunQuery(String projectId, String query, JobStatistics result) {
        com.google.common.collect.Table<String, String, JobStatistics> table = dryRunQueryResults;
        synchronized (table) {
            dryRunQueryResults.put((Object)projectId, (Object)query, (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobStatistics dryRunQuery(String projectId, JobConfigurationQuery query, String location) {
        com.google.common.collect.Table<String, String, JobStatistics> table = dryRunQueryResults;
        synchronized (table) {
            JobStatistics result = (JobStatistics)dryRunQueryResults.get((Object)projectId, (Object)query.getQuery());
            if (result != null) {
                return result;
            }
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job getJob(JobReference jobRef) {
        try {
            com.google.common.collect.Table<String, String, JobInfo> table = allJobs;
            synchronized (table) {
                JobInfo job = (JobInfo)allJobs.get((Object)jobRef.getProjectId(), (Object)jobRef.getJobId());
                if (job == null) {
                    return null;
                }
                try {
                    ++job.getJobCount;
                    if (job.getJobCount == 3) {
                        job.job.getStatus().setState("RUNNING");
                    } else if (job.getJobCount == 5) {
                        job.job.setStatus(this.runJob(job.job));
                    }
                }
                catch (Exception e) {
                    job.job.getStatus().setState("FAILED").setErrorResult(new ErrorProto().setMessage(String.format("Job %s failed: %s", job.job.getConfiguration(), e.toString())));
                }
                return (Job)JSON_FACTORY.fromString(JSON_FACTORY.toString((Object)job.job), Job.class);
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    private void verifyUniqueJobId(String jobId) throws IOException {
        if (allJobs.containsColumn((Object)jobId)) {
            throw new IOException("Duplicate job id " + jobId);
        }
    }

    private JobStatus runJob(Job job) throws InterruptedException, IOException {
        if (job.getConfiguration().getLoad() != null) {
            return this.runLoadJob(job.getJobReference(), job.getConfiguration().getLoad());
        }
        if (job.getConfiguration().getCopy() != null) {
            return this.runCopyJob(job.getConfiguration().getCopy());
        }
        if (job.getConfiguration().getExtract() != null) {
            return this.runExtractJob(job, job.getConfiguration().getExtract());
        }
        if (job.getConfiguration().getQuery() != null) {
            return this.runQueryJob(job.getConfiguration().getQuery());
        }
        return new JobStatus().setState("DONE");
    }

    private boolean validateDispositions(Table table, BigQueryIO.Write.CreateDisposition createDisposition, BigQueryIO.Write.WriteDisposition writeDisposition) throws InterruptedException, IOException {
        List<TableRow> allRows;
        if (table == null) {
            if (createDisposition == BigQueryIO.Write.CreateDisposition.CREATE_NEVER) {
                return false;
            }
        } else if (writeDisposition == BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE) {
            this.datasetService.deleteTable(table.getTableReference());
        } else if (writeDisposition == BigQueryIO.Write.WriteDisposition.WRITE_EMPTY && !(allRows = this.datasetService.getAllRows(table.getTableReference().getProjectId(), table.getTableReference().getDatasetId(), table.getTableReference().getTableId())).isEmpty()) {
            return false;
        }
        return true;
    }

    private JobStatus runLoadJob(JobReference jobRef, JobConfigurationLoad load) throws InterruptedException, IOException {
        TableReference destination = load.getDestinationTable();
        TableSchema schema = load.getSchema();
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"No schema specified");
        List sourceFiles = (List)filesForLoadJobs.get((Object)jobRef.getProjectId(), (Object)jobRef.getJobId());
        BigQueryIO.Write.WriteDisposition writeDisposition = BigQueryIO.Write.WriteDisposition.valueOf((String)load.getWriteDisposition());
        BigQueryIO.Write.CreateDisposition createDisposition = BigQueryIO.Write.CreateDisposition.valueOf((String)load.getCreateDisposition());
        Preconditions.checkArgument((boolean)"NEWLINE_DELIMITED_JSON".equals(load.getSourceFormat()));
        Table existingTable = this.datasetService.getTable(destination);
        if (!this.validateDispositions(existingTable, createDisposition, writeDisposition)) {
            return new JobStatus().setState("FAILED").setErrorResult(new ErrorProto());
        }
        if (existingTable == null) {
            TableReference strippedDestination = destination.clone().setTableId(BigQueryHelpers.stripPartitionDecorator((String)destination.getTableId()));
            existingTable = new Table().setTableReference(strippedDestination).setSchema(schema);
            if (load.getTimePartitioning() != null) {
                existingTable = existingTable.setTimePartitioning(load.getTimePartitioning());
            }
            this.datasetService.createTable(existingTable);
        }
        ArrayList rows = Lists.newArrayList();
        for (ResourceId filename : sourceFiles) {
            rows.addAll(this.readRows(filename.toString()));
        }
        this.datasetService.insertAll(destination, rows, null);
        FileSystems.delete((Collection)sourceFiles, (MoveOptions[])new MoveOptions[0]);
        return new JobStatus().setState("DONE");
    }

    private JobStatus runCopyJob(JobConfigurationTableCopy copy) throws InterruptedException, IOException {
        List sources = copy.getSourceTables();
        TableReference destination = copy.getDestinationTable();
        BigQueryIO.Write.WriteDisposition writeDisposition = BigQueryIO.Write.WriteDisposition.valueOf((String)copy.getWriteDisposition());
        BigQueryIO.Write.CreateDisposition createDisposition = BigQueryIO.Write.CreateDisposition.valueOf((String)copy.getCreateDisposition());
        Table existingTable = this.datasetService.getTable(destination);
        if (!this.validateDispositions(existingTable, createDisposition, writeDisposition)) {
            return new JobStatus().setState("FAILED").setErrorResult(new ErrorProto());
        }
        TimePartitioning partitioning = null;
        TableSchema schema = null;
        boolean first = true;
        ArrayList allRows = Lists.newArrayList();
        for (TableReference source : sources) {
            Table table = (Table)Preconditions.checkNotNull((Object)this.datasetService.getTable(source));
            if (!first) {
                if (!Objects.equals(partitioning, table.getTimePartitioning())) {
                    return new JobStatus().setState("FAILED").setErrorResult(new ErrorProto());
                }
                if (!Objects.equals(schema, table.getSchema())) {
                    return new JobStatus().setState("FAILED").setErrorResult(new ErrorProto());
                }
            }
            partitioning = table.getTimePartitioning();
            schema = table.getSchema();
            first = false;
            allRows.addAll(this.datasetService.getAllRows(source.getProjectId(), source.getDatasetId(), source.getTableId()));
        }
        this.datasetService.createTable(new Table().setTableReference(destination).setSchema(schema).setTimePartitioning(partitioning));
        this.datasetService.insertAll(destination, allRows, null);
        return new JobStatus().setState("DONE");
    }

    private JobStatus runExtractJob(Job job, JobConfigurationExtract extract) throws InterruptedException, IOException {
        TableReference sourceTable = extract.getSourceTable();
        List<TableRow> rows = this.datasetService.getAllRows(sourceTable.getProjectId(), sourceTable.getDatasetId(), sourceTable.getTableId());
        TableSchema schema = this.datasetService.getTable(sourceTable).getSchema();
        ArrayList destinationFileCounts = Lists.newArrayList();
        for (String destination : extract.getDestinationUris()) {
            destinationFileCounts.add(this.writeRows(sourceTable.getTableId(), rows, schema, destination));
        }
        job.setStatistics(new JobStatistics().setExtract(new JobStatistics4().setDestinationUriFileCounts((List)destinationFileCounts)));
        return new JobStatus().setState("DONE");
    }

    private JobStatus runQueryJob(JobConfigurationQuery query) throws IOException, InterruptedException {
        List<TableRow> rows = FakeBigQueryServices.rowsFromEncodedQuery(query.getQuery());
        this.datasetService.createTable(new Table().setTableReference(query.getDestinationTable()));
        this.datasetService.insertAll(query.getDestinationTable(), rows, null);
        return new JobStatus().setState("DONE");
    }

    private List<TableRow> readRows(String filename) throws IOException {
        TableRowJsonCoder coder = TableRowJsonCoder.of();
        ArrayList tableRows = Lists.newArrayList();
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(filename, new String[0]), StandardCharsets.UTF_8);){
            String line;
            while ((line = reader.readLine()) != null) {
                TableRow tableRow = (TableRow)coder.decode((InputStream)new ByteArrayInputStream(line.getBytes(StandardCharsets.UTF_8)), Coder.Context.OUTER);
                tableRows.add(tableRow);
            }
        }
        return tableRows;
    }

    private long writeRows(String tableId, List<TableRow> rows, TableSchema schema, String destinationPattern) throws IOException {
        Schema avroSchema = BigQueryAvroUtils.toGenericAvroSchema((String)tableId, (List)schema.getFields());
        ArrayList rowsToWrite = Lists.newArrayList();
        int shard = 0;
        for (TableRow row : rows) {
            rowsToWrite.add(row);
            if (rowsToWrite.size() != 5) continue;
            this.writeRowsHelper(rowsToWrite, avroSchema, destinationPattern, shard++);
            rowsToWrite.clear();
        }
        if (!rowsToWrite.isEmpty()) {
            this.writeRowsHelper(rowsToWrite, avroSchema, destinationPattern, shard++);
        }
        return shard;
    }

    private void writeRowsHelper(List<TableRow> rows, Schema avroSchema, String destinationPattern, int shard) {
        String filename = destinationPattern.replace("*", String.format("%012d", shard));
        try (WritableByteChannel channel = FileSystems.create((ResourceId)FileSystems.matchNewResource((String)filename, (boolean)false), (String)"application/octet-stream");
             DataFileWriter tableRowWriter = new DataFileWriter((DatumWriter)new GenericDatumWriter(avroSchema)).create(avroSchema, Channels.newOutputStream(channel));){
            for (Map map : rows) {
                GenericRecordBuilder genericRecordBuilder = new GenericRecordBuilder(avroSchema);
                for (Map.Entry field : map.entrySet()) {
                    genericRecordBuilder.set((String)field.getKey(), field.getValue());
                }
                tableRowWriter.append((Object)genericRecordBuilder.build());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Could not create destination for extract job %s", filename), e);
        }
    }

    private static class JobInfo {
        Job job;
        int getJobCount = 0;

        JobInfo(Job job) {
            this.job = job;
        }
    }
}

