/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.util.Base64;
import com.google.api.services.bigquery.model.TableRow;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.FakeDatasetService;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;

class FakeBigQueryServices
implements BigQueryServices {
    private BigQueryServices.JobService jobService;
    private FakeDatasetService datasetService;

    FakeBigQueryServices() {
    }

    FakeBigQueryServices withJobService(BigQueryServices.JobService jobService) {
        this.jobService = jobService;
        return this;
    }

    FakeBigQueryServices withDatasetService(FakeDatasetService datasetService) {
        this.datasetService = datasetService;
        return this;
    }

    public BigQueryServices.JobService getJobService(BigQueryOptions bqOptions) {
        return this.jobService;
    }

    public BigQueryServices.DatasetService getDatasetService(BigQueryOptions bqOptions) {
        return this.datasetService;
    }

    static List<TableRow> rowsFromEncodedQuery(String query) throws IOException {
        ListCoder listCoder = ListCoder.of((Coder)TableRowJsonCoder.of());
        ByteArrayInputStream input = new ByteArrayInputStream(Base64.decodeBase64((String)query));
        List rows = (List)listCoder.decode((InputStream)input, Coder.Context.OUTER);
        for (TableRow row : rows) {
            FakeBigQueryServices.convertNumbers(row);
        }
        return rows;
    }

    static String encodeQuery(List<TableRow> rows) throws IOException {
        ListCoder listCoder = ListCoder.of((Coder)TableRowJsonCoder.of());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        listCoder.encode(rows, (OutputStream)output, Coder.Context.OUTER);
        return Base64.encodeBase64String((byte[])output.toByteArray());
    }

    static TableRow convertNumbers(TableRow tableRow) {
        for (Map.Entry entry : tableRow.entrySet()) {
            if (!(entry.getValue() instanceof Integer)) continue;
            entry.setValue(Long.valueOf(((Integer)entry.getValue()).intValue()));
        }
        return tableRow;
    }
}

