/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.Mode;
import org.apache.beam.sdk.io.gcp.bigquery.StandardSQLTypeName;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class BigQueryUtilsTest {
    private static final Schema FLAT_TYPE = Schema.builder().addNullableField("id", Schema.FieldType.INT64).addNullableField("value", Schema.FieldType.DOUBLE).addNullableField("name", Schema.FieldType.STRING).addNullableField("timestamp", Schema.FieldType.DATETIME).addNullableField("valid", Schema.FieldType.BOOLEAN).build();
    private static final Schema ARRAY_TYPE = Schema.builder().addArrayField("ids", Schema.FieldType.INT64).build();
    private static final Schema ROW_TYPE = Schema.builder().addNullableField("row", Schema.FieldType.row((Schema)FLAT_TYPE)).build();
    private static final Schema ARRAY_ROW_TYPE = Schema.builder().addArrayField("rows", Schema.FieldType.row((Schema)FLAT_TYPE)).build();
    private static final TableFieldSchema ID = new TableFieldSchema().setName("id").setType(StandardSQLTypeName.INT64.toString());
    private static final TableFieldSchema VALUE = new TableFieldSchema().setName("value").setType(StandardSQLTypeName.FLOAT64.toString());
    private static final TableFieldSchema NAME = new TableFieldSchema().setName("name").setType(StandardSQLTypeName.STRING.toString());
    private static final TableFieldSchema TIMESTAMP = new TableFieldSchema().setName("timestamp").setType(StandardSQLTypeName.TIMESTAMP.toString());
    private static final TableFieldSchema VALID = new TableFieldSchema().setName("valid").setType(StandardSQLTypeName.BOOL.toString());
    private static final TableFieldSchema IDS = new TableFieldSchema().setName("ids").setType(StandardSQLTypeName.INT64.toString()).setMode(Mode.REPEATED.toString());
    private static final Row FLAT_ROW = Row.withSchema((Schema)FLAT_TYPE).addValues(new Object[]{123L, 123.456, "test", new DateTime(123456L), false}).build();
    private static final Row ARRAY_ROW = Row.withSchema((Schema)ARRAY_TYPE).addValues(new Object[]{Arrays.asList(123L, 124L)}).build();
    private static final Row ROW_ROW = Row.withSchema((Schema)ROW_TYPE).addValues(new Object[]{FLAT_ROW}).build();
    private static final Row ARRAY_ROW_ROW = Row.withSchema((Schema)ARRAY_ROW_TYPE).addValues(new Object[]{Arrays.asList(FLAT_ROW)}).build();

    @Test
    public void testToTableSchema_flat() {
        TableSchema schema = BigQueryUtils.toTableSchema((Schema)FLAT_TYPE);
        Assert.assertThat((Object)schema.getFields(), (Matcher)Matchers.containsInAnyOrder((Object[])new TableFieldSchema[]{ID, VALUE, NAME, TIMESTAMP, VALID}));
    }

    @Test
    public void testToTableSchema_array() {
        TableSchema schema = BigQueryUtils.toTableSchema((Schema)ARRAY_TYPE);
        Assert.assertThat((Object)schema.getFields(), (Matcher)Matchers.contains((Object[])new TableFieldSchema[]{IDS}));
    }

    @Test
    public void testToTableSchema_row() {
        TableSchema schema = BigQueryUtils.toTableSchema((Schema)ROW_TYPE);
        Assert.assertThat((Object)schema.getFields().size(), (Matcher)Matchers.equalTo((Object)1));
        TableFieldSchema field = (TableFieldSchema)schema.getFields().get(0);
        Assert.assertThat((Object)field.getName(), (Matcher)Matchers.equalTo((Object)"row"));
        Assert.assertThat((Object)field.getType(), (Matcher)Matchers.equalTo((Object)StandardSQLTypeName.STRUCT.toString()));
        Assert.assertThat((Object)field.getMode(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)field.getFields(), (Matcher)Matchers.containsInAnyOrder((Object[])new TableFieldSchema[]{ID, VALUE, NAME, TIMESTAMP, VALID}));
    }

    @Test
    public void testToTableSchema_array_row() {
        TableSchema schema = BigQueryUtils.toTableSchema((Schema)ARRAY_ROW_TYPE);
        Assert.assertThat((Object)schema.getFields().size(), (Matcher)Matchers.equalTo((Object)1));
        TableFieldSchema field = (TableFieldSchema)schema.getFields().get(0);
        Assert.assertThat((Object)field.getName(), (Matcher)Matchers.equalTo((Object)"rows"));
        Assert.assertThat((Object)field.getType(), (Matcher)Matchers.equalTo((Object)StandardSQLTypeName.STRUCT.toString()));
        Assert.assertThat((Object)field.getMode(), (Matcher)Matchers.equalTo((Object)Mode.REPEATED.toString()));
        Assert.assertThat((Object)field.getFields(), (Matcher)Matchers.containsInAnyOrder((Object[])new TableFieldSchema[]{ID, VALUE, NAME, TIMESTAMP, VALID}));
    }

    @Test
    public void testToTableRow_flat() {
        TableRow row = (TableRow)BigQueryUtils.toTableRow().apply((Object)FLAT_ROW);
        Assert.assertThat((Object)row.size(), (Matcher)Matchers.equalTo((Object)5));
        Assert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"id", (Object)123L));
        Assert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"value", (Object)123.456));
        Assert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"name", (Object)"test"));
        Assert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"valid", (Object)false));
    }

    @Test
    public void testToTableRow_array() {
        TableRow row = (TableRow)BigQueryUtils.toTableRow().apply((Object)ARRAY_ROW);
        Assert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"ids", Arrays.asList(123L, 124L)));
        Assert.assertThat((Object)row.size(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void testToTableRow_row() {
        TableRow row = (TableRow)BigQueryUtils.toTableRow().apply((Object)ROW_ROW);
        Assert.assertThat((Object)row.size(), (Matcher)Matchers.equalTo((Object)1));
        row = (TableRow)row.get((Object)"row");
        Assert.assertThat((Object)row.size(), (Matcher)Matchers.equalTo((Object)5));
        Assert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"id", (Object)123L));
        Assert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"value", (Object)123.456));
        Assert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"name", (Object)"test"));
        Assert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"valid", (Object)false));
    }

    @Test
    public void testToTableRow_array_row() {
        TableRow row = (TableRow)BigQueryUtils.toTableRow().apply((Object)ARRAY_ROW_ROW);
        Assert.assertThat((Object)row.size(), (Matcher)Matchers.equalTo((Object)1));
        row = (TableRow)((List)row.get((Object)"rows")).get(0);
        Assert.assertThat((Object)row.size(), (Matcher)Matchers.equalTo((Object)5));
        Assert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"id", (Object)123L));
        Assert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"value", (Object)123.456));
        Assert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"name", (Object)"test"));
        Assert.assertThat((Object)row, (Matcher)IsMapContaining.hasEntry((Object)"valid", (Object)false));
    }
}

