/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.JobStatistics2;
import com.google.api.services.bigquery.model.JobStatistics4;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.Streamingbuffer;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.bigtable.v2.Mutation;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.extensions.protobuf.ByteStringCoder;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryQuerySource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryTableSource;
import org.apache.beam.sdk.io.gcp.bigquery.FakeBigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.FakeDatasetService;
import org.apache.beam.sdk.io.gcp.bigquery.FakeJobService;
import org.apache.beam.sdk.io.gcp.bigquery.PassThroughThenCleanup;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.SourceTestUtils;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataEvaluator;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.model.Statement;

@RunWith(value=JUnit4.class)
public class BigQueryIOReadTest
implements Serializable {
    private transient PipelineOptions options;
    private transient TemporaryFolder testFolder = new TemporaryFolder();
    private transient TestPipeline p;
    @Rule
    public final transient TestRule folderThenPipeline = new TestRule(){

        public Statement apply(final Statement base, final Description description) {
            Statement withPipeline = new Statement(){

                public void evaluate() throws Throwable {
                    BigQueryIOReadTest.this.options = TestPipeline.testingPipelineOptions();
                    ((BigQueryOptions)BigQueryIOReadTest.this.options.as(BigQueryOptions.class)).setProject("project-id");
                    ((BigQueryOptions)BigQueryIOReadTest.this.options.as(BigQueryOptions.class)).setTempLocation(BigQueryIOReadTest.this.testFolder.getRoot().getAbsolutePath());
                    BigQueryIOReadTest.this.p = TestPipeline.fromOptions((PipelineOptions)BigQueryIOReadTest.this.options);
                    BigQueryIOReadTest.this.p.apply(base, description).evaluate();
                }
            };
            return BigQueryIOReadTest.this.testFolder.apply(withPipeline, description);
        }
    };
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();
    private FakeDatasetService fakeDatasetService = new FakeDatasetService();
    private FakeJobService fakeJobService = new FakeJobService();
    private FakeBigQueryServices fakeBqServices = new FakeBigQueryServices().withDatasetService(this.fakeDatasetService).withJobService(this.fakeJobService);

    private void checkReadTableObject(BigQueryIO.Read read, String project, String dataset, String table) {
        this.checkReadTableObjectWithValidate(read, project, dataset, table, true);
    }

    private void checkReadQueryObject(BigQueryIO.Read read, String query) {
        this.checkReadQueryObjectWithValidate(read, query, true);
    }

    private void checkReadTableObjectWithValidate(BigQueryIO.Read read, String project, String dataset, String table, boolean validate) {
        Assert.assertEquals((Object)project, (Object)read.getTable().getProjectId());
        Assert.assertEquals((Object)dataset, (Object)read.getTable().getDatasetId());
        Assert.assertEquals((Object)table, (Object)read.getTable().getTableId());
        Assert.assertNull((Object)read.getQuery());
        Assert.assertEquals((Object)validate, (Object)read.getValidate());
    }

    private void checkReadQueryObjectWithValidate(BigQueryIO.Read read, String query, boolean validate) {
        Assert.assertNull((Object)read.getTable());
        Assert.assertEquals((Object)query, (Object)read.getQuery().get());
        Assert.assertEquals((Object)validate, (Object)read.getValidate());
    }

    @Before
    public void setUp() throws IOException, InterruptedException {
        FakeDatasetService.setUp();
        BigQueryIO.clearCreatedTables();
        this.fakeDatasetService.createDataset("project-id", "dataset-id", "", "", null);
    }

    @Test
    public void testBuildTableBasedSource() {
        BigQueryIO.Read read = BigQueryIO.read().from("foo.com:project:somedataset.sometable");
        this.checkReadTableObject(read, "foo.com:project", "somedataset", "sometable");
    }

    @Test
    public void testBuildQueryBasedSource() {
        BigQueryIO.Read read = BigQueryIO.read().fromQuery("foo_query");
        this.checkReadQueryObject(read, "foo_query");
    }

    @Test
    public void testBuildTableBasedSourceWithoutValidation() {
        BigQueryIO.Read read = BigQueryIO.read().from("foo.com:project:somedataset.sometable").withoutValidation();
        this.checkReadTableObjectWithValidate(read, "foo.com:project", "somedataset", "sometable", false);
    }

    @Test
    public void testBuildQueryBasedSourceWithoutValidation() {
        BigQueryIO.Read read = BigQueryIO.read().fromQuery("some_query").withoutValidation();
        this.checkReadQueryObjectWithValidate(read, "some_query", false);
    }

    @Test
    public void testBuildTableBasedSourceWithDefaultProject() {
        BigQueryIO.Read read = BigQueryIO.read().from("somedataset.sometable");
        this.checkReadTableObject(read, null, "somedataset", "sometable");
    }

    @Test
    public void testBuildSourceWithTableReference() {
        TableReference table = new TableReference().setProjectId("foo.com:project").setDatasetId("somedataset").setTableId("sometable");
        BigQueryIO.Read read = BigQueryIO.read().from(table);
        this.checkReadTableObject(read, "foo.com:project", "somedataset", "sometable");
    }

    @Test
    public void testValidateReadSetsDefaultProject() throws Exception {
        String tableId = "sometable";
        TableReference tableReference = new TableReference().setProjectId("project-id").setDatasetId("dataset-id").setTableId(tableId);
        this.fakeDatasetService.createTable(new Table().setTableReference(tableReference).setSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))));
        FakeBigQueryServices fakeBqServices = new FakeBigQueryServices().withJobService(new FakeJobService()).withDatasetService(this.fakeDatasetService);
        ImmutableList expected = ImmutableList.of((Object)new TableRow().set("name", (Object)"a").set("number", (Object)1L), (Object)new TableRow().set("name", (Object)"b").set("number", (Object)2L), (Object)new TableRow().set("name", (Object)"c").set("number", (Object)3L), (Object)new TableRow().set("name", (Object)"d").set("number", (Object)4L), (Object)new TableRow().set("name", (Object)"e").set("number", (Object)5L), (Object)new TableRow().set("name", (Object)"f").set("number", (Object)6L));
        this.fakeDatasetService.insertAll(tableReference, (List<TableRow>)expected, null);
        TableReference tableRef = new TableReference().setDatasetId("dataset-id").setTableId(tableId);
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)BigQueryIO.read().from(tableRef).withTestServices((BigQueryServices)fakeBqServices))).apply((PTransform)ParDo.of((DoFn)new DoFn<TableRow, KV<String, Long>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                c.output((Object)KV.of((Object)((String)((TableRow)c.element()).get((Object)"name")), (Object)Long.valueOf((String)((TableRow)c.element()).get((Object)"number"))));
            }
        }));
        PAssert.that((PCollection)output).containsInAnyOrder((Iterable)ImmutableList.of((Object)KV.of((Object)"a", (Object)1L), (Object)KV.of((Object)"b", (Object)2L), (Object)KV.of((Object)"c", (Object)3L), (Object)KV.of((Object)"d", (Object)4L), (Object)KV.of((Object)"e", (Object)5L), (Object)KV.of((Object)"f", (Object)6L)));
        this.p.run();
    }

    @Test
    public void testBuildSourceWithTableAndFlatten() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid BigQueryIO.Read: Specifies a table with a result flattening preference, which only applies to queries");
        this.p.apply("ReadMyTable", (PTransform)BigQueryIO.read().from("foo.com:project:somedataset.sometable").withoutResultFlattening());
        this.p.run();
    }

    @Test
    public void testBuildSourceWithTableAndFlattenWithoutValidation() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid BigQueryIO.Read: Specifies a table with a result flattening preference, which only applies to queries");
        this.p.apply((PTransform)BigQueryIO.read().from("foo.com:project:somedataset.sometable").withoutValidation().withoutResultFlattening());
        this.p.run();
    }

    @Test
    public void testBuildSourceWithTableAndSqlDialect() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid BigQueryIO.Read: Specifies a table with a SQL dialect preference, which only applies to queries");
        this.p.apply((PTransform)BigQueryIO.read().from("foo.com:project:somedataset.sometable").usingStandardSql());
        this.p.run();
    }

    @Test
    public void testReadFromTableWithoutTemplateCompatibility() throws IOException, InterruptedException {
        this.testReadFromTable(false, false);
    }

    @Test
    public void testReadFromTableWithTemplateCompatibility() throws IOException, InterruptedException {
        this.testReadFromTable(true, false);
    }

    @Test
    public void testReadTableRowsFromTableWithoutTemplateCompatibility() throws IOException, InterruptedException {
        this.testReadFromTable(false, true);
    }

    @Test
    public void testReadTableRowsFromTableWithTemplateCompatibility() throws IOException, InterruptedException {
        this.testReadFromTable(true, true);
    }

    private void testReadFromTable(boolean useTemplateCompatibility, boolean useReadTableRows) throws IOException, InterruptedException {
        BigQueryIO.Read readTransform;
        BigQueryIO.Read read;
        Table sometable = new Table();
        sometable.setSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER"))));
        sometable.setTableReference(new TableReference().setProjectId("non-executing-project").setDatasetId("somedataset").setTableId("sometable"));
        sometable.setNumBytes(Long.valueOf(0x100000L));
        FakeDatasetService fakeDatasetService = new FakeDatasetService();
        fakeDatasetService.createDataset("non-executing-project", "somedataset", "", "", null);
        fakeDatasetService.createTable(sometable);
        ArrayList records = Lists.newArrayList((Object[])new TableRow[]{new TableRow().set("name", (Object)"a").set("number", (Object)1L), new TableRow().set("name", (Object)"b").set("number", (Object)2L), new TableRow().set("name", (Object)"c").set("number", (Object)3L)});
        fakeDatasetService.insertAll(sometable.getTableReference(), records, null);
        FakeBigQueryServices fakeBqServices = new FakeBigQueryServices().withJobService(new FakeJobService()).withDatasetService(fakeDatasetService);
        if (useReadTableRows) {
            read = BigQueryIO.read().from("non-executing-project:somedataset.sometable").withTestServices((BigQueryServices)fakeBqServices).withoutValidation();
            readTransform = useTemplateCompatibility ? read.withTemplateCompatibility() : read;
        } else {
            read = BigQueryIO.readTableRows().from("non-executing-project:somedataset.sometable").withTestServices((BigQueryServices)fakeBqServices).withoutValidation();
            readTransform = useTemplateCompatibility ? read.withTemplateCompatibility() : read;
        }
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)readTransform)).apply((PTransform)ParDo.of((DoFn)new DoFn<TableRow, KV<String, Long>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                c.output((Object)KV.of((Object)((String)((TableRow)c.element()).get((Object)"name")), (Object)Long.valueOf((String)((TableRow)c.element()).get((Object)"number"))));
            }
        }));
        PAssert.that((PCollection)output).containsInAnyOrder((Iterable)ImmutableList.of((Object)KV.of((Object)"a", (Object)1L), (Object)KV.of((Object)"b", (Object)2L), (Object)KV.of((Object)"c", (Object)3L)));
        this.p.run();
    }

    @Test
    public void testBuildSourceDisplayDataTable() {
        String tableSpec = "project:dataset.tableid";
        BigQueryIO.Read read = BigQueryIO.read().from(tableSpec).withoutResultFlattening().usingStandardSql().withoutValidation();
        DisplayData displayData = DisplayData.from((HasDisplayData)read);
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"table", (String)tableSpec));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"flattenResults", (Boolean)false));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"useLegacySql", (Boolean)false));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"validation", (Boolean)false));
    }

    @Test
    public void testBuildSourceDisplayDataQuery() {
        BigQueryIO.Read read = BigQueryIO.read().fromQuery("myQuery").withoutResultFlattening().usingStandardSql().withoutValidation();
        DisplayData displayData = DisplayData.from((HasDisplayData)read);
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"query", (String)"myQuery"));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"flattenResults", (Boolean)false));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"useLegacySql", (Boolean)false));
        Assert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"validation", (Boolean)false));
    }

    @Test
    public void testTableSourcePrimitiveDisplayData() throws IOException, InterruptedException {
        DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
        BigQueryIO.Read read = BigQueryIO.read().from("project:dataset.tableId").withTestServices((BigQueryServices)new FakeBigQueryServices().withDatasetService(new FakeDatasetService()).withJobService(new FakeJobService())).withoutValidation();
        Set displayData = evaluator.displayDataForPrimitiveSourceTransforms((PTransform)read);
        Assert.assertThat((String)"BigQueryIO.Read should include the table spec in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"table")));
    }

    @Test
    public void testQuerySourcePrimitiveDisplayData() throws IOException, InterruptedException {
        DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
        BigQueryIO.Read read = BigQueryIO.read().fromQuery("foobar").withTestServices((BigQueryServices)new FakeBigQueryServices().withDatasetService(new FakeDatasetService()).withJobService(new FakeJobService())).withoutValidation();
        Set displayData = evaluator.displayDataForPrimitiveSourceTransforms((PTransform)read);
        Assert.assertThat((String)"BigQueryIO.Read should include the query in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"query")));
    }

    @Test
    public void testBigQueryIOGetName() {
        Assert.assertEquals((Object)"BigQueryIO.Read", (Object)BigQueryIO.read().from("somedataset.sometable").getName());
    }

    @Test
    public void testBigQueryTableSourceInitSplit() throws Exception {
        ImmutableList expected = ImmutableList.of((Object)new TableRow().set("name", (Object)"a").set("number", (Object)1L), (Object)new TableRow().set("name", (Object)"b").set("number", (Object)2L), (Object)new TableRow().set("name", (Object)"c").set("number", (Object)3L), (Object)new TableRow().set("name", (Object)"d").set("number", (Object)4L), (Object)new TableRow().set("name", (Object)"e").set("number", (Object)5L), (Object)new TableRow().set("name", (Object)"f").set("number", (Object)6L));
        TableReference table = BigQueryHelpers.parseTableSpec((String)"project:data_set.table_name");
        this.fakeDatasetService.createDataset("project", "data_set", "", "", null);
        this.fakeDatasetService.createTable(new Table().setTableReference(table).setSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))));
        this.fakeDatasetService.insertAll(table, (List<TableRow>)expected, null);
        String stepUuid = "testStepUuid";
        BigQueryTableSource bqSource = BigQueryTableSource.create((String)stepUuid, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)table), (BigQueryServices)this.fakeBqServices, (Coder)TableRowJsonCoder.of(), (SerializableFunction)BigQueryIO.TableRowParser.INSTANCE);
        PipelineOptions options = PipelineOptionsFactory.create();
        options.setTempLocation(this.testFolder.getRoot().getAbsolutePath());
        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
        bqOptions.setProject("project");
        List<TableRow> read = this.convertStringsToLong(SourceTestUtils.readFromSplitsOfSource((BoundedSource)bqSource, (long)0L, (PipelineOptions)options));
        Assert.assertThat(read, (Matcher)Matchers.containsInAnyOrder((Object[])((TableRow[])Iterables.toArray((Iterable)expected, TableRow.class))));
        List sources = bqSource.split(100L, options);
        Assert.assertEquals((long)2L, (long)sources.size());
        sources = bqSource.split(200L, options);
        Assert.assertEquals((long)2L, (long)sources.size());
        Assert.assertEquals((long)1L, (long)this.fakeJobService.getNumExtractJobCalls());
    }

    @Test
    public void testEstimatedSizeWithoutStreamingBuffer() throws Exception {
        ImmutableList data = ImmutableList.of((Object)new TableRow().set("name", (Object)"a").set("number", (Object)1L), (Object)new TableRow().set("name", (Object)"b").set("number", (Object)2L), (Object)new TableRow().set("name", (Object)"c").set("number", (Object)3L), (Object)new TableRow().set("name", (Object)"d").set("number", (Object)4L), (Object)new TableRow().set("name", (Object)"e").set("number", (Object)5L), (Object)new TableRow().set("name", (Object)"f").set("number", (Object)6L));
        TableReference table = BigQueryHelpers.parseTableSpec((String)"project:data_set.table_name");
        this.fakeDatasetService.createDataset("project", "data_set", "", "", null);
        this.fakeDatasetService.createTable(new Table().setTableReference(table).setSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))));
        this.fakeDatasetService.insertAll(table, (List<TableRow>)data, null);
        String stepUuid = "testStepUuid";
        BigQueryTableSource bqSource = BigQueryTableSource.create((String)stepUuid, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)table), (BigQueryServices)this.fakeBqServices, (Coder)TableRowJsonCoder.of(), (SerializableFunction)BigQueryIO.TableRowParser.INSTANCE);
        PipelineOptions options = PipelineOptionsFactory.create();
        Assert.assertEquals((long)108L, (long)bqSource.getEstimatedSizeBytes(options));
    }

    @Test
    public void testEstimatedSizeWithStreamingBuffer() throws Exception {
        ImmutableList data = ImmutableList.of((Object)new TableRow().set("name", (Object)"a").set("number", (Object)1L), (Object)new TableRow().set("name", (Object)"b").set("number", (Object)2L), (Object)new TableRow().set("name", (Object)"c").set("number", (Object)3L), (Object)new TableRow().set("name", (Object)"d").set("number", (Object)4L), (Object)new TableRow().set("name", (Object)"e").set("number", (Object)5L), (Object)new TableRow().set("name", (Object)"f").set("number", (Object)6L));
        TableReference table = BigQueryHelpers.parseTableSpec((String)"project:data_set.table_name");
        this.fakeDatasetService.createDataset("project", "data_set", "", "", null);
        this.fakeDatasetService.createTable(new Table().setTableReference(table).setSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))).setStreamingBuffer(new Streamingbuffer().setEstimatedBytes(BigInteger.valueOf(10L))));
        this.fakeDatasetService.insertAll(table, (List<TableRow>)data, null);
        String stepUuid = "testStepUuid";
        BigQueryTableSource bqSource = BigQueryTableSource.create((String)stepUuid, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)table), (BigQueryServices)this.fakeBqServices, (Coder)TableRowJsonCoder.of(), (SerializableFunction)BigQueryIO.TableRowParser.INSTANCE);
        PipelineOptions options = PipelineOptionsFactory.create();
        Assert.assertEquals((long)118L, (long)bqSource.getEstimatedSizeBytes(options));
    }

    @Test
    public void testBigQueryQuerySourceEstimatedSize() throws Exception {
        ImmutableList data = ImmutableList.of((Object)new TableRow().set("name", (Object)"A").set("number", (Object)10L), (Object)new TableRow().set("name", (Object)"B").set("number", (Object)11L), (Object)new TableRow().set("name", (Object)"C").set("number", (Object)12L));
        PipelineOptions options = PipelineOptionsFactory.create();
        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
        bqOptions.setProject("project");
        String stepUuid = "testStepUuid";
        String query = FakeBigQueryServices.encodeQuery((List<TableRow>)data);
        BigQueryQuerySource bqSource = BigQueryQuerySource.create((String)stepUuid, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)query), (Boolean)true, (Boolean)true, (BigQueryServices)this.fakeBqServices, (Coder)TableRowJsonCoder.of(), (SerializableFunction)BigQueryIO.TableRowParser.INSTANCE, (BigQueryIO.TypedRead.QueryPriority)BigQueryIO.TypedRead.QueryPriority.BATCH, null);
        this.fakeJobService.expectDryRunQuery(bqOptions.getProject(), query, new JobStatistics().setQuery(new JobStatistics2().setTotalBytesProcessed(Long.valueOf(100L))));
        Assert.assertEquals((long)100L, (long)bqSource.getEstimatedSizeBytes((PipelineOptions)bqOptions));
    }

    @Test
    public void testBigQueryQuerySourceInitSplit() throws Exception {
        TableReference dryRunTable = new TableReference();
        Job queryJob = new Job();
        JobStatistics queryJobStats = new JobStatistics();
        JobStatistics2 queryStats = new JobStatistics2();
        queryStats.setReferencedTables((List)ImmutableList.of((Object)dryRunTable));
        queryJobStats.setQuery(queryStats);
        queryJob.setStatus(new JobStatus()).setStatistics(queryJobStats);
        Job extractJob = new Job();
        JobStatistics extractJobStats = new JobStatistics();
        JobStatistics4 extractStats = new JobStatistics4();
        extractStats.setDestinationUriFileCounts((List)ImmutableList.of((Object)1L));
        extractJobStats.setExtract(extractStats);
        extractJob.setStatus(new JobStatus()).setStatistics(extractJobStats);
        ImmutableList expected = ImmutableList.of((Object)new TableRow().set("name", (Object)"a").set("number", (Object)1L), (Object)new TableRow().set("name", (Object)"b").set("number", (Object)2L), (Object)new TableRow().set("name", (Object)"c").set("number", (Object)3L), (Object)new TableRow().set("name", (Object)"d").set("number", (Object)4L), (Object)new TableRow().set("name", (Object)"e").set("number", (Object)5L), (Object)new TableRow().set("name", (Object)"f").set("number", (Object)6L));
        PipelineOptions options = PipelineOptionsFactory.create();
        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
        bqOptions.setProject("project");
        String stepUuid = "testStepUuid";
        TableReference tempTableReference = BigQueryHelpers.createTempTableReference((String)bqOptions.getProject(), (String)BigQueryHelpers.createJobIdToken((String)bqOptions.getJobName(), (String)stepUuid));
        this.fakeDatasetService.createDataset(bqOptions.getProject(), tempTableReference.getDatasetId(), "", "", null);
        this.fakeDatasetService.createTable(new Table().setTableReference(tempTableReference).setSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER")))));
        String query = FakeBigQueryServices.encodeQuery((List<TableRow>)expected);
        BigQueryQuerySource bqSource = BigQueryQuerySource.create((String)stepUuid, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)query), (Boolean)true, (Boolean)true, (BigQueryServices)this.fakeBqServices, (Coder)TableRowJsonCoder.of(), (SerializableFunction)BigQueryIO.TableRowParser.INSTANCE, (BigQueryIO.TypedRead.QueryPriority)BigQueryIO.TypedRead.QueryPriority.BATCH, null);
        options.setTempLocation(this.testFolder.getRoot().getAbsolutePath());
        TableReference queryTable = new TableReference().setProjectId(bqOptions.getProject()).setDatasetId(tempTableReference.getDatasetId()).setTableId(tempTableReference.getTableId());
        this.fakeJobService.expectDryRunQuery(bqOptions.getProject(), query, new JobStatistics().setQuery(new JobStatistics2().setTotalBytesProcessed(Long.valueOf(100L)).setReferencedTables((List)ImmutableList.of((Object)queryTable))));
        List<TableRow> read = this.convertStringsToLong(SourceTestUtils.readFromSplitsOfSource((BoundedSource)bqSource, (long)0L, (PipelineOptions)options));
        Assert.assertThat(read, (Matcher)Matchers.containsInAnyOrder((Object[])((TableRow[])Iterables.toArray((Iterable)expected, TableRow.class))));
        List sources = bqSource.split(100L, options);
        Assert.assertEquals((long)2L, (long)sources.size());
    }

    @Test
    public void testBigQueryNoTableQuerySourceInitSplit() throws Exception {
        TableReference dryRunTable = new TableReference();
        Job queryJob = new Job();
        JobStatistics queryJobStats = new JobStatistics();
        JobStatistics2 queryStats = new JobStatistics2();
        queryStats.setReferencedTables((List)ImmutableList.of((Object)dryRunTable));
        queryJobStats.setQuery(queryStats);
        queryJob.setStatus(new JobStatus()).setStatistics(queryJobStats);
        Job extractJob = new Job();
        JobStatistics extractJobStats = new JobStatistics();
        JobStatistics4 extractStats = new JobStatistics4();
        extractStats.setDestinationUriFileCounts((List)ImmutableList.of((Object)1L));
        extractJobStats.setExtract(extractStats);
        extractJob.setStatus(new JobStatus()).setStatistics(extractJobStats);
        String stepUuid = "testStepUuid";
        TableReference tempTableReference = BigQueryHelpers.createTempTableReference((String)"project-id", (String)BigQueryHelpers.createJobIdToken((String)this.options.getJobName(), (String)stepUuid));
        ImmutableList expected = ImmutableList.of((Object)new TableRow().set("name", (Object)"a").set("number", (Object)1L), (Object)new TableRow().set("name", (Object)"b").set("number", (Object)2L), (Object)new TableRow().set("name", (Object)"c").set("number", (Object)3L), (Object)new TableRow().set("name", (Object)"d").set("number", (Object)4L), (Object)new TableRow().set("name", (Object)"e").set("number", (Object)5L), (Object)new TableRow().set("name", (Object)"f").set("number", (Object)6L));
        this.fakeDatasetService.createDataset(tempTableReference.getProjectId(), tempTableReference.getDatasetId(), "", "", null);
        Table table = new Table().setTableReference(tempTableReference).setSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("name").setType("STRING"), (Object)new TableFieldSchema().setName("number").setType("INTEGER"))));
        this.fakeDatasetService.createTable(table);
        String query = FakeBigQueryServices.encodeQuery((List<TableRow>)expected);
        this.fakeJobService.expectDryRunQuery("project-id", query, new JobStatistics().setQuery(new JobStatistics2().setTotalBytesProcessed(Long.valueOf(100L)).setReferencedTables((List)ImmutableList.of((Object)table.getTableReference()))));
        BigQueryQuerySource bqSource = BigQueryQuerySource.create((String)stepUuid, (ValueProvider)ValueProvider.StaticValueProvider.of((Object)query), (Boolean)true, (Boolean)true, (BigQueryServices)this.fakeBqServices, (Coder)TableRowJsonCoder.of(), (SerializableFunction)BigQueryIO.TableRowParser.INSTANCE, (BigQueryIO.TypedRead.QueryPriority)BigQueryIO.TypedRead.QueryPriority.BATCH, null);
        this.options.setTempLocation(this.testFolder.getRoot().getAbsolutePath());
        List<TableRow> read = this.convertStringsToLong(SourceTestUtils.readFromSplitsOfSource((BoundedSource)bqSource, (long)0L, (PipelineOptions)this.options));
        Assert.assertThat(read, (Matcher)Matchers.containsInAnyOrder((Object[])((TableRow[])Iterables.toArray((Iterable)expected, TableRow.class))));
        List sources = bqSource.split(100L, this.options);
        Assert.assertEquals((long)2L, (long)sources.size());
    }

    @Test
    public void testPassThroughThenCleanup() throws Exception {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)new PassThroughThenCleanup(new PassThroughThenCleanup.CleanupOperation(){

            void cleanup(PassThroughThenCleanup.ContextContainer c) throws Exception {
            }
        }, (PCollectionView)((PCollection)this.p.apply("Create1", (PTransform)Create.of((Object)"", (Object[])new String[0]))).apply((PTransform)View.asSingleton())));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{1, 2, 3});
        this.p.run();
    }

    @Test
    public void testPassThroughThenCleanupExecuted() throws Exception {
        ((PCollection)this.p.apply((PTransform)Create.empty((Coder)VarIntCoder.of()))).apply((PTransform)new PassThroughThenCleanup(new PassThroughThenCleanup.CleanupOperation(){

            void cleanup(PassThroughThenCleanup.ContextContainer c) throws Exception {
                throw new RuntimeException("cleanup executed");
            }
        }, (PCollectionView)((PCollection)this.p.apply("Create1", (PTransform)Create.of((Object)"", (Object[])new String[0]))).apply((PTransform)View.asSingleton())));
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("cleanup executed");
        this.p.run();
    }

    @Test
    public void testRuntimeOptionsNotCalledInApplyInputTable() {
        BigQueryIO.Read read = BigQueryIO.read().from(this.p.newProvider((Object)"")).withoutValidation();
        DisplayData.from((HasDisplayData)read);
    }

    @Test
    public void testRuntimeOptionsNotCalledInApplyInputQuery() {
        BigQueryIO.Read read = BigQueryIO.read().fromQuery(this.p.newProvider((Object)"")).withoutValidation();
        DisplayData.from((HasDisplayData)read);
    }

    List<TableRow> convertStringsToLong(List<TableRow> toConvert) {
        ArrayList converted = Lists.newArrayList();
        for (TableRow entry : toConvert) {
            TableRow convertedEntry = entry.clone();
            convertedEntry.set("number", (Object)Long.parseLong((String)convertedEntry.get((Object)"number")));
            converted.add(convertedEntry);
        }
        return converted;
    }

    @Test
    public void testCoderInference() {
        SerializableFunction<SchemaAndRecord, KV<ByteString, Mutation>> parseFn = new SerializableFunction<SchemaAndRecord, KV<ByteString, Mutation>>(){

            public KV<ByteString, Mutation> apply(SchemaAndRecord input) {
                return null;
            }
        };
        Assert.assertEquals((Object)KvCoder.of((Coder)ByteStringCoder.of(), (Coder)ProtoCoder.of(Mutation.class)), (Object)BigQueryIO.read((SerializableFunction)parseFn).inferCoder(CoderRegistry.createDefault()));
    }
}

