/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.util.Data;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ShardedKeyCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowInfoCoder;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryHelpersTest {
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    @Test
    public void testTableParsing() {
        TableReference ref = BigQueryHelpers.parseTableSpec((String)"my-project:data_set.table_name");
        Assert.assertEquals((Object)"my-project", (Object)ref.getProjectId());
        Assert.assertEquals((Object)"data_set", (Object)ref.getDatasetId());
        Assert.assertEquals((Object)"table_name", (Object)ref.getTableId());
    }

    @Test
    public void testTableParsing_validPatterns() {
        BigQueryHelpers.parseTableSpec((String)"a123-456:foo_bar.d");
        BigQueryHelpers.parseTableSpec((String)"a12345:b.c");
        BigQueryHelpers.parseTableSpec((String)"b12345.c");
    }

    @Test
    public void testTableParsing_noProjectId() {
        TableReference ref = BigQueryHelpers.parseTableSpec((String)"data_set.table_name");
        Assert.assertEquals(null, (Object)ref.getProjectId());
        Assert.assertEquals((Object)"data_set", (Object)ref.getDatasetId());
        Assert.assertEquals((Object)"table_name", (Object)ref.getTableId());
    }

    @Test
    public void testTableParsingError() {
        this.thrown.expect(IllegalArgumentException.class);
        BigQueryHelpers.parseTableSpec((String)"0123456:foo.bar");
    }

    @Test
    public void testTableParsingError_2() {
        this.thrown.expect(IllegalArgumentException.class);
        BigQueryHelpers.parseTableSpec((String)"myproject:.bar");
    }

    @Test
    public void testTableParsingError_3() {
        this.thrown.expect(IllegalArgumentException.class);
        BigQueryHelpers.parseTableSpec((String)":a.b");
    }

    @Test
    public void testTableParsingError_slash() {
        this.thrown.expect(IllegalArgumentException.class);
        BigQueryHelpers.parseTableSpec((String)"a\\b12345:c.d");
    }

    @Test
    public void testTableDecoratorStripping() {
        Assert.assertEquals((Object)"project:dataset.table", (Object)BigQueryHelpers.stripPartitionDecorator((String)"project:dataset.table$20171127"));
        Assert.assertEquals((Object)"project:dataset.table", (Object)BigQueryHelpers.stripPartitionDecorator((String)"project:dataset.table"));
    }

    @Test
    public void testCoder_nullCell() throws CoderException {
        TableRow row = new TableRow();
        row.set("temperature", Data.nullOf(Object.class));
        row.set("max_temperature", Data.nullOf(Object.class));
        byte[] bytes = CoderUtils.encodeToByteArray((Coder)TableRowJsonCoder.of(), (Object)row);
        TableRow newRow = (TableRow)CoderUtils.decodeFromByteArray((Coder)TableRowJsonCoder.of(), (byte[])bytes);
        byte[] newBytes = CoderUtils.encodeToByteArray((Coder)TableRowJsonCoder.of(), (Object)newRow);
        Assert.assertArrayEquals((byte[])bytes, (byte[])newBytes);
    }

    @Test
    public void testShardedKeyCoderIsSerializableWithWellKnownCoderType() {
        CoderProperties.coderSerializable((Coder)ShardedKeyCoder.of((Coder)GlobalWindow.Coder.INSTANCE));
    }

    @Test
    public void testTableRowInfoCoderSerializable() {
        CoderProperties.coderSerializable((Coder)TableRowInfoCoder.of());
    }

    @Test
    public void testComplexCoderSerializable() {
        CoderProperties.coderSerializable((Coder)WindowedValue.getFullCoder((Coder)KvCoder.of((Coder)ShardedKeyCoder.of((Coder)StringUtf8Coder.of()), (Coder)TableRowInfoCoder.of()), (Coder)IntervalWindow.getCoder()));
    }
}

