/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.reflect.Nullable;
import org.apache.avro.util.Utf8;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryAvroUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryAvroUtilsTest {
    private List<TableFieldSchema> subFields = Lists.newArrayList((Object[])new TableFieldSchema[]{new TableFieldSchema().setName("species").setType("STRING").setMode("NULLABLE")});
    private List<TableFieldSchema> fields = Lists.newArrayList((Object[])new TableFieldSchema[]{new TableFieldSchema().setName("number").setType("INTEGER").setMode("REQUIRED"), new TableFieldSchema().setName("species").setType("STRING").setMode("NULLABLE"), new TableFieldSchema().setName("quality").setType("FLOAT"), new TableFieldSchema().setName("quantity").setType("INTEGER"), new TableFieldSchema().setName("birthday").setType("TIMESTAMP").setMode("NULLABLE"), new TableFieldSchema().setName("flighted").setType("BOOLEAN").setMode("NULLABLE"), new TableFieldSchema().setName("sound").setType("BYTES").setMode("NULLABLE"), new TableFieldSchema().setName("anniversaryDate").setType("DATE").setMode("NULLABLE"), new TableFieldSchema().setName("anniversaryDatetime").setType("DATETIME").setMode("NULLABLE"), new TableFieldSchema().setName("anniversaryTime").setType("TIME").setMode("NULLABLE"), new TableFieldSchema().setName("scion").setType("RECORD").setMode("NULLABLE").setFields(this.subFields), new TableFieldSchema().setName("associates").setType("RECORD").setMode("REPEATED").setFields(this.subFields)});

    @Test
    public void testConvertGenericRecordToTableRow() throws Exception {
        TableSchema tableSchema = new TableSchema();
        tableSchema.setFields(this.fields);
        Schema avroSchema = AvroCoder.of(Bird.class).getSchema();
        GenericData.Record record = new GenericData.Record(avroSchema);
        record.put("number", (Object)5L);
        TableRow convertedRow = BigQueryAvroUtils.convertGenericRecordToTableRow((GenericRecord)record, (TableSchema)tableSchema);
        TableRow row = new TableRow().set("number", (Object)"5").set("associates", new ArrayList());
        Assert.assertEquals((Object)row, (Object)convertedRow);
        record = new GenericData.Record(avroSchema);
        byte[] soundBytes = "chirp,chirp".getBytes(StandardCharsets.UTF_8);
        ByteBuffer soundByteBuffer = ByteBuffer.wrap(soundBytes);
        soundByteBuffer.rewind();
        record.put("number", (Object)5L);
        record.put("quality", (Object)5.0);
        record.put("birthday", (Object)5L);
        record.put("flighted", (Object)Boolean.TRUE);
        record.put("sound", (Object)soundByteBuffer);
        record.put("anniversaryDate", (Object)new Utf8("2000-01-01"));
        record.put("anniversaryDatetime", (Object)new String("2000-01-01 00:00:00.000005"));
        record.put("anniversaryTime", (Object)new Utf8("00:00:00.000005"));
        TableRow convertedRow2 = BigQueryAvroUtils.convertGenericRecordToTableRow((GenericRecord)record, (TableSchema)tableSchema);
        TableRow row2 = new TableRow().set("number", (Object)"5").set("birthday", (Object)"1970-01-01 00:00:00.000005 UTC").set("quality", (Object)5.0).set("associates", new ArrayList()).set("flighted", (Object)Boolean.TRUE).set("sound", (Object)BaseEncoding.base64().encode(soundBytes)).set("anniversaryDate", (Object)"2000-01-01").set("anniversaryDatetime", (Object)"2000-01-01 00:00:00.000005").set("anniversaryTime", (Object)"00:00:00.000005");
        Assert.assertEquals((Object)row2, (Object)convertedRow2);
        Schema subBirdSchema = AvroCoder.of(Bird.SubBird.class).getSchema();
        GenericData.Record nestedRecord = new GenericData.Record(subBirdSchema);
        nestedRecord.put("species", (Object)"other");
        GenericData.Record record2 = new GenericData.Record(avroSchema);
        record2.put("number", (Object)5L);
        record2.put("associates", (Object)Lists.newArrayList((Object[])new GenericRecord[]{nestedRecord}));
        convertedRow2 = BigQueryAvroUtils.convertGenericRecordToTableRow((GenericRecord)record2, (TableSchema)tableSchema);
        row2 = new TableRow().set("associates", (Object)Lists.newArrayList((Object[])new TableRow[]{new TableRow().set("species", (Object)"other")})).set("number", (Object)"5");
        Assert.assertEquals((Object)row2, (Object)convertedRow2);
    }

    @Test
    public void testConvertBigQuerySchemaToAvroSchema() {
        TableSchema tableSchema = new TableSchema();
        tableSchema.setFields(this.fields);
        Schema avroSchema = BigQueryAvroUtils.toGenericAvroSchema((String)"testSchema", (List)tableSchema.getFields());
        Assert.assertThat((Object)avroSchema.getField("number").schema(), (Matcher)Matchers.equalTo((Object)Schema.create((Schema.Type)Schema.Type.LONG)));
        Assert.assertThat((Object)avroSchema.getField("species").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)})));
        Assert.assertThat((Object)avroSchema.getField("quality").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.DOUBLE)})));
        Assert.assertThat((Object)avroSchema.getField("quantity").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG)})));
        Assert.assertThat((Object)avroSchema.getField("birthday").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG)})));
        Assert.assertThat((Object)avroSchema.getField("flighted").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.BOOLEAN)})));
        Assert.assertThat((Object)avroSchema.getField("sound").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.BYTES)})));
        Assert.assertThat((Object)avroSchema.getField("anniversaryDate").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)})));
        Assert.assertThat((Object)avroSchema.getField("anniversaryDatetime").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)})));
        Assert.assertThat((Object)avroSchema.getField("anniversaryTime").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)})));
        Assert.assertThat((Object)avroSchema.getField("scion").schema(), (Matcher)Matchers.equalTo((Object)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.createRecord((String)"scion", (String)"org.apache.beam.sdk.io.gcp.bigquery", (String)"Translated Avro Schema for scion", (boolean)false, (List)ImmutableList.of((Object)new Schema.Field("species", Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)}), null, null)))})));
        Assert.assertThat((Object)avroSchema.getField("associates").schema(), (Matcher)Matchers.equalTo((Object)Schema.createArray((Schema)Schema.createRecord((String)"associates", (String)"org.apache.beam.sdk.io.gcp.bigquery", (String)"Translated Avro Schema for associates", (boolean)false, (List)ImmutableList.of((Object)new Schema.Field("species", Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)}), null, null))))));
    }

    @DefaultCoder(value=AvroCoder.class)
    static class Bird {
        long number;
        @Nullable
        String species;
        @Nullable
        Double quality;
        @Nullable
        Long quantity;
        @Nullable
        Long birthday;
        @Nullable
        Boolean flighted;
        @Nullable
        ByteBuffer sound;
        @Nullable
        Utf8 anniversaryDate;
        @Nullable
        String anniversaryDatetime;
        @Nullable
        Utf8 anniversaryTime;
        @Nullable
        SubBird scion;
        SubBird[] associates = new SubBird[1];

        public Bird() {
            this.associates[0] = new SubBird();
        }

        static class SubBird {
            @Nullable
            String species;
        }
    }
}

