/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp;

import com.google.api.gax.grpc.ApiException;
import com.google.api.gax.paging.Page;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.cloud.BaseServiceException;
import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.RetryHelper;
import com.google.cloud.Timestamp;
import com.google.cloud.bigtable.grpc.BigtableClusterName;
import com.google.cloud.bigtable.grpc.BigtableInstanceName;
import com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.cloud.grpc.BaseGrpcServiceException;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.beam.sdk.io.gcp.testing.BigqueryMatcher;
import org.apache.beam.sdk.util.ApiSurface;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GcpApiSurfaceTest {
    @Test
    public void testGcpApiSurface() throws Exception {
        Package thisPackage = this.getClass().getPackage();
        ClassLoader thisClassLoader = this.getClass().getClassLoader();
        ApiSurface apiSurface = ApiSurface.ofPackage((Package)thisPackage, (ClassLoader)thisClassLoader).pruningPattern(BigqueryMatcher.class.getName()).pruningPattern("org[.]apache[.]beam[.].*Test.*").pruningPattern("org[.]apache[.]beam[.].*IT").pruningPattern("java[.]lang.*").pruningPattern("java[.]util.*");
        ImmutableSet allowedClasses = ImmutableSet.of((Object)ApiSurface.classesInPackage((String)"com.google.api.core"), (Object)ApiSurface.classesInPackage((String)"com.google.api.client.googleapis"), (Object)ApiSurface.classesInPackage((String)"com.google.api.client.http"), (Object)ApiSurface.classesInPackage((String)"com.google.api.client.json"), (Object)ApiSurface.classesInPackage((String)"com.google.api.client.util"), (Object)ApiSurface.classesInPackage((String)"com.google.api.services.bigquery.model"), (Object[])new Matcher[]{ApiSurface.classesInPackage((String)"com.google.auth"), ApiSurface.classesInPackage((String)"com.google.bigtable.v2"), ApiSurface.classesInPackage((String)"com.google.cloud.bigtable.config"), ApiSurface.classesInPackage((String)"com.google.spanner.v1"), Matchers.equalTo(ApiException.class), Matchers.equalTo(Page.class), Matchers.equalTo(ResourceName.class), Matchers.equalTo(ResourceNameType.class), Matchers.equalTo(BigtableClusterName.class), Matchers.equalTo(BigtableInstanceName.class), Matchers.equalTo(BigtableTableName.class), Matchers.equalTo(BaseServiceException.class), Matchers.equalTo(BaseServiceException.Error.class), Matchers.equalTo(BaseServiceException.ExceptionData.class), Matchers.equalTo(BaseServiceException.ExceptionData.Builder.class), Matchers.equalTo(RetryHelper.RetryHelperException.class), Matchers.equalTo(BaseGrpcServiceException.class), Matchers.equalTo(ByteArray.class), Matchers.equalTo(Date.class), Matchers.equalTo(Timestamp.class), ApiSurface.classesInPackage((String)"com.google.cloud.spanner"), ApiSurface.classesInPackage((String)"com.google.spanner.admin.database.v1"), ApiSurface.classesInPackage((String)"com.google.datastore.v1"), ApiSurface.classesInPackage((String)"com.google.protobuf"), ApiSurface.classesInPackage((String)"com.google.type"), ApiSurface.classesInPackage((String)"com.fasterxml.jackson.annotation"), ApiSurface.classesInPackage((String)"com.fasterxml.jackson.core"), ApiSurface.classesInPackage((String)"com.fasterxml.jackson.databind"), ApiSurface.classesInPackage((String)"io.grpc"), ApiSurface.classesInPackage((String)"java"), ApiSurface.classesInPackage((String)"javax"), ApiSurface.classesInPackage((String)"org.apache.avro"), ApiSurface.classesInPackage((String)"org.apache.beam"), ApiSurface.classesInPackage((String)"org.apache.commons.logging"), ApiSurface.classesInPackage((String)"org.codehaus.jackson"), ApiSurface.classesInPackage((String)"org.joda.time")});
        MatcherAssert.assertThat((Object)apiSurface, (Matcher)ApiSurface.containsOnlyClassesMatching((Set)allowedClasses));
    }
}

