/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.util;

import com.google.cloud.Timestamp;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.util.concurrent.TimeUnit;

public class TimestampGenerator
extends Generator<Timestamp> {
    private static final long MIN_SECONDS = Timestamp.MIN_VALUE.getSeconds();
    private static final long MAX_SECONDS = Timestamp.MAX_VALUE.getSeconds();
    private static final int NANOS_PER_SECOND = (int)TimeUnit.SECONDS.toNanos(1L);

    public TimestampGenerator() {
        super(Timestamp.class);
    }

    public Timestamp generate(SourceOfRandomness random, GenerationStatus status) {
        long seconds = random.nextLong(MIN_SECONDS, MAX_SECONDS);
        int nanos = random.nextInt(0, NANOS_PER_SECOND);
        return Timestamp.ofTimeSecondsAndNanos((long)seconds, (int)nanos);
    }
}

