/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.util;

import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChildPartition;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChildPartitionsRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ColumnType;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.DataChangeRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.HeartbeatRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.Mod;

public class TestStructMapper {
    private static final Type CHILD_PARTITION_TYPE = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"token", (Type)Type.string()), Type.StructField.of((String)"parent_partition_tokens", (Type)Type.array((Type)Type.string()))});
    private static final Type COLUMN_TYPE_STRING_TYPE = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"name", (Type)Type.string()), Type.StructField.of((String)"type", (Type)Type.string()), Type.StructField.of((String)"is_primary_key", (Type)Type.bool()), Type.StructField.of((String)"ordinal_position", (Type)Type.int64())});
    private static final Type COLUMN_TYPE_JSON_TYPE = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"name", (Type)Type.string()), Type.StructField.of((String)"type", (Type)Type.json()), Type.StructField.of((String)"is_primary_key", (Type)Type.bool()), Type.StructField.of((String)"ordinal_position", (Type)Type.int64())});
    private static final Type MOD_STRING_TYPE = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"keys", (Type)Type.string()), Type.StructField.of((String)"new_values", (Type)Type.string()), Type.StructField.of((String)"old_values", (Type)Type.string())});
    private static final Type MOD_JSON_TYPE = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"keys", (Type)Type.json()), Type.StructField.of((String)"new_values", (Type)Type.json()), Type.StructField.of((String)"old_values", (Type)Type.json())});
    private static final Type DATA_CHANGE_RECORD_STRING_TYPE = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"commit_timestamp", (Type)Type.timestamp()), Type.StructField.of((String)"record_sequence", (Type)Type.string()), Type.StructField.of((String)"server_transaction_id", (Type)Type.string()), Type.StructField.of((String)"is_last_record_in_transaction_in_partition", (Type)Type.bool()), Type.StructField.of((String)"table_name", (Type)Type.string()), Type.StructField.of((String)"column_types", (Type)Type.array((Type)COLUMN_TYPE_STRING_TYPE)), Type.StructField.of((String)"mods", (Type)Type.array((Type)MOD_STRING_TYPE)), Type.StructField.of((String)"mod_type", (Type)Type.string()), Type.StructField.of((String)"value_capture_type", (Type)Type.string()), Type.StructField.of((String)"number_of_records_in_transaction", (Type)Type.int64()), Type.StructField.of((String)"number_of_partitions_in_transaction", (Type)Type.int64())});
    private static final Type DATA_CHANGE_RECORD_JSON_TYPE = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"commit_timestamp", (Type)Type.timestamp()), Type.StructField.of((String)"record_sequence", (Type)Type.string()), Type.StructField.of((String)"server_transaction_id", (Type)Type.string()), Type.StructField.of((String)"is_last_record_in_transaction_in_partition", (Type)Type.bool()), Type.StructField.of((String)"table_name", (Type)Type.string()), Type.StructField.of((String)"column_types", (Type)Type.array((Type)COLUMN_TYPE_JSON_TYPE)), Type.StructField.of((String)"mods", (Type)Type.array((Type)MOD_JSON_TYPE)), Type.StructField.of((String)"mod_type", (Type)Type.string()), Type.StructField.of((String)"value_capture_type", (Type)Type.string()), Type.StructField.of((String)"number_of_records_in_transaction", (Type)Type.int64()), Type.StructField.of((String)"number_of_partitions_in_transaction", (Type)Type.int64())});
    private static final Type HEARTBEAT_RECORD_TYPE = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"timestamp", (Type)Type.timestamp())});
    private static final Type CHILD_PARTITIONS_RECORD_TYPE = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"start_timestamp", (Type)Type.timestamp()), Type.StructField.of((String)"record_sequence", (Type)Type.string()), Type.StructField.of((String)"child_partitions", (Type)Type.array((Type)CHILD_PARTITION_TYPE))});
    private static final Type STREAM_RECORD_STRING_TYPE = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"data_change_record", (Type)Type.array((Type)DATA_CHANGE_RECORD_STRING_TYPE)), Type.StructField.of((String)"heartbeat_record", (Type)Type.array((Type)HEARTBEAT_RECORD_TYPE)), Type.StructField.of((String)"child_partitions_record", (Type)Type.array((Type)CHILD_PARTITIONS_RECORD_TYPE))});
    private static final Type STREAM_RECORD_JSON_TYPE = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"data_change_record", (Type)Type.array((Type)DATA_CHANGE_RECORD_JSON_TYPE)), Type.StructField.of((String)"heartbeat_record", (Type)Type.array((Type)HEARTBEAT_RECORD_TYPE)), Type.StructField.of((String)"child_partitions_record", (Type)Type.array((Type)CHILD_PARTITIONS_RECORD_TYPE))});

    public static Struct recordsToStructWithJson(ChangeStreamRecord ... records) {
        return TestStructMapper.recordsToStruct(false, false, true, records);
    }

    public static Struct recordsWithUnknownModTypeAndValueCaptureType(ChangeStreamRecord ... records) {
        return TestStructMapper.recordsToStruct(true, true, true, records);
    }

    public static Struct recordsToStructWithStrings(ChangeStreamRecord ... records) {
        return TestStructMapper.recordsToStruct(false, false, false, records);
    }

    private static Struct recordsToStruct(boolean useUnknownModType, boolean useUnknownValueCaptureType, boolean useJsonFields, ChangeStreamRecord ... records) {
        Type streamRecordType = useJsonFields ? STREAM_RECORD_JSON_TYPE : STREAM_RECORD_STRING_TYPE;
        return Struct.newBuilder().add(Value.structArray((Type)streamRecordType, (Iterable)Arrays.stream(records).map(record -> TestStructMapper.streamRecordStructFrom(record, useUnknownModType, useUnknownValueCaptureType, useJsonFields)).collect(Collectors.toList()))).build();
    }

    private static Struct streamRecordStructFrom(ChangeStreamRecord record, boolean useUnknownModType, boolean useUnknownValueCaptureType, boolean useJsonFields) {
        if (record instanceof DataChangeRecord) {
            return TestStructMapper.streamRecordStructFrom((DataChangeRecord)record, useUnknownModType, useUnknownValueCaptureType, useJsonFields);
        }
        if (record instanceof HeartbeatRecord) {
            return TestStructMapper.streamRecordStructFrom((HeartbeatRecord)record, useJsonFields);
        }
        if (record instanceof ChildPartitionsRecord) {
            return TestStructMapper.streamRecordStructFrom((ChildPartitionsRecord)record, useJsonFields);
        }
        throw new UnsupportedOperationException("Unimplemented mapping for " + record.getClass());
    }

    private static Struct streamRecordStructFrom(ChildPartitionsRecord record, boolean useJsonFields) {
        Type dataChangeRecordType = useJsonFields ? DATA_CHANGE_RECORD_JSON_TYPE : DATA_CHANGE_RECORD_STRING_TYPE;
        return ((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("data_change_record").to(Value.structArray((Type)dataChangeRecordType, Collections.emptyList()))).set("heartbeat_record").to(Value.structArray((Type)HEARTBEAT_RECORD_TYPE, Collections.emptyList()))).set("child_partitions_record").to(Value.structArray((Type)CHILD_PARTITIONS_RECORD_TYPE, Collections.singletonList(TestStructMapper.recordStructFrom(record))))).build();
    }

    private static Struct recordStructFrom(ChildPartitionsRecord record) {
        Value childPartitions = Value.structArray((Type)CHILD_PARTITION_TYPE, (Iterable)record.getChildPartitions().stream().map(TestStructMapper::childPartitionFrom).collect(Collectors.toList()));
        return ((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("start_timestamp").to(record.getStartTimestamp())).set("record_sequence").to(record.getRecordSequence())).set("child_partitions").to(childPartitions)).build();
    }

    private static Struct streamRecordStructFrom(HeartbeatRecord record, boolean useJsonFields) {
        Type dataChangeRecordType = useJsonFields ? DATA_CHANGE_RECORD_JSON_TYPE : DATA_CHANGE_RECORD_STRING_TYPE;
        return ((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("data_change_record").to(Value.structArray((Type)dataChangeRecordType, Collections.emptyList()))).set("heartbeat_record").to(Value.structArray((Type)HEARTBEAT_RECORD_TYPE, Collections.singletonList(TestStructMapper.recordStructFrom(record))))).set("child_partitions_record").to(Value.structArray((Type)CHILD_PARTITIONS_RECORD_TYPE, Collections.emptyList()))).build();
    }

    private static Struct recordStructFrom(HeartbeatRecord record) {
        return ((Struct.Builder)Struct.newBuilder().set("timestamp").to(record.getTimestamp())).build();
    }

    private static Struct streamRecordStructFrom(DataChangeRecord record, boolean useUnknownModType, boolean useUnknownValueCaptureType, boolean useJsonFields) {
        Type dataChangeRecordType = useJsonFields ? DATA_CHANGE_RECORD_JSON_TYPE : DATA_CHANGE_RECORD_STRING_TYPE;
        return ((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("data_change_record").to(Value.structArray((Type)dataChangeRecordType, Collections.singletonList(TestStructMapper.recordStructFrom(record, useUnknownModType, useUnknownValueCaptureType, useJsonFields))))).set("heartbeat_record").to(Value.structArray((Type)HEARTBEAT_RECORD_TYPE, Collections.emptyList()))).set("child_partitions_record").to(Value.structArray((Type)CHILD_PARTITIONS_RECORD_TYPE, Collections.emptyList()))).build();
    }

    private static Struct recordStructFrom(DataChangeRecord record, boolean useUnknownModType, boolean useUnknownValueCaptureType, boolean useJsonFields) {
        Value columnTypes = Value.structArray((Type)(useJsonFields ? COLUMN_TYPE_JSON_TYPE : COLUMN_TYPE_STRING_TYPE), (Iterable)record.getRowType().stream().map(rowType -> TestStructMapper.columnTypeStructFrom(rowType, useJsonFields)).collect(Collectors.toList()));
        Value mods = Value.structArray((Type)(useJsonFields ? MOD_JSON_TYPE : MOD_STRING_TYPE), (Iterable)record.getMods().stream().map(mod -> TestStructMapper.modStructFrom(mod, useJsonFields)).collect(Collectors.toList()));
        String modType = useUnknownModType ? "NEW_MOD_TYPE" : record.getModType().name();
        String valueCaptureType = useUnknownValueCaptureType ? "NEW_VALUE_CAPTURE_TYPE" : record.getValueCaptureType().name();
        return ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("commit_timestamp").to(record.getCommitTimestamp())).set("record_sequence").to(record.getRecordSequence())).set("server_transaction_id").to(record.getServerTransactionId())).set("is_last_record_in_transaction_in_partition").to(record.isLastRecordInTransactionInPartition())).set("table_name").to(record.getTableName())).set("column_types").to(columnTypes)).set("mods").to(mods)).set("mod_type").to(modType)).set("value_capture_type").to(valueCaptureType)).set("number_of_records_in_transaction").to(record.getNumberOfRecordsInTransaction())).set("number_of_partitions_in_transaction").to(record.getNumberOfPartitionsInTransaction())).build();
    }

    private static Struct columnTypeStructFrom(ColumnType columnType, boolean useJsonFields) {
        Value type = useJsonFields ? Value.json((String)columnType.getType().getCode()) : Value.string((String)columnType.getType().getCode());
        return ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("name").to(columnType.getName())).set("type").to(type)).set("is_primary_key").to(columnType.isPrimaryKey())).set("ordinal_position").to(columnType.getOrdinalPosition())).build();
    }

    private static Struct modStructFrom(Mod mod, boolean useJsonFields) {
        Value keys = useJsonFields ? Value.json((String)mod.getKeysJson()) : Value.string((String)mod.getKeysJson());
        Value newValues = useJsonFields ? Value.json((String)mod.getNewValuesJson()) : Value.string((String)mod.getNewValuesJson());
        Value oldValues = useJsonFields ? Value.json((String)mod.getOldValuesJson()) : Value.string((String)mod.getOldValuesJson());
        return ((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("keys").to(keys)).set("new_values").to(newValues)).set("old_values").to(oldValues)).build();
    }

    private static Struct childPartitionFrom(ChildPartition childPartition) {
        return ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("token").to(childPartition.getToken())).set("parent_partition_tokens").to(Value.stringArray((Iterable)childPartition.getParentTokens()))).build();
    }
}

