/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.util;

import com.google.cloud.Timestamp;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionMode;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionPosition;

public class PartitionPositionGenerator
extends Generator<PartitionPosition> {
    private static final long MIN_SECONDS = Timestamp.MIN_VALUE.getSeconds();
    private static final long MAX_SECONDS = Timestamp.MAX_VALUE.getSeconds();
    private static final int NANOS_PER_SECOND = (int)TimeUnit.SECONDS.toNanos(1L);
    private static final int TOTAL_TRANSITIONS = 3;

    public PartitionPositionGenerator() {
        super(PartitionPosition.class);
    }

    public PartitionPosition generate(SourceOfRandomness random, GenerationStatus status) {
        PartitionMode mode = PartitionMode.values()[random.nextInt(0, 4)];
        if (mode == PartitionMode.QUERY_CHANGE_STREAM) {
            long seconds = random.nextLong(MIN_SECONDS, MAX_SECONDS);
            int nanos = random.nextInt(0, NANOS_PER_SECOND);
            Timestamp timestamp = Timestamp.ofTimeSecondsAndNanos((long)seconds, (int)nanos);
            return new PartitionPosition(Optional.of(timestamp), mode);
        }
        return new PartitionPosition(Optional.empty(), mode);
    }
}

