/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import com.pholser.junit.quickcheck.From;
import com.pholser.junit.quickcheck.Property;
import com.pholser.junit.quickcheck.runner.JUnitQuickcheck;
import java.math.BigDecimal;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampUtils;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.util.TimestampGenerator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitQuickcheck.class)
public class TimestampUtilsTest {
    @Property
    public void testTimestampToNanosAlwaysReturnsZeroOrPositiveNumber(@From(value=TimestampGenerator.class) Timestamp timestamp) {
        Assert.assertTrue((TimestampUtils.toNanos((Timestamp)timestamp).signum() >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testToNanosConvertTimestampMin() {
        Assert.assertEquals((Object)BigDecimal.valueOf(0L), (Object)TimestampUtils.toNanos((Timestamp)Timestamp.MIN_VALUE));
    }

    @Test
    public void testToNanosConvertTimestampMaxToNanos() {
        Assert.assertEquals((Object)new BigDecimal("315537897599999999999"), (Object)TimestampUtils.toNanos((Timestamp)Timestamp.MAX_VALUE));
    }

    @Test
    public void testToNanosConvertTimestampToNanos() {
        Assert.assertEquals((Object)new BigDecimal("62135596810000000009"), (Object)TimestampUtils.toNanos((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)9)));
    }

    @Test
    public void testToTimestampConvertNanosToTimestampMin() {
        Assert.assertEquals((Object)Timestamp.MIN_VALUE, (Object)TimestampUtils.toTimestamp((BigDecimal)BigDecimal.valueOf(0L)));
    }

    @Test
    public void testToTimestampConvertNanosToTimestampMax() {
        Assert.assertEquals((Object)Timestamp.MAX_VALUE, (Object)TimestampUtils.toTimestamp((BigDecimal)new BigDecimal("315537897599999999999")));
    }

    @Test
    public void testToTimestampConvertNanosToTimestamp() {
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)9), (Object)TimestampUtils.toTimestamp((BigDecimal)new BigDecimal("62135596810000000009")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testToTimestampThrowsExceptionWhenThereIsAnUnderflow() {
        TimestampUtils.toTimestamp((BigDecimal)BigDecimal.valueOf(-1L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testToTimestampThrowsExceptionWhenThereIsAnOverflow() {
        TimestampUtils.toTimestamp((BigDecimal)new BigDecimal("315537897600000000000"));
    }

    @Test
    public void testNextReturnsMaxWhenTimestampIsAlreadyMax() {
        Assert.assertEquals((Object)Timestamp.MAX_VALUE, (Object)TimestampUtils.next((Timestamp)Timestamp.MAX_VALUE));
    }

    @Test
    public void testNextIncrementsNanosWhenPossible() {
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)999999999), (Object)TimestampUtils.next((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)999999998)));
    }

    @Test
    public void testNextIncrementsSecondsWhenNanosOverflow() {
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)11L, (int)0), (Object)TimestampUtils.next((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)999999999)));
    }

    @Test
    public void testPreviousReturnsMinWhenTimestampIsAlreadyMin() {
        Assert.assertEquals((Object)Timestamp.MIN_VALUE, (Object)TimestampUtils.previous((Timestamp)Timestamp.MIN_VALUE));
    }

    @Test
    public void testPreviousDecrementsNanosWhenPossible() {
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)0), (Object)TimestampUtils.previous((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)1)));
    }

    @Test
    public void testPreviousDecrementsSecondsWhenNanosUnderflow() {
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)9L, (int)999999999), (Object)TimestampUtils.previous((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)0)));
    }
}

