/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import com.pholser.junit.quickcheck.From;
import com.pholser.junit.quickcheck.Property;
import com.pholser.junit.quickcheck.runner.JUnitQuickcheck;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRangeTracker;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampUtils;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.util.TimestampGenerator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitQuickcheck.class)
public class TimestampRangeTrackerTest {
    private static final double DELTA = 1.0E-10;

    @Property
    public void testTryClaimReturnsTrueWhenPositionIsWithinTheRange(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=TimestampGenerator.class) Timestamp position) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThanOrEqualTo((Comparable)to));
        Assume.assumeThat((Object)position, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)from));
        Assume.assumeThat((Object)position, (Matcher)Matchers.lessThan((Comparable)to));
        TimestampRange range = TimestampRange.of((Timestamp)from, (Timestamp)to);
        TimestampRangeTracker tracker = new TimestampRangeTracker(range);
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        Assert.assertEquals((Object)position, (Object)tracker.lastAttemptedPosition);
        Assert.assertEquals((Object)position, (Object)tracker.lastClaimedPosition);
    }

    @Property
    public void testTryClaimReturnsFalseWhenPositionIsGreaterOrEqualToTheEndOfTheRange(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=TimestampGenerator.class) Timestamp position) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThanOrEqualTo((Comparable)to));
        Assume.assumeThat((Object)position, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)to));
        TimestampRange range = TimestampRange.of((Timestamp)from, (Timestamp)to);
        TimestampRangeTracker tracker = new TimestampRangeTracker(range);
        Assert.assertFalse((boolean)tracker.tryClaim(position));
        Assert.assertEquals((Object)position, (Object)tracker.lastAttemptedPosition);
        Assert.assertNull((Object)tracker.lastClaimedPosition);
    }

    @Test
    public void testTryClaimFailsWhenPositionIsLessThanPreviousClaim() {
        Timestamp from = Timestamp.ofTimeMicroseconds((long)0L);
        Timestamp to = Timestamp.ofTimeMicroseconds((long)10L);
        Timestamp position = Timestamp.ofTimeMicroseconds((long)5L);
        Timestamp nextPosition = Timestamp.ofTimeMicroseconds((long)3L);
        TimestampRange range = TimestampRange.of((Timestamp)from, (Timestamp)to);
        TimestampRangeTracker tracker = new TimestampRangeTracker(range);
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        Assert.assertThrows(IllegalArgumentException.class, () -> tracker.tryClaim(nextPosition));
        Assert.assertEquals((Object)position, (Object)tracker.lastAttemptedPosition);
        Assert.assertEquals((Object)position, (Object)tracker.lastClaimedPosition);
    }

    @Test
    public void testTryClaimFailsWhenPositionIsLessThanTheBeginningOfTheRange() {
        Timestamp from = Timestamp.ofTimeMicroseconds((long)5L);
        Timestamp to = Timestamp.ofTimeMicroseconds((long)10L);
        Timestamp position = Timestamp.ofTimeMicroseconds((long)4L);
        TimestampRange range = TimestampRange.of((Timestamp)from, (Timestamp)to);
        TimestampRangeTracker tracker = new TimestampRangeTracker(range);
        Assert.assertThrows(IllegalArgumentException.class, () -> tracker.tryClaim(position));
    }

    @Property
    public void testTrySplitReturnsSplitWhenNoPositionWasClaimed(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThanOrEqualTo((Comparable)to));
        TimestampRange range = TimestampRange.of((Timestamp)from, (Timestamp)to);
        TimestampRangeTracker tracker = new TimestampRangeTracker(range);
        SplitResult splitResult = tracker.trySplit(0.0);
        TimestampRange primary = (TimestampRange)splitResult.getPrimary();
        TimestampRange residual = (TimestampRange)splitResult.getResidual();
        Assert.assertEquals((Object)TimestampRange.of((Timestamp)from, (Timestamp)from), (Object)primary);
        Assert.assertEquals((Object)TimestampRange.of((Timestamp)from, (Timestamp)to), (Object)residual);
        Assert.assertEquals((Object)primary, (Object)tracker.range);
    }

    @Property
    public void testTrySplitReturnsSplitWhenAPositionIsClaimedAndFractionOfRemainderIsZero(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=TimestampGenerator.class) Timestamp position) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThanOrEqualTo((Comparable)to));
        Assume.assumeThat((Object)position, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)from));
        Assume.assumeThat((Object)position, (Matcher)Matchers.lessThan((Comparable)to));
        TimestampRange range = TimestampRange.of((Timestamp)from, (Timestamp)to);
        TimestampRangeTracker tracker = new TimestampRangeTracker(range);
        tracker.tryClaim(position);
        SplitResult splitResult = tracker.trySplit(0.0);
        TimestampRange primary = (TimestampRange)splitResult.getPrimary();
        TimestampRange residual = (TimestampRange)splitResult.getResidual();
        Timestamp nextPosition = TimestampUtils.next((Timestamp)position);
        Assert.assertEquals((Object)TimestampRange.of((Timestamp)from, (Timestamp)nextPosition), (Object)primary);
        Assert.assertEquals((Object)TimestampRange.of((Timestamp)nextPosition, (Timestamp)to), (Object)residual);
        Assert.assertEquals((Object)primary, (Object)tracker.range);
    }

    @Property
    public void testTrySplitReturnsNullWhenAPositionIsGreaterThanTheEndOfTheRange(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=TimestampGenerator.class) Timestamp position) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThanOrEqualTo((Comparable)to));
        Assume.assumeThat((Object)position, (Matcher)Matchers.greaterThan((Comparable)to));
        TimestampRange range = TimestampRange.of((Timestamp)from, (Timestamp)to);
        TimestampRangeTracker tracker = new TimestampRangeTracker(range);
        tracker.tryClaim(position);
        SplitResult splitResult = tracker.trySplit(0.0);
        Assert.assertNull((Object)splitResult);
    }

    @Test
    public void testCheckDoneSucceedsWhenFromIsEqualToTheEndOfTheRange() {
        Timestamp from = Timestamp.ofTimeMicroseconds((long)10L);
        TimestampRange range = TimestampRange.of((Timestamp)from, (Timestamp)from);
        TimestampRangeTracker tracker = new TimestampRangeTracker(range);
        tracker.checkDone();
    }

    @Test
    public void testCheckDoneSucceedsWhenClaimingTheEndOfTheRangeHasBeenAttempted() {
        Timestamp from = Timestamp.ofTimeMicroseconds((long)10L);
        Timestamp to = Timestamp.ofTimeMicroseconds((long)50L);
        TimestampRange range = TimestampRange.of((Timestamp)from, (Timestamp)to);
        TimestampRangeTracker tracker = new TimestampRangeTracker(range);
        tracker.tryClaim(to);
        tracker.checkDone();
    }

    @Test
    public void testCheckDoneSucceedsWhenClaimingPastTheEndOfTheRangeHasBeenAttempted() {
        Timestamp from = Timestamp.ofTimeMicroseconds((long)10L);
        Timestamp to = Timestamp.ofTimeMicroseconds((long)50L);
        TimestampRange range = TimestampRange.of((Timestamp)from, (Timestamp)to);
        TimestampRangeTracker tracker = new TimestampRangeTracker(range);
        tracker.tryClaim(Timestamp.ofTimeMicroseconds((long)51L));
        tracker.checkDone();
    }

    @Test
    public void testCheckDoneFailsWhenNoClaimHasBeenMade() {
        Timestamp from = Timestamp.ofTimeMicroseconds((long)10L);
        Timestamp to = Timestamp.ofTimeMicroseconds((long)50L);
        TimestampRange range = TimestampRange.of((Timestamp)from, (Timestamp)to);
        TimestampRangeTracker tracker = new TimestampRangeTracker(range);
        Assert.assertThrows(IllegalStateException.class, () -> ((TimestampRangeTracker)tracker).checkDone());
    }

    @Property
    public void testCheckDoneFailsWhenClaimingTheEndOfTheRangeHasNotBeenAttempted(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=TimestampGenerator.class) Timestamp position) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)position, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)from));
        Assume.assumeThat((Object)position, (Matcher)Matchers.lessThan((Comparable)to));
        TimestampRange range = TimestampRange.of((Timestamp)from, (Timestamp)to);
        TimestampRangeTracker tracker = new TimestampRangeTracker(range);
        tracker.tryClaim(position);
        Assert.assertThrows(IllegalStateException.class, () -> ((TimestampRangeTracker)tracker).checkDone());
    }

    @Property
    public void testGetProgressWorkCompletedAndWorkRemaining(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=TimestampGenerator.class) Timestamp position) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0)));
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThanOrEqualTo((Comparable)to));
        Assume.assumeThat((Object)position, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)from));
        Assume.assumeThat((Object)position, (Matcher)Matchers.lessThan((Comparable)to));
        TimestampRange range = TimestampRange.of((Timestamp)from, (Timestamp)to);
        TimestampRangeTracker tracker = new TimestampRangeTracker(range);
        tracker.tryClaim(position);
        RestrictionTracker.Progress progress = tracker.getProgress();
        Assert.assertEquals((double)position.getSeconds(), (double)progress.getWorkCompleted(), (double)1.0E-10);
        Assert.assertEquals((double)(to.getSeconds() - position.getSeconds()), (double)progress.getWorkRemaining(), (double)1.0E-10);
    }

    @Test
    public void testGetProgressReturnsWorkRemainingAsWholeRangeWhenNoClaimWasAttempted() {
        Timestamp from = Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0);
        Timestamp to = Timestamp.now();
        TimestampRange range = TimestampRange.of((Timestamp)from, (Timestamp)to);
        TimestampRangeTracker tracker = new TimestampRangeTracker(range);
        RestrictionTracker.Progress progress = tracker.getProgress();
        Assert.assertEquals((double)0.0, (double)progress.getWorkCompleted(), (double)1.0E-10);
        Assert.assertEquals((double)to.getSeconds(), (double)progress.getWorkRemaining(), (double)1.0E-10);
    }

    @Test
    public void testGetProgressReturnsWorkRemainingAsRangeEndMinusAttemptedPosition() {
        Timestamp from = Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0);
        Timestamp to = Timestamp.ofTimeSecondsAndNanos((long)100L, (int)0);
        Timestamp position = Timestamp.ofTimeSecondsAndNanos((long)30L, (int)0);
        TimestampRange range = TimestampRange.of((Timestamp)from, (Timestamp)to);
        TimestampRangeTracker tracker = new TimestampRangeTracker(range);
        tracker.tryClaim(position);
        RestrictionTracker.Progress progress = tracker.getProgress();
        Assert.assertTrue((progress.getWorkCompleted() >= 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)30.0, (double)progress.getWorkCompleted(), (double)1.0E-10);
        Assert.assertTrue((progress.getWorkRemaining() >= 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)70.0, (double)progress.getWorkRemaining(), (double)1.0E-10);
    }

    @Test
    public void testGetProgressReturnsWorkCompletedWhenRangeEndHasBeenAttempted() {
        Timestamp from = Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0);
        Timestamp to = Timestamp.ofTimeSecondsAndNanos((long)101L, (int)0);
        TimestampRange range = TimestampRange.of((Timestamp)from, (Timestamp)to);
        TimestampRangeTracker tracker = new TimestampRangeTracker(range);
        tracker.tryClaim(Timestamp.ofTimeSecondsAndNanos((long)100L, (int)0));
        tracker.tryClaim(Timestamp.ofTimeSecondsAndNanos((long)101L, (int)0));
        RestrictionTracker.Progress progress = tracker.getProgress();
        Assert.assertTrue((progress.getWorkCompleted() >= 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)100.0, (double)progress.getWorkCompleted(), (double)1.0E-10);
        Assert.assertTrue((progress.getWorkRemaining() >= 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)1.0, (double)progress.getWorkRemaining(), (double)1.0E-10);
    }

    @Test
    public void testGetProgressReturnsWorkCompletedWhenPastRangeEndHasBeenAttempted() {
        Timestamp from = Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0);
        Timestamp to = Timestamp.ofTimeSecondsAndNanos((long)101L, (int)0);
        Timestamp position = Timestamp.ofTimeSecondsAndNanos((long)101L, (int)0);
        TimestampRange range = TimestampRange.of((Timestamp)from, (Timestamp)to);
        TimestampRangeTracker tracker = new TimestampRangeTracker(range);
        tracker.tryClaim(position);
        RestrictionTracker.Progress progress = tracker.getProgress();
        Assert.assertTrue((progress.getWorkCompleted() >= 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)progress.getWorkCompleted(), (double)1.0E-10);
        Assert.assertTrue((progress.getWorkRemaining() >= 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)101.0, (double)progress.getWorkRemaining(), (double)1.0E-10);
    }

    @Test
    public void testGetProgressForStreaming() {
        Timestamp from = Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0);
        Timestamp position = Timestamp.ofTimeSecondsAndNanos((long)101L, (int)0);
        TimestampRange range = TimestampRange.of((Timestamp)from, (Timestamp)Timestamp.MAX_VALUE);
        TimestampRangeTracker tracker = new TimestampRangeTracker(range);
        tracker.setTimeSupplier(() -> Timestamp.ofTimeSecondsAndNanos((long)(position.getSeconds() + 10L), (int)0));
        tracker.tryClaim(position);
        RestrictionTracker.Progress progress = tracker.getProgress();
        Assert.assertTrue((progress.getWorkCompleted() >= 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)101.0, (double)progress.getWorkCompleted(), (double)1.0E-10);
        Assert.assertTrue((progress.getWorkRemaining() >= 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)10.0, (double)progress.getWorkRemaining(), (double)1.0E-10);
    }
}

