/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.ThroughputEstimator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ThroughputEstimatorTest {
    private static final double DELTA = 1.0E-10;
    private ThroughputEstimator estimator;

    @Before
    public void setup() {
        this.estimator = new ThroughputEstimator();
    }

    @Test
    public void testThroughputCalculation() {
        this.estimator.update(Timestamp.ofTimeSecondsAndNanos((long)20L, (int)0), 10L);
        this.estimator.update(Timestamp.ofTimeSecondsAndNanos((long)30L, (int)0), 20L);
        this.estimator.update(Timestamp.ofTimeSecondsAndNanos((long)59L, (int)0), 30L);
        this.estimator.update(Timestamp.ofTimeSecondsAndNanos((long)60L, (int)0), 40L);
        Assert.assertEquals((double)20.0, (double)this.estimator.getFrom(Timestamp.ofTimeSecondsAndNanos((long)61L, (int)0)), (double)1.0E-10);
        this.estimator.update(Timestamp.ofTimeSecondsAndNanos((long)100L, (int)0), 10L);
        this.estimator.update(Timestamp.ofTimeSecondsAndNanos((long)110L, (int)0), 20L);
        this.estimator.update(Timestamp.ofTimeSecondsAndNanos((long)110L, (int)0), 10L);
        this.estimator.update(Timestamp.ofTimeSecondsAndNanos((long)140L, (int)0), 40L);
        Assert.assertEquals((double)20.0, (double)this.estimator.getFrom(Timestamp.ofTimeSecondsAndNanos((long)141L, (int)0)), (double)1.0E-10);
        this.estimator.update(Timestamp.ofTimeSecondsAndNanos((long)201L, (int)0), 10L);
        this.estimator.update(Timestamp.ofTimeSecondsAndNanos((long)250L, (int)0), 40L);
        Assert.assertEquals((double)10.0, (double)this.estimator.getFrom(Timestamp.ofTimeSecondsAndNanos((long)261L, (int)0)), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)this.estimator.getFrom(Timestamp.ofTimeSecondsAndNanos((long)350L, (int)0)), (double)1.0E-10);
    }

    @Test
    public void testThroughputIsAccumulatedWithin60SecondsWindow() {
        List<ImmutablePair<Timestamp, Long>> pairs = this.generateTestData(100, 0, 60, Long.MAX_VALUE);
        pairs.sort((a, b) -> ((Timestamp)a.getLeft()).compareTo((Timestamp)b.getLeft()));
        long count = pairs.stream().map(ImmutablePair::getLeft).distinct().count();
        BigDecimal sum = BigDecimal.valueOf(0L);
        for (ImmutablePair<Timestamp, Long> pair : pairs) {
            sum = sum.add(BigDecimal.valueOf((Long)pair.getRight()));
        }
        BigDecimal want = sum.divide(BigDecimal.valueOf(count), MathContext.DECIMAL128);
        for (int i = 0; i < pairs.size(); ++i) {
            this.estimator.update((Timestamp)pairs.get(i).getLeft(), ((Long)pairs.get(i).getRight()).longValue());
        }
        this.estimator.update(Timestamp.ofTimeSecondsAndNanos((long)60L, (int)0), 10L);
        double actual = this.estimator.getFrom(Timestamp.ofTimeSecondsAndNanos((long)60L, (int)0));
        Assert.assertEquals((double)want.doubleValue(), (double)actual, (double)1.0E-10);
    }

    @Test
    public void testThroughputIsAccumulatedWithin300SecondsWindow() {
        List<ImmutablePair<Timestamp, Long>> excludedPairs = this.generateTestData(300, 0, 240, Long.MAX_VALUE);
        List<ImmutablePair<Timestamp, Long>> expectedPairs = this.generateTestData(50, 240, 300, Long.MAX_VALUE);
        List pairs = Stream.concat(excludedPairs.stream(), expectedPairs.stream()).collect(Collectors.toList());
        pairs.sort((a, b) -> ((Timestamp)a.getLeft()).compareTo((Timestamp)b.getLeft()));
        long count = expectedPairs.stream().map(ImmutablePair::getLeft).distinct().count();
        BigDecimal sum = BigDecimal.valueOf(0L);
        for (ImmutablePair<Timestamp, Long> pair : expectedPairs) {
            sum = sum.add(BigDecimal.valueOf((Long)pair.getRight()));
        }
        BigDecimal want = sum.divide(BigDecimal.valueOf(count), MathContext.DECIMAL128);
        for (int i = 0; i < pairs.size(); ++i) {
            this.estimator.update((Timestamp)((ImmutablePair)pairs.get(i)).getLeft(), ((Long)((ImmutablePair)pairs.get(i)).getRight()).longValue());
        }
        this.estimator.update(Timestamp.ofTimeSecondsAndNanos((long)300L, (int)0), 10L);
        double actual = this.estimator.getFrom(Timestamp.ofTimeSecondsAndNanos((long)300L, (int)0));
        Assert.assertEquals((double)want.doubleValue(), (double)actual, (double)1.0E-10);
    }

    @Test
    public void testThroughputShouldNotBeNegative() {
        this.estimator.update(Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0), -10L);
        this.estimator.update(Timestamp.ofTimeSecondsAndNanos((long)1L, (int)0), 10L);
        double actual = this.estimator.getFrom(Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0));
        Assert.assertEquals((double)0.0, (double)actual, (double)1.0E-10);
    }

    private List<ImmutablePair<Timestamp, Long>> generateTestData(int size, int startSeconds, int endSeconds, long maxBytes) {
        Random random = new Random();
        ArrayList<ImmutablePair<Timestamp, Long>> pairs = new ArrayList<ImmutablePair<Timestamp, Long>>();
        for (int i = 0; i < size; ++i) {
            int seconds = random.nextInt(endSeconds - startSeconds) + startSeconds;
            pairs.add((ImmutablePair<Timestamp, Long>)new ImmutablePair((Object)Timestamp.ofTimeSecondsAndNanos((long)seconds, (int)0), (Object)ThreadLocalRandom.current().nextLong(maxBytes)));
        }
        return pairs;
    }
}

