/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.ReadChangeStreamPartitionRangeTracker;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ReadChangeStreamPartitionRangeTrackerTest {
    private PartitionMetadata partition;
    private TimestampRange range;
    private ReadChangeStreamPartitionRangeTracker tracker;

    @Before
    public void setUp() throws Exception {
        this.partition = (PartitionMetadata)Mockito.mock(PartitionMetadata.class);
        this.range = TimestampRange.of((Timestamp)Timestamp.ofTimeMicroseconds((long)10L), (Timestamp)Timestamp.ofTimeMicroseconds((long)20L));
        this.tracker = new ReadChangeStreamPartitionRangeTracker(this.partition, this.range);
    }

    @Test
    public void testTryClaim() {
        Assert.assertEquals((Object)this.range, (Object)this.tracker.currentRestriction());
        Assert.assertTrue((boolean)this.tracker.tryClaim(Timestamp.ofTimeMicroseconds((long)10L)));
        Assert.assertTrue((boolean)this.tracker.tryClaim(Timestamp.ofTimeMicroseconds((long)10L)));
        Assert.assertTrue((boolean)this.tracker.tryClaim(Timestamp.ofTimeMicroseconds((long)11L)));
        Assert.assertTrue((boolean)this.tracker.tryClaim(Timestamp.ofTimeMicroseconds((long)11L)));
        Assert.assertTrue((boolean)this.tracker.tryClaim(Timestamp.ofTimeMicroseconds((long)19L)));
        Assert.assertFalse((boolean)this.tracker.tryClaim(Timestamp.ofTimeMicroseconds((long)20L)));
    }

    @Test
    public void testTrySplitReturnsNullForInitialPartition() {
        Mockito.when((Object)this.partition.getPartitionToken()).thenReturn((Object)"Parent0");
        Assert.assertNull((Object)this.tracker.trySplit(0.0));
    }
}

