/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import com.pholser.junit.quickcheck.From;
import com.pholser.junit.quickcheck.Property;
import com.pholser.junit.quickcheck.runner.JUnitQuickcheck;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionMode;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionPosition;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestriction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestrictionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestrictionTracker;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampUtils;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.util.PartitionPositionGenerator;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.util.TimestampGenerator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.runner.RunWith;

@RunWith(value=JUnitQuickcheck.class)
public class PartitionRestrictionTrackerTest {
    private static final String PARTITION_TOKEN = "partitionToken";
    private static final double DELTA = 1.0E-10;

    @Property
    public void testTrySplitReturnsNullhenNoPositionWasClaimed(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThanOrEqualTo((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)from, (Timestamp)to);
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        SplitResult splitResult = tracker.trySplit(0.0);
        Assert.assertEquals(null, (Object)splitResult);
    }

    @Property
    public void testCheckDoneFailsWhenNoPositionClaimed(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)from, (Timestamp)to);
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        Assert.assertThrows(IllegalStateException.class, () -> ((PartitionRestrictionTracker)tracker).checkDone());
    }

    @Property
    public void testTryClaimPositionUpdateStateToUpdateState(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=PartitionPositionGenerator.class) PartitionPosition position) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)position.getMode(), (Matcher)Matchers.equalTo((Object)PartitionMode.UPDATE_STATE));
        PartitionRestriction restriction = PartitionRestriction.updateState((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        Assert.assertEquals((Object)position, (Object)tracker.getLastClaimedPosition());
    }

    @Property
    public void testTryClaimPositionUpdateStateToQueryChangeStream(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=PartitionPositionGenerator.class) PartitionPosition position) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)position.getMode(), (Matcher)Matchers.equalTo((Object)PartitionMode.QUERY_CHANGE_STREAM));
        Assume.assumeThat((Object)((Timestamp)position.getTimestamp().get()), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)from));
        Assume.assumeThat((Object)((Timestamp)position.getTimestamp().get()), (Matcher)Matchers.lessThan((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.updateState((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        Assert.assertEquals((Object)position, (Object)tracker.getLastClaimedPosition());
    }

    @Property
    public void testTryClaimPositionUpdateStateToOtherModes(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=PartitionPositionGenerator.class) PartitionPosition position) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)position.getMode(), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)PartitionMode.WAIT_FOR_CHILD_PARTITIONS), (Matcher)Matchers.equalTo((Object)PartitionMode.DONE), (Matcher)Matchers.equalTo((Object)PartitionMode.STOP)));
        PartitionRestriction restriction = PartitionRestriction.updateState((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        Assert.assertThrows(IllegalArgumentException.class, () -> tracker.tryClaim(position));
    }

    @Property
    public void testTrySplitReturnsQueryChangeStreamhenUpdateStateClaimed(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThanOrEqualTo((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.updateState((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        PartitionPosition position = PartitionPosition.updateState();
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        SplitResult splitResult = tracker.trySplit(0.0);
        PartitionRestriction primary = (PartitionRestriction)splitResult.getPrimary();
        PartitionRestriction residual = (PartitionRestriction)splitResult.getResidual();
        Assert.assertEquals((Object)PartitionRestriction.stop((PartitionRestriction)restriction), (Object)primary);
        Assert.assertEquals((Object)PartitionRestriction.queryChangeStream((Timestamp)from, (Timestamp)to), (Object)residual);
        Assert.assertEquals((Object)primary, (Object)tracker.restriction);
    }

    @Property
    public void testCheckDoneFailsWithUpdateState(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.updateState((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        PartitionPosition position = PartitionPosition.updateState();
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        Assert.assertThrows(IllegalStateException.class, () -> ((PartitionRestrictionTracker)tracker).checkDone());
    }

    @Property
    public void testTryClaimReturnsTrueWhenPositionIsWithinTheRange(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=TimestampGenerator.class) Timestamp curTimestamp) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)curTimestamp, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)from));
        Assume.assumeThat((Object)curTimestamp, (Matcher)Matchers.lessThan((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        PartitionPosition position = new PartitionPosition(Optional.of(curTimestamp), PartitionMode.QUERY_CHANGE_STREAM);
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        Assert.assertEquals((Object)position, (Object)tracker.getLastClaimedPosition());
    }

    @Property
    public void testTryClaimReturnsFalseWhenPositionIsGreaterThanRange(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=TimestampGenerator.class) Timestamp curTimestamp) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)curTimestamp, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)from));
        Assume.assumeThat((Object)curTimestamp, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        PartitionPosition position = new PartitionPosition(Optional.of(curTimestamp), PartitionMode.QUERY_CHANGE_STREAM);
        Assert.assertFalse((boolean)tracker.tryClaim(position));
        Assert.assertEquals(null, (Object)tracker.getLastClaimedPosition());
    }

    @Property
    public void testTryClaimThrowsErrorWhenPositionBeforeRange(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=TimestampGenerator.class) Timestamp curTimestamp) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)curTimestamp, (Matcher)Matchers.lessThan((Comparable)from));
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        PartitionPosition position = new PartitionPosition(Optional.of(curTimestamp), PartitionMode.QUERY_CHANGE_STREAM);
        Assert.assertThrows(IllegalArgumentException.class, () -> tracker.tryClaim(position));
    }

    @Property
    public void testTryClaimPositionGreaterThanOrEqualToPreviousPosition(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=TimestampGenerator.class) Timestamp curTimestamp, @From(value=TimestampGenerator.class) Timestamp nextTimestamp) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)curTimestamp, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)from));
        Assume.assumeThat((Object)nextTimestamp, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)curTimestamp));
        Assume.assumeThat((Object)nextTimestamp, (Matcher)Matchers.lessThan((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        PartitionPosition position = new PartitionPosition(Optional.of(curTimestamp), PartitionMode.QUERY_CHANGE_STREAM);
        PartitionPosition nextPosition = new PartitionPosition(Optional.of(nextTimestamp), PartitionMode.QUERY_CHANGE_STREAM);
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        Assert.assertEquals((Object)position, (Object)tracker.getLastClaimedPosition());
        Assert.assertTrue((boolean)tracker.tryClaim(nextPosition));
        Assert.assertEquals((Object)nextPosition, (Object)tracker.getLastClaimedPosition());
    }

    @Property
    public void testTryClaimPositionLessThanPreviousPosition(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=TimestampGenerator.class) Timestamp prevTimestamp, @From(value=TimestampGenerator.class) Timestamp curTimestamp) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)prevTimestamp, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)from));
        Assume.assumeThat((Object)prevTimestamp, (Matcher)Matchers.lessThan((Comparable)curTimestamp));
        Assume.assumeThat((Object)curTimestamp, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)from));
        Assume.assumeThat((Object)curTimestamp, (Matcher)Matchers.lessThan((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        PartitionPosition position = new PartitionPosition(Optional.of(curTimestamp), PartitionMode.QUERY_CHANGE_STREAM);
        PartitionPosition prevPosition = new PartitionPosition(Optional.of(prevTimestamp), PartitionMode.QUERY_CHANGE_STREAM);
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        Assert.assertEquals((Object)position, (Object)tracker.getLastClaimedPosition());
        Assert.assertThrows(IllegalArgumentException.class, () -> tracker.tryClaim(prevPosition));
    }

    @Property
    public void testTryClaimPositionQueryChangeStreamToWaitForChildPartitions(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=PartitionPositionGenerator.class) PartitionPosition position) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)position.getMode(), (Matcher)Matchers.equalTo((Object)PartitionMode.WAIT_FOR_CHILD_PARTITIONS));
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        Assert.assertEquals((Object)position, (Object)tracker.getLastClaimedPosition());
    }

    @Property
    public void testTryClaimPositionQueryChangeStreamToOtherModes(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=PartitionPositionGenerator.class) PartitionPosition position) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)position.getMode(), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)PartitionMode.UPDATE_STATE), (Matcher)Matchers.equalTo((Object)PartitionMode.STOP), (Matcher)Matchers.equalTo((Object)PartitionMode.STOP)));
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        Assert.assertThrows(IllegalArgumentException.class, () -> tracker.tryClaim(position));
    }

    @Property
    public void testTrySplitQueryChangeStreamTimestampWithinRange(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=TimestampGenerator.class) Timestamp curTimestamp) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)curTimestamp, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)from));
        Assume.assumeThat((Object)curTimestamp, (Matcher)Matchers.lessThan((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        PartitionPosition position = PartitionPosition.queryChangeStream((Timestamp)curTimestamp);
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        SplitResult splitResult = tracker.trySplit(0.0);
        PartitionRestriction primary = (PartitionRestriction)splitResult.getPrimary();
        PartitionRestriction residual = (PartitionRestriction)splitResult.getResidual();
        Assert.assertEquals((Object)PartitionRestriction.queryChangeStream((Timestamp)from, (Timestamp)TimestampUtils.next((Timestamp)curTimestamp)), (Object)primary);
        Assert.assertEquals((Object)PartitionRestriction.queryChangeStream((Timestamp)TimestampUtils.next((Timestamp)curTimestamp), (Timestamp)to), (Object)residual);
        Assert.assertEquals((Object)primary, (Object)tracker.restriction);
    }

    @Property
    public void testTrySplitQueryChangeStreamTimestampEndOfRange(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)from, (Timestamp)TimestampUtils.next((Timestamp)to)).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        PartitionPosition position = PartitionPosition.queryChangeStream((Timestamp)to);
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        SplitResult splitResult = tracker.trySplit(0.0);
        PartitionRestriction primary = (PartitionRestriction)splitResult.getPrimary();
        PartitionRestriction residual = (PartitionRestriction)splitResult.getResidual();
        Assert.assertEquals((Object)PartitionRestriction.stop((PartitionRestriction)restriction), (Object)primary);
        Assert.assertEquals((Object)PartitionRestriction.waitForChildPartitions((Timestamp)from, (Timestamp)TimestampUtils.next((Timestamp)to)), (Object)residual);
        Assert.assertEquals((Object)primary, (Object)tracker.restriction);
    }

    @Property
    public void testCheckDoneFailsNotAtEndOfRange(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)from, (Timestamp)TimestampUtils.next((Timestamp)to)).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        PartitionPosition position = PartitionPosition.queryChangeStream((Timestamp)from);
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        Assert.assertThrows(IllegalStateException.class, () -> ((PartitionRestrictionTracker)tracker).checkDone());
    }

    @Property
    public void testCheckDoneSucceedsAtEndOfRange(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)from, (Timestamp)TimestampUtils.next((Timestamp)to)).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        PartitionPosition position = PartitionPosition.queryChangeStream((Timestamp)to);
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        tracker.checkDone();
    }

    @Property
    public void testTryClaimPositionWaitForChildPartitions(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=PartitionPositionGenerator.class) PartitionPosition position) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)position.getMode(), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)PartitionMode.WAIT_FOR_CHILD_PARTITIONS), (Matcher)Matchers.equalTo((Object)PartitionMode.DONE)));
        PartitionRestriction restriction = PartitionRestriction.waitForChildPartitions((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        Assert.assertEquals((Object)position, (Object)tracker.getLastClaimedPosition());
    }

    @Property
    public void testTryClaimPositionWaitForChildPartitionsToInvalidStates(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=PartitionPositionGenerator.class) PartitionPosition position) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)position.getMode(), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)PartitionMode.UPDATE_STATE), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)PartitionMode.QUERY_CHANGE_STREAM), (Matcher)Matchers.equalTo((Object)PartitionMode.STOP))));
        PartitionRestriction restriction = PartitionRestriction.waitForChildPartitions((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        Assert.assertThrows(IllegalArgumentException.class, () -> tracker.tryClaim(position));
    }

    @Property
    public void testTrySplitWaitForChildPartitions(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.waitForChildPartitions((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        PartitionPosition position = PartitionPosition.waitForChildPartitions();
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        SplitResult splitResult = tracker.trySplit(0.0);
        PartitionRestriction primary = (PartitionRestriction)splitResult.getPrimary();
        PartitionRestriction residual = (PartitionRestriction)splitResult.getResidual();
        Assert.assertEquals((Object)PartitionRestriction.stop((PartitionRestriction)restriction), (Object)primary);
        Assert.assertEquals((Object)PartitionRestriction.waitForChildPartitions((Timestamp)from, (Timestamp)to), (Object)residual);
        Assert.assertEquals((Object)primary, (Object)tracker.restriction);
    }

    @Property
    public void testCheckDoneWaitForChildPartitions(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.waitForChildPartitions((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        PartitionPosition position = PartitionPosition.waitForChildPartitions();
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        Assert.assertThrows(IllegalStateException.class, () -> ((PartitionRestrictionTracker)tracker).checkDone());
    }

    @Property
    public void testTryClaimPositionDone(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=PartitionPositionGenerator.class) PartitionPosition position) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.done((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        Assert.assertThrows(IllegalArgumentException.class, () -> tracker.tryClaim(position));
    }

    @Property
    public void testTrySplitClaimedDone(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.waitForChildPartitions((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        PartitionPosition position = PartitionPosition.done();
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        SplitResult splitResult = tracker.trySplit(0.0);
        Assert.assertEquals(null, (Object)splitResult);
    }

    @Property
    public void testCheckDoneSucceedsWithDone(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.waitForChildPartitions((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        PartitionPosition position = PartitionPosition.done();
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        tracker.checkDone();
    }

    @Property
    public void testTryClaimPositionStop(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=PartitionPositionGenerator.class) PartitionPosition position) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.waitForChildPartitions((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestriction stoppedRestriction = PartitionRestriction.stop((PartitionRestriction)restriction);
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(stoppedRestriction);
        Assert.assertFalse((boolean)tracker.tryClaim(position));
    }

    @Property
    public void testTrySplitStop(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.waitForChildPartitions((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestriction stoppedRestriction = PartitionRestriction.stop((PartitionRestriction)restriction);
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(stoppedRestriction);
        SplitResult splitResult = tracker.trySplit(0.0);
        Assert.assertEquals(null, (Object)splitResult);
    }

    @Property
    public void testCheckDoneSucceedsWithStop(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        PartitionRestriction restriction = PartitionRestriction.waitForChildPartitions((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestriction stoppedRestriction = PartitionRestriction.stop((PartitionRestriction)restriction);
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(stoppedRestriction);
        tracker.checkDone();
    }

    @Property
    public void testGetProgressWorkCompletedAndWorkRemaining(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to, @From(value=TimestampGenerator.class) Timestamp curTimestamp) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)curTimestamp, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)from));
        Assume.assumeThat((Object)curTimestamp, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)from.getSeconds(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1L)));
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        PartitionPosition position = PartitionPosition.queryChangeStream((Timestamp)curTimestamp);
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        RestrictionTracker.Progress progress = tracker.getProgress();
        Assert.assertEquals((double)((Timestamp)position.getTimestamp().get()).getSeconds(), (double)progress.getWorkCompleted(), (double)1.0E-10);
        Assert.assertEquals((double)(to.getSeconds() - ((Timestamp)position.getTimestamp().get()).getSeconds()), (double)progress.getWorkRemaining(), (double)1.0E-10);
    }

    @Property
    public void testGetProgressWaitForChildPartitions(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)from.getSeconds(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1L)));
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        PartitionPosition position = PartitionPosition.waitForChildPartitions();
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        RestrictionTracker.Progress progress = tracker.getProgress();
        Assert.assertEquals((double)to.getSeconds(), (double)progress.getWorkCompleted(), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)progress.getWorkRemaining(), (double)1.0E-10);
    }

    @Property
    public void testGetProgressWaitForChildPartitionsNoStateClaimed(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Timestamp.MIN_VALUE));
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)from.getSeconds(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1L)));
        PartitionRestriction restriction = PartitionRestriction.waitForChildPartitions((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        RestrictionTracker.Progress progress = tracker.getProgress();
        Assert.assertEquals((double)to.getSeconds(), (double)progress.getWorkCompleted(), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)progress.getWorkRemaining(), (double)1.0E-10);
    }

    @Property
    public void testGetProgressUpdateState(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)from.getSeconds(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1L)));
        PartitionRestriction restriction = PartitionRestriction.updateState((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        PartitionPosition position = PartitionPosition.updateState();
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        RestrictionTracker.Progress progress = tracker.getProgress();
        Assert.assertEquals((double)from.getSeconds(), (double)progress.getWorkCompleted(), (double)1.0E-10);
        Assert.assertEquals((double)(to.getSeconds() - from.getSeconds()), (double)progress.getWorkRemaining(), (double)1.0E-10);
    }

    @Property
    public void testGetProgressUpdateStateNoPositionClaimed(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)from.getSeconds(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1L)));
        PartitionRestriction restriction = PartitionRestriction.updateState((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        RestrictionTracker.Progress progress = tracker.getProgress();
        Assert.assertEquals((double)from.getSeconds(), (double)progress.getWorkCompleted(), (double)1.0E-10);
        Assert.assertEquals((double)(to.getSeconds() - from.getSeconds()), (double)progress.getWorkRemaining(), (double)1.0E-10);
    }

    @Property
    public void testGetProgressDone(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)from.getSeconds(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1L)));
        PartitionRestriction restriction = PartitionRestriction.waitForChildPartitions((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(restriction);
        PartitionPosition position = PartitionPosition.done();
        Assert.assertTrue((boolean)tracker.tryClaim(position));
        RestrictionTracker.Progress progress = tracker.getProgress();
        Assert.assertEquals((double)to.getSeconds(), (double)progress.getWorkCompleted(), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)progress.getWorkRemaining(), (double)1.0E-10);
    }

    @Property
    public void testGetProgressStop(@From(value=TimestampGenerator.class) Timestamp from, @From(value=TimestampGenerator.class) Timestamp to) {
        Assume.assumeThat((Object)from, (Matcher)Matchers.lessThan((Comparable)to));
        Assume.assumeThat((Object)from.getSeconds(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1L)));
        PartitionRestriction restriction = PartitionRestriction.waitForChildPartitions((Timestamp)from, (Timestamp)to).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(PARTITION_TOKEN).build());
        PartitionRestriction stoppedRestriction = PartitionRestriction.stop((PartitionRestriction)restriction);
        PartitionRestrictionTracker tracker = new PartitionRestrictionTracker(stoppedRestriction);
        RestrictionTracker.Progress progress = tracker.getProgress();
        Assert.assertEquals((double)to.getSeconds(), (double)progress.getWorkCompleted(), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)progress.getWorkRemaining(), (double)1.0E-10);
    }
}

