/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionMode;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestriction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PartitionRestrictionTest {
    private Timestamp startTimestamp;
    private Timestamp endTimestamp;

    @Before
    public void setUp() throws Exception {
        this.startTimestamp = Timestamp.MIN_VALUE;
        this.endTimestamp = Timestamp.MAX_VALUE;
    }

    @Test
    public void testUpdateStateRestriction() {
        Assert.assertEquals((Object)PartitionRestriction.updateState((Timestamp)this.startTimestamp, (Timestamp)this.endTimestamp), (Object)new PartitionRestriction(this.startTimestamp, this.endTimestamp, PartitionMode.UPDATE_STATE, null));
    }

    @Test
    public void testQueryChangeStreamRestriction() {
        Assert.assertEquals((Object)PartitionRestriction.queryChangeStream((Timestamp)this.startTimestamp, (Timestamp)this.endTimestamp), (Object)new PartitionRestriction(this.startTimestamp, this.endTimestamp, PartitionMode.QUERY_CHANGE_STREAM, null));
    }

    @Test
    public void testWaitForChildPartitionsRestriction() {
        Assert.assertEquals((Object)PartitionRestriction.waitForChildPartitions((Timestamp)this.startTimestamp, (Timestamp)this.endTimestamp), (Object)new PartitionRestriction(this.startTimestamp, this.endTimestamp, PartitionMode.WAIT_FOR_CHILD_PARTITIONS, null));
    }

    @Test
    public void testDoneRestriction() {
        Assert.assertEquals((Object)PartitionRestriction.done((Timestamp)this.startTimestamp, (Timestamp)this.endTimestamp), (Object)new PartitionRestriction(this.startTimestamp, this.endTimestamp, PartitionMode.DONE, null));
    }

    @Test
    public void testStopRestriction() {
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)this.startTimestamp, (Timestamp)this.endTimestamp);
        Assert.assertEquals((Object)PartitionRestriction.stop((PartitionRestriction)restriction), (Object)new PartitionRestriction(this.startTimestamp, this.endTimestamp, PartitionMode.STOP, PartitionMode.QUERY_CHANGE_STREAM));
    }
}

