/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionPosition;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestriction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestrictionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestrictionSplitter;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PartitionRestrictionSplitterTest {
    private Timestamp startTimestamp;
    private Timestamp endTimestamp;
    private PartitionRestriction restriction;
    private PartitionRestriction initialRestriction;
    private PartitionRestrictionSplitter splitter;

    @Before
    public void setUp() {
        this.startTimestamp = Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0);
        this.endTimestamp = Timestamp.ofTimeSecondsAndNanos((long)100L, (int)50);
        this.restriction = PartitionRestriction.queryChangeStream((Timestamp)this.startTimestamp, (Timestamp)this.endTimestamp).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken("partitionToken").build());
        this.initialRestriction = PartitionRestriction.queryChangeStream((Timestamp)this.startTimestamp, (Timestamp)this.endTimestamp).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken("Parent0").build());
        this.splitter = new PartitionRestrictionSplitter();
    }

    @Test
    public void testLastClaimedPositionIsNull() {
        SplitResult splitResult = this.splitter.trySplit(0.0, null, this.restriction);
        Assert.assertNull((Object)splitResult);
    }

    @Test
    public void testUpdateState() {
        PartitionPosition position = PartitionPosition.updateState();
        SplitResult splitResult = this.splitter.trySplit(0.0, position, this.restriction);
        Assert.assertEquals((Object)SplitResult.of((Object)PartitionRestriction.stop((PartitionRestriction)this.restriction), (Object)PartitionRestriction.queryChangeStream((Timestamp)this.startTimestamp, (Timestamp)this.endTimestamp)), (Object)splitResult);
    }

    @Test
    public void testQueryChangeStreamInitialPartition() {
        PartitionPosition position = PartitionPosition.queryChangeStream((Timestamp)Timestamp.ofTimeMicroseconds((long)1L));
        SplitResult splitResult = this.splitter.trySplit(0.0, position, this.initialRestriction);
        Assert.assertNull((Object)splitResult);
    }

    @Test
    public void testQueryChangeStream() {
        PartitionPosition position = PartitionPosition.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)50L, (int)0));
        SplitResult splitResult = this.splitter.trySplit(0.0, position, this.restriction);
        Assert.assertEquals((Object)SplitResult.of((Object)PartitionRestriction.queryChangeStream((Timestamp)this.startTimestamp, (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)50L, (int)1)), (Object)PartitionRestriction.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)50L, (int)1), (Timestamp)this.endTimestamp)), (Object)splitResult);
    }

    @Test
    public void testQueryChangeStreamSplitEqualToEndTimestamp() {
        PartitionPosition position = PartitionPosition.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)100L, (int)49));
        SplitResult splitResult = this.splitter.trySplit(0.0, position, this.restriction);
        Assert.assertEquals((Object)SplitResult.of((Object)PartitionRestriction.stop((PartitionRestriction)this.restriction), (Object)PartitionRestriction.waitForChildPartitions((Timestamp)this.startTimestamp, (Timestamp)this.endTimestamp)), (Object)splitResult);
    }

    @Test
    public void testQueryChangeStreamSplitGreaterThanEndTimestamp() {
        PartitionPosition position = PartitionPosition.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)100L, (int)50));
        SplitResult splitResult = this.splitter.trySplit(0.0, position, this.restriction);
        Assert.assertEquals((Object)SplitResult.of((Object)PartitionRestriction.stop((PartitionRestriction)this.restriction), (Object)PartitionRestriction.waitForChildPartitions((Timestamp)this.startTimestamp, (Timestamp)this.endTimestamp)), (Object)splitResult);
    }

    @Test
    public void testWaitForChildPartitions() {
        PartitionPosition position = PartitionPosition.waitForChildPartitions();
        SplitResult splitResult = this.splitter.trySplit(0.0, position, this.restriction);
        Assert.assertEquals((Object)SplitResult.of((Object)PartitionRestriction.stop((PartitionRestriction)this.restriction), (Object)PartitionRestriction.waitForChildPartitions((Timestamp)this.startTimestamp, (Timestamp)this.endTimestamp)), (Object)splitResult);
    }

    @Test
    public void testDone() {
        PartitionPosition position = PartitionPosition.done();
        SplitResult splitResult = this.splitter.trySplit(0.0, position, this.restriction);
        Assert.assertNull((Object)splitResult);
    }

    @Test
    public void testStop() {
        PartitionPosition position = PartitionPosition.stop();
        SplitResult splitResult = this.splitter.trySplit(0.0, position, this.restriction);
        Assert.assertNull((Object)splitResult);
    }
}

