/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionPosition;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestriction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestrictionProgressChecker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PartitionRestrictionProgressCheckerTest {
    private PartitionRestrictionProgressChecker progressChecker;

    @Before
    public void setUp() {
        this.progressChecker = new PartitionRestrictionProgressChecker();
    }

    @Test
    public void testRestrictionUpdateStateAndLastClaimedPositionNull() {
        PartitionRestriction restriction = PartitionRestriction.updateState((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0), (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)60L, (int)0));
        RestrictionTracker.Progress progress = this.progressChecker.getProgress(restriction, null);
        Assert.assertEquals((Object)RestrictionTracker.Progress.from((double)0.0, (double)60.0), (Object)progress);
    }

    @Test
    public void testRestrictionUpdateStateAndLastClaimedPositionUpdateState() {
        PartitionRestriction restriction = PartitionRestriction.updateState((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0), (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)60L, (int)60));
        PartitionPosition position = PartitionPosition.updateState();
        RestrictionTracker.Progress progress = this.progressChecker.getProgress(restriction, position);
        Assert.assertEquals((Object)RestrictionTracker.Progress.from((double)0.0, (double)60.0), (Object)progress);
    }

    @Test
    public void testRestrictionQueryChangeStreamAndLastClaimedPositionNull() {
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)10), (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)60L, (int)60));
        RestrictionTracker.Progress progress = this.progressChecker.getProgress(restriction, null);
        Assert.assertEquals((Object)RestrictionTracker.Progress.from((double)0.0, (double)60.0), (Object)progress);
    }

    @Test
    public void testRestrictionQueryChangeStreamAndLastClaimedPositionQueryChangeStream() {
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)10), (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)60L, (int)60));
        PartitionPosition position = PartitionPosition.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)30L, (int)30));
        RestrictionTracker.Progress progress = this.progressChecker.getProgress(restriction, position);
        Assert.assertEquals((Object)RestrictionTracker.Progress.from((double)30.0, (double)30.0), (Object)progress);
    }

    @Test
    public void testRestrictionQueryChangeStreamAndLastClaimedPositionEndOfQueryChangeStream() {
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)10), (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)60L, (int)60));
        PartitionPosition position = PartitionPosition.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)60L, (int)60));
        RestrictionTracker.Progress progress = this.progressChecker.getProgress(restriction, position);
        Assert.assertEquals((Object)RestrictionTracker.Progress.from((double)60.0, (double)1.0), (Object)progress);
    }

    @Test
    public void testRestrictionQueryChangeStreamAndLastClaimedPositionWaitForChildPartitions() {
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)10), (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)60L, (int)60));
        PartitionPosition position = PartitionPosition.waitForChildPartitions();
        RestrictionTracker.Progress progress = this.progressChecker.getProgress(restriction, position);
        Assert.assertEquals((Object)RestrictionTracker.Progress.from((double)60.0, (double)1.0), (Object)progress);
    }

    @Test
    public void testRestrictionQueryChangeStreamAndLastClaimedPositionDone() {
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)10), (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)60L, (int)60));
        PartitionPosition position = PartitionPosition.done();
        RestrictionTracker.Progress progress = this.progressChecker.getProgress(restriction, position);
        Assert.assertEquals((Object)RestrictionTracker.Progress.from((double)60.0, (double)1.0), (Object)progress);
    }

    @Test
    public void testRestrictionWaitForChildPartitionsAndLastClaimedPositionNull() {
        PartitionRestriction restriction = PartitionRestriction.waitForChildPartitions((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)10), (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)60L, (int)60));
        RestrictionTracker.Progress progress = this.progressChecker.getProgress(restriction, null);
        Assert.assertEquals((Object)RestrictionTracker.Progress.from((double)60.0, (double)1.0), (Object)progress);
    }

    @Test
    public void testRestrictionWaitForChildPartitionsAndLastClaimedPositionWaitForChildPartitions() {
        PartitionRestriction restriction = PartitionRestriction.waitForChildPartitions((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)10), (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)60L, (int)60));
        PartitionPosition position = PartitionPosition.waitForChildPartitions();
        RestrictionTracker.Progress progress = this.progressChecker.getProgress(restriction, position);
        Assert.assertEquals((Object)RestrictionTracker.Progress.from((double)60.0, (double)1.0), (Object)progress);
    }

    @Test
    public void testRestrictionWaitForChildPartitionsAndLastClaimedPositionDone() {
        PartitionRestriction restriction = PartitionRestriction.waitForChildPartitions((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)10), (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)60L, (int)60));
        PartitionPosition position = PartitionPosition.done();
        RestrictionTracker.Progress progress = this.progressChecker.getProgress(restriction, position);
        Assert.assertEquals((Object)RestrictionTracker.Progress.from((double)60.0, (double)1.0), (Object)progress);
    }

    @Test
    public void testRestrictionDoneAndLastClaimedPositionDone() {
        PartitionRestriction restriction = PartitionRestriction.done((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)10), (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)60L, (int)60));
        PartitionPosition position = PartitionPosition.done();
        RestrictionTracker.Progress progress = this.progressChecker.getProgress(restriction, position);
        Assert.assertEquals((Object)RestrictionTracker.Progress.from((double)60.0, (double)1.0), (Object)progress);
    }

    @Test
    public void testRestrictionStopQueryChangeStream() {
        PartitionRestriction stoppedRestriction = PartitionRestriction.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)10), (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)60L, (int)60));
        PartitionRestriction restriction = PartitionRestriction.stop((PartitionRestriction)stoppedRestriction);
        RestrictionTracker.Progress progress = this.progressChecker.getProgress(restriction, null);
        Assert.assertEquals((Object)RestrictionTracker.Progress.from((double)60.0, (double)1.0), (Object)progress);
    }

    @Test
    public void testRestrictionStopWaitForChildPartitions() {
        PartitionRestriction stoppedRestriction = PartitionRestriction.waitForChildPartitions((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)10), (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)60L, (int)60));
        PartitionRestriction restriction = PartitionRestriction.stop((PartitionRestriction)stoppedRestriction);
        RestrictionTracker.Progress progress = this.progressChecker.getProgress(restriction, null);
        Assert.assertEquals((Object)RestrictionTracker.Progress.from((double)60.0, (double)1.0), (Object)progress);
    }

    @Test
    public void testRestrictionStopDone() {
        PartitionRestriction stoppedRestriction = PartitionRestriction.done((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)10), (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)60L, (int)60));
        PartitionRestriction restriction = PartitionRestriction.stop((PartitionRestriction)stoppedRestriction);
        RestrictionTracker.Progress progress = this.progressChecker.getProgress(restriction, null);
        Assert.assertEquals((Object)RestrictionTracker.Progress.from((double)60.0, (double)1.0), (Object)progress);
    }

    @Test
    public void testGetProgressForStreaming() {
        Timestamp from = Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0);
        Timestamp current = Timestamp.ofTimeSecondsAndNanos((long)101L, (int)0);
        PartitionPosition position = PartitionPosition.queryChangeStream((Timestamp)current);
        PartitionRestriction restriction = PartitionRestriction.queryChangeStream((Timestamp)from, (Timestamp)Timestamp.MAX_VALUE);
        this.progressChecker.setTimeSupplier(() -> Timestamp.ofTimeSecondsAndNanos((long)(((Timestamp)position.getTimestamp().get()).getSeconds() + 10L), (int)0));
        RestrictionTracker.Progress progress = this.progressChecker.getProgress(restriction, position);
        Assert.assertEquals((Object)RestrictionTracker.Progress.from((double)101.0, (double)10.0), (Object)progress);
    }
}

