/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.util.Optional;
import java.util.Set;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionMode;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionPosition;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestriction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestrictionClaimer;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionRestrictionMetadata;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PartitionRestrictionClaimerTest {
    private PartitionRestrictionClaimer claimer;
    private String partitionToken;

    @Before
    public void setUp() {
        this.partitionToken = "partitionToken";
        this.claimer = new PartitionRestrictionClaimer();
    }

    @Test
    public void testQueryChangeStreamEqualToLastClaimedTimestamp() {
        boolean canClaim = this.claimer.tryClaim(PartitionRestriction.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)0), (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)20L, (int)0)).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(this.partitionToken).build()), PartitionPosition.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)15L, (int)0)), PartitionPosition.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)15L, (int)0)));
        Assert.assertTrue((boolean)canClaim);
    }

    @Test
    public void testQueryChangeStreamWithinRestrictionRange() {
        boolean canClaim = this.claimer.tryClaim(PartitionRestriction.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)0), (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)20L, (int)0)).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(this.partitionToken).build()), PartitionPosition.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)0)), PartitionPosition.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)15L, (int)0)));
        Assert.assertTrue((boolean)canClaim);
    }

    @Test
    public void testQueryChangeStreamWithStartTimestamp() {
        boolean canClaim = this.claimer.tryClaim(PartitionRestriction.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)0), (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)20L, (int)0)).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(this.partitionToken).build()), PartitionPosition.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)0)), PartitionPosition.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)0)));
        Assert.assertTrue((boolean)canClaim);
    }

    @Test
    public void testQueryChangeStreamWithEndTimestamp() {
        boolean canClaim = this.claimer.tryClaim(PartitionRestriction.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)0), (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)20L, (int)0)).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(this.partitionToken).build()), PartitionPosition.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)0)), PartitionPosition.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)20L, (int)0)));
        Assert.assertFalse((boolean)canClaim);
    }

    @Test
    public void testQueryChangeStreamAfterEndTimestamp() {
        boolean canClaim = this.claimer.tryClaim(PartitionRestriction.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)0), (Timestamp)Timestamp.ofTimeSecondsAndNanos((long)20L, (int)0)).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(this.partitionToken).build()), PartitionPosition.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)10L, (int)0)), PartitionPosition.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)20L, (int)1)));
        Assert.assertFalse((boolean)canClaim);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQueryChangeStreamWithoutTimestamp() {
        this.claimer.tryClaim(PartitionRestriction.queryChangeStream((Timestamp)Timestamp.MIN_VALUE, (Timestamp)Timestamp.MAX_VALUE).withMetadata(PartitionRestrictionMetadata.newBuilder().withPartitionToken(this.partitionToken).build()), PartitionPosition.queryChangeStream((Timestamp)Timestamp.MIN_VALUE), new PartitionPosition(Optional.empty(), PartitionMode.QUERY_CHANGE_STREAM));
    }

    @Test
    public void testUpdateStateTransitions() {
        new TryClaimTestScenario(this.claimer).from(PartitionMode.UPDATE_STATE).to(PartitionMode.UPDATE_STATE, PartitionMode.QUERY_CHANGE_STREAM).withTryClaimResultAs(true).run();
    }

    @Test
    public void testQueryChangeStreamTransitions() {
        new TryClaimTestScenario(this.claimer).from(PartitionMode.QUERY_CHANGE_STREAM).to(PartitionMode.QUERY_CHANGE_STREAM, PartitionMode.WAIT_FOR_CHILD_PARTITIONS).withTryClaimResultAs(true).run();
    }

    @Test
    public void testWaitForChildPartitionsTransitions() {
        new TryClaimTestScenario(this.claimer).from(PartitionMode.WAIT_FOR_CHILD_PARTITIONS).to(PartitionMode.WAIT_FOR_CHILD_PARTITIONS, PartitionMode.DONE).withTryClaimResultAs(true).run();
    }

    @Test
    public void testDoneTransitions() {
        new TryClaimTestScenario(this.claimer).from(PartitionMode.DONE).to(new PartitionMode[0]).run();
    }

    @Test
    public void testStopTransitionsAlwaysReturnsFalse() {
        new TryClaimTestScenario(this.claimer).from(PartitionMode.STOP).to(PartitionMode.values()).withTryClaimResultAs(false).run();
    }

    private static class TryClaimTestScenario {
        private final PartitionRestrictionClaimer claimer;
        private PartitionMode from;
        private Set<PartitionMode> validTransitions;
        private boolean expectedTryClaimResult;

        public TryClaimTestScenario(PartitionRestrictionClaimer claimer) {
            this.claimer = claimer;
        }

        public TryClaimTestScenario from(PartitionMode from) {
            this.from = from;
            return this;
        }

        public TryClaimTestScenario to(PartitionMode ... validTransitions) {
            this.validTransitions = Sets.newHashSet((Object[])validTransitions);
            return this;
        }

        public TryClaimTestScenario withTryClaimResultAs(boolean tryClaimResultAs) {
            this.expectedTryClaimResult = tryClaimResultAs;
            return this;
        }

        public void run() {
            PartitionRestrictionMetadata metadata = PartitionRestrictionMetadata.newBuilder().withPartitionToken("partitionToken").build();
            PartitionRestriction restriction = this.partitionRestrictionFrom(this.from).withMetadata(metadata);
            PartitionPosition lastClaimedPosition = this.partitionPositionFrom(this.from);
            for (PartitionMode to : PartitionMode.values()) {
                PartitionPosition position = this.partitionPositionFrom(to);
                if (this.validTransitions.contains(to)) {
                    Assert.assertEquals((Object)this.expectedTryClaimResult, (Object)this.claimer.tryClaim(restriction, lastClaimedPosition, position));
                    Assert.assertEquals((Object)this.expectedTryClaimResult, (Object)this.claimer.tryClaim(restriction, null, position));
                    continue;
                }
                Assert.assertThrows(IllegalArgumentException.class, () -> this.claimer.tryClaim(restriction, lastClaimedPosition, position));
                Assert.assertThrows(IllegalArgumentException.class, () -> this.claimer.tryClaim(restriction, null, position));
            }
        }

        private PartitionRestriction partitionRestrictionFrom(PartitionMode mode) {
            Timestamp startTimestamp = Timestamp.MIN_VALUE;
            Timestamp endTimestamp = Timestamp.MAX_VALUE;
            switch (mode) {
                case UPDATE_STATE: {
                    return PartitionRestriction.updateState((Timestamp)startTimestamp, (Timestamp)endTimestamp);
                }
                case QUERY_CHANGE_STREAM: {
                    return PartitionRestriction.queryChangeStream((Timestamp)startTimestamp, (Timestamp)endTimestamp);
                }
                case WAIT_FOR_CHILD_PARTITIONS: {
                    return PartitionRestriction.waitForChildPartitions((Timestamp)startTimestamp, (Timestamp)endTimestamp);
                }
                case DONE: {
                    return PartitionRestriction.done((Timestamp)startTimestamp, (Timestamp)endTimestamp);
                }
                case STOP: {
                    return PartitionRestriction.stop((PartitionRestriction)PartitionRestriction.queryChangeStream((Timestamp)startTimestamp, (Timestamp)endTimestamp));
                }
            }
            throw new IllegalArgumentException("Unknown mode " + mode);
        }

        private PartitionPosition partitionPositionFrom(PartitionMode mode) {
            switch (mode) {
                case UPDATE_STATE: {
                    return PartitionPosition.updateState();
                }
                case QUERY_CHANGE_STREAM: {
                    return PartitionPosition.queryChangeStream((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)1L, (int)0));
                }
                case WAIT_FOR_CHILD_PARTITIONS: {
                    return PartitionPosition.waitForChildPartitions();
                }
                case DONE: {
                    return PartitionPosition.done();
                }
                case STOP: {
                    return PartitionPosition.stop();
                }
            }
            throw new IllegalArgumentException("Unknown mode " + mode);
        }
    }
}

