/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Struct;
import java.util.Arrays;
import java.util.Collections;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.ChangeStreamResultSetMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.ChangeStreamRecordMapper;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChildPartition;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChildPartitionsRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ColumnType;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.DataChangeRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.HeartbeatRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.Mod;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ModType;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.TypeCode;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ValueCaptureType;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.util.TestStructMapper;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ChangeStreamRecordMapperTest {
    private ChangeStreamRecordMapper mapper;
    private PartitionMetadata partition;
    private ChangeStreamResultSetMetadata resultSetMetadata;

    @Before
    public void setUp() {
        this.mapper = new ChangeStreamRecordMapper();
        this.partition = PartitionMetadata.newBuilder().setPartitionToken("partitionToken").setParentTokens(Sets.newHashSet((Object[])new String[]{"parentToken"})).setHeartbeatMillis(30000L).setState(PartitionMetadata.State.RUNNING).setWatermark(Timestamp.ofTimeMicroseconds((long)10L)).setStartTimestamp(Timestamp.ofTimeMicroseconds((long)11L)).setEndTimestamp(Timestamp.ofTimeMicroseconds((long)12L)).setCreatedAt(Timestamp.ofTimeMicroseconds((long)13L)).setScheduledAt(Timestamp.ofTimeMicroseconds((long)14L)).setRunningAt(Timestamp.ofTimeMicroseconds((long)15L)).build();
        this.resultSetMetadata = (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class);
        Mockito.when((Object)this.resultSetMetadata.getQueryStartedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)1L));
        Mockito.when((Object)this.resultSetMetadata.getRecordStreamStartedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)2L));
        Mockito.when((Object)this.resultSetMetadata.getRecordStreamEndedAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)3L));
        Mockito.when((Object)this.resultSetMetadata.getRecordReadAt()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)4L));
        Mockito.when((Object)this.resultSetMetadata.getTotalStreamDuration()).thenReturn((Object)Duration.millis((long)100L));
        Mockito.when((Object)this.resultSetMetadata.getNumberOfRecordsRead()).thenReturn((Object)10000L);
    }

    @Test
    public void testMappingUpdateStructRowToDataChangeRecord() {
        DataChangeRecord dataChangeRecord = new DataChangeRecord("partitionToken", Timestamp.ofTimeSecondsAndNanos((long)10L, (int)20), "serverTransactionId", true, "1", "tableName", Arrays.asList(new ColumnType("column1", new TypeCode("type1"), true, 1L), new ColumnType("column2", new TypeCode("type2"), false, 2L)), Collections.singletonList(new Mod("{\"column1\": \"value1\"}", "{\"column2\": \"oldValue2\"}", "{\"column2\": \"newValue2\"}")), ModType.UPDATE, ValueCaptureType.OLD_AND_NEW_VALUES, 10L, 2L, null);
        Struct stringFieldsStruct = TestStructMapper.recordsToStructWithStrings(new ChangeStreamRecord[]{dataChangeRecord});
        Struct jsonFieldsStruct = TestStructMapper.recordsToStructWithJson(new ChangeStreamRecord[]{dataChangeRecord});
        Assert.assertEquals(Collections.singletonList(dataChangeRecord), (Object)this.mapper.toChangeStreamRecords(this.partition, stringFieldsStruct, this.resultSetMetadata));
        Assert.assertEquals(Collections.singletonList(dataChangeRecord), (Object)this.mapper.toChangeStreamRecords(this.partition, jsonFieldsStruct, this.resultSetMetadata));
    }

    @Test
    public void testMappingInsertStructRowToDataChangeRecord() {
        DataChangeRecord dataChangeRecord = new DataChangeRecord("partitionToken", Timestamp.ofTimeSecondsAndNanos((long)10L, (int)20), "transactionId", false, "1", "tableName", Arrays.asList(new ColumnType("column1", new TypeCode("type1"), true, 1L), new ColumnType("column2", new TypeCode("type2"), false, 2L)), Collections.singletonList(new Mod("{\"column1\": \"value1\"}", null, "{\"column2\": \"newValue2\"}")), ModType.INSERT, ValueCaptureType.OLD_AND_NEW_VALUES, 10L, 2L, null);
        Struct stringFieldsStruct = TestStructMapper.recordsToStructWithStrings(new ChangeStreamRecord[]{dataChangeRecord});
        Struct jsonFieldsStruct = TestStructMapper.recordsToStructWithJson(new ChangeStreamRecord[]{dataChangeRecord});
        Assert.assertEquals(Collections.singletonList(dataChangeRecord), (Object)this.mapper.toChangeStreamRecords(this.partition, stringFieldsStruct, this.resultSetMetadata));
        Assert.assertEquals(Collections.singletonList(dataChangeRecord), (Object)this.mapper.toChangeStreamRecords(this.partition, jsonFieldsStruct, this.resultSetMetadata));
    }

    @Test
    public void testMappingDeleteStructRowToDataChangeRecord() {
        DataChangeRecord dataChangeRecord = new DataChangeRecord("partitionToken", Timestamp.ofTimeSecondsAndNanos((long)10L, (int)20), "transactionId", false, "1", "tableName", Arrays.asList(new ColumnType("column1", new TypeCode("type1"), true, 1L), new ColumnType("column2", new TypeCode("type2"), false, 2L)), Collections.singletonList(new Mod("{\"column1\": \"value1\"}", "{\"column2\": \"oldValue2\"}", null)), ModType.DELETE, ValueCaptureType.OLD_AND_NEW_VALUES, 10L, 2L, null);
        Struct stringFieldsStruct = TestStructMapper.recordsToStructWithStrings(new ChangeStreamRecord[]{dataChangeRecord});
        Struct jsonFieldsStruct = TestStructMapper.recordsToStructWithJson(new ChangeStreamRecord[]{dataChangeRecord});
        Assert.assertEquals(Collections.singletonList(dataChangeRecord), (Object)this.mapper.toChangeStreamRecords(this.partition, stringFieldsStruct, this.resultSetMetadata));
        Assert.assertEquals(Collections.singletonList(dataChangeRecord), (Object)this.mapper.toChangeStreamRecords(this.partition, jsonFieldsStruct, this.resultSetMetadata));
    }

    @Test
    public void testMappingStructRowWithUnknownModTypeAndValueCaptureTypeToDataChangeRecord() {
        DataChangeRecord dataChangeRecord = new DataChangeRecord("partitionToken", Timestamp.ofTimeSecondsAndNanos((long)10L, (int)20), "transactionId", false, "1", "tableName", Arrays.asList(new ColumnType("column1", new TypeCode("type1"), true, 1L), new ColumnType("column2", new TypeCode("type2"), false, 2L)), Collections.singletonList(new Mod("{\"column1\": \"value1\"}", null, "{\"column2\": \"newValue2\"}")), ModType.UNKNOWN, ValueCaptureType.UNKNOWN, 10L, 2L, null);
        Struct struct = TestStructMapper.recordsWithUnknownModTypeAndValueCaptureType(new ChangeStreamRecord[]{dataChangeRecord});
        Assert.assertEquals(Collections.singletonList(dataChangeRecord), (Object)this.mapper.toChangeStreamRecords(this.partition, struct, this.resultSetMetadata));
    }

    @Test
    public void testMappingStructRowToHeartbeatRecord() {
        HeartbeatRecord heartbeatRecord = new HeartbeatRecord(Timestamp.ofTimeSecondsAndNanos((long)10L, (int)20), null);
        Struct struct = TestStructMapper.recordsToStructWithStrings(new ChangeStreamRecord[]{heartbeatRecord});
        Assert.assertEquals(Collections.singletonList(heartbeatRecord), (Object)this.mapper.toChangeStreamRecords(this.partition, struct, this.resultSetMetadata));
    }

    @Test
    public void testMappingStructRowToChildPartitionRecord() {
        ChildPartitionsRecord childPartitionsRecord = new ChildPartitionsRecord(Timestamp.ofTimeSecondsAndNanos((long)10L, (int)20), "1", Arrays.asList(new ChildPartition("childToken1", Sets.newHashSet((Object[])new String[]{"parentToken1", "parentToken2"})), new ChildPartition("childToken2", Sets.newHashSet((Object[])new String[]{"parentToken1", "parentToken2"}))), null);
        Struct struct = TestStructMapper.recordsToStructWithStrings(new ChangeStreamRecord[]{childPartitionsRecord});
        Assert.assertEquals(Collections.singletonList(childPartitionsRecord), (Object)this.mapper.toChangeStreamRecords(this.partition, struct, this.resultSetMetadata));
    }

    @Test
    public void testMappingStructRowFromInitialPartitionToChildPartitionRecord() {
        Struct struct = TestStructMapper.recordsToStructWithStrings(new ChangeStreamRecord[]{new ChildPartitionsRecord(Timestamp.ofTimeSecondsAndNanos((long)10L, (int)20), "1", Arrays.asList(new ChildPartition("childToken1", Sets.newHashSet()), new ChildPartition("childToken2", Sets.newHashSet())), null)});
        ChildPartitionsRecord expected = new ChildPartitionsRecord(Timestamp.ofTimeSecondsAndNanos((long)10L, (int)20), "1", Arrays.asList(new ChildPartition("childToken1", Sets.newHashSet((Object[])new String[]{"Parent0"})), new ChildPartition("childToken2", Sets.newHashSet((Object[])new String[]{"Parent0"}))), null);
        PartitionMetadata initialPartition = this.partition.toBuilder().setPartitionToken("Parent0").build();
        Assert.assertEquals(Collections.singletonList(expected), (Object)this.mapper.toChangeStreamRecords(initialPartition, struct, this.resultSetMetadata));
    }
}

