/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.encoder;

import com.google.cloud.Timestamp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.AvroEncode;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.encoder.TimestampEncoding;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimestampEncodingTest {
    private TimestampEncoding encoding;

    @Before
    public void setUp() {
        this.encoding = new TimestampEncoding();
    }

    @Test
    public void testWriteAndReadTimestamp() throws IOException {
        Timestamp expectedTimestamp = Timestamp.ofTimeSecondsAndNanos((long)10L, (int)20);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)outputStream, null);
        this.encoding.write((Object)expectedTimestamp, (Encoder)encoder);
        byte[] bytes = outputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)inputStream, null);
        Timestamp actualTimestamp = this.encoding.read(null, (Decoder)decoder);
        Assert.assertEquals((Object)expectedTimestamp, (Object)actualTimestamp);
    }

    @Test
    public void testWriteAndReadReuseTimestamp() throws IOException {
        Timestamp expectedTimestamp = Timestamp.ofTimeSecondsAndNanos((long)10L, (int)20);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)outputStream, null);
        this.encoding.write((Object)expectedTimestamp, (Encoder)encoder);
        byte[] bytes = outputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)inputStream, null);
        Timestamp actualTimestamp = this.encoding.read((Object)Timestamp.now(), (Decoder)decoder);
        Assert.assertEquals((Object)expectedTimestamp, (Object)actualTimestamp);
    }

    @Test
    public void testWriteAndReadNullTimestamp() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)outputStream, null);
        this.encoding.write(null, (Encoder)encoder);
        byte[] bytes = outputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)inputStream, null);
        Timestamp actualTimestamp = this.encoding.read(null, (Decoder)decoder);
        Assert.assertNull((Object)actualTimestamp);
    }

    @Test(expected=ClassCastException.class)
    public void testThrowsExceptionWhenWritingNonTimestamp() throws IOException {
        this.encoding.write((Object)1L, null);
    }

    @Test
    public void testReadAndWriteClassWithTimestampField() throws IOException {
        AvroCoder coder = AvroCoder.of(TestTimestamp.class);
        List<TestTimestamp> allExpected = Arrays.asList(new TestTimestamp(Timestamp.MIN_VALUE, Timestamp.MAX_VALUE), new TestTimestamp(Timestamp.ofTimeSecondsAndNanos((long)123L, (int)456), Timestamp.now()), new TestTimestamp(Timestamp.MIN_VALUE, null), new TestTimestamp(null, Timestamp.MAX_VALUE));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (TestTimestamp testTimestamp : allExpected) {
            coder.encode((Object)testTimestamp, (OutputStream)outputStream);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        for (TestTimestamp expected : allExpected) {
            TestTimestamp actual = (TestTimestamp)coder.decode((InputStream)inputStream);
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    private static class TestTimestamp {
        @AvroEncode(using=TimestampEncoding.class)
        private Timestamp timestamp1;
        @AvroEncode(using=TimestampEncoding.class)
        private Timestamp timestamp2;

        private TestTimestamp() {
        }

        private TestTimestamp(Timestamp timestamp1, Timestamp timestamp2) {
            this.timestamp1 = timestamp1;
            this.timestamp2 = timestamp2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TestTimestamp)) {
                return false;
            }
            TestTimestamp that = (TestTimestamp)o;
            return Objects.equals(this.timestamp1, that.timestamp1) && Objects.equals(this.timestamp2, that.timestamp2);
        }

        public int hashCode() {
            return Objects.hash(this.timestamp1, this.timestamp2);
        }
    }
}

